/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.hierarchy.TypeHierarchy;

public class HierarchyScope
implements IRubySearchScope {
    public IType focusType;
    private String focusPath;
    private WorkingCopyOwner owner;
    private ITypeHierarchy hierarchy;
    private IType[] types;
    private HashSet resourcePaths;
    private IPath[] enclosingProjectsAndJars;
    protected IResource[] elements;
    protected int elementCount;
    public boolean needsRefresh;

    public void add(IResource element) {
        if (this.elementCount == this.elements.length) {
            this.elements = new IResource[this.elementCount * 2];
            System.arraycopy(this.elements, 0, this.elements, 0, this.elementCount);
        }
        this.elements[this.elementCount++] = element;
    }

    public HierarchyScope(IType type, WorkingCopyOwner owner) throws RubyModelException {
        this.focusType = type;
        this.owner = owner;
        this.enclosingProjectsAndJars = this.computeProjectsAndJars(type);
        ISourceFolderRoot cfr_ignored_0 = (ISourceFolderRoot)type.getSourceFolder().getParent();
        this.focusPath = type.getPath().toString();
        this.needsRefresh = true;
    }

    private void buildResourceVector() {
        HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
        HashMap<IPath, IType> paths = new HashMap<IPath, IType>();
        this.types = this.hierarchy.getAllTypes();
        ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < this.types.length) {
            IType type = this.types[i];
            IResource resource = type.getResource();
            if (resource != null && resources.get(resource) == null) {
                resources.put(resource, resource);
                this.add(resource);
            }
            ISourceFolderRoot cfr_ignored_0 = (ISourceFolderRoot)type.getSourceFolder().getParent();
            paths.put(type.getRubyProject().getProject().getFullPath(), type);
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[paths.size()];
        i = 0;
        Iterator iter = paths.keySet().iterator();
        while (iter.hasNext()) {
            this.enclosingProjectsAndJars[i++] = (IPath)iter.next();
        }
    }

    private IPath[] computeProjectsAndJars(IType type) throws RubyModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        ISourceFolderRoot root = (ISourceFolderRoot)type.getSourceFolder().getParent();
        if (root.isArchive()) {
            set.add(root.getPath());
            IPath rootPath = root.getPath();
            RubyModel model = RubyModelManager.getRubyModelManager().getRubyModel();
            IRubyProject[] projects = model.getRubyProjects();
            HashSet visited = new HashSet();
            int i = 0;
            while (i < projects.length) {
                RubyProject project = (RubyProject)projects[i];
                ILoadpathEntry[] classpath = project.getResolvedLoadpath(true, false, false);
                int j = 0;
                while (j < classpath.length) {
                    if (rootPath.equals((Object)classpath[j].getPath())) {
                        project.getAllSourceFolderRoots();
                        set.add(project.getPath());
                        this.computeDependents(project, set, visited);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            IRubyProject project = (IRubyProject)root.getParent();
            ISourceFolderRoot[] roots = project.getAllSourceFolderRoots();
            int i = 0;
            while (i < roots.length) {
                ISourceFolderRoot pkgFragmentRoot = roots[i];
                set.add(pkgFragmentRoot.getParent().getPath());
                ++i;
            }
            this.computeDependents(project, set, new HashSet());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    private void computeDependents(IRubyProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject[] dependents = project.getProject().getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            try {
                IRubyProject dependent = RubyCore.create(dependents[i]);
                ISourceFolderRoot[] roots = dependent.getSourceFolderRoots();
                set.add(dependent.getPath());
                int j = 0;
                while (j < roots.length) {
                    ISourceFolderRoot pkgFragmentRoot = roots[j];
                    if (pkgFragmentRoot.isArchive()) {
                        set.add(pkgFragmentRoot.getPath());
                    }
                    ++j;
                }
                this.computeDependents(dependent, set, visited);
            }
            catch (RubyModelException rubyModelException) {}
            ++i;
        }
    }

    public boolean encloses(String resourcePath) {
        if (this.hierarchy == null) {
            if (resourcePath.equals(this.focusPath)) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (RubyModelException rubyModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (RubyModelException rubyModelException) {
                return false;
            }
        }
        int i = 0;
        while (i < this.elementCount) {
            if (resourcePath.startsWith(this.elements[i].getFullPath().toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(IRubyElement element) {
        if (this.hierarchy == null) {
            if (this.focusType.equals(element.getAncestor(5))) {
                return true;
            }
            if (this.needsRefresh) {
                try {
                    this.initialize();
                }
                catch (RubyModelException rubyModelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (RubyModelException rubyModelException) {
                return false;
            }
        }
        IType type = null;
        if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        if (type != null) {
            if (this.hierarchy.contains(type)) {
                return true;
            }
            IType original = (IType)type.getPrimaryElement();
            if (original != null) {
                return this.hierarchy.contains(original);
            }
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.needsRefresh) {
            try {
                this.refresh();
            }
            catch (RubyModelException rubyModelException) {
                return new IPath[0];
            }
        }
        return this.enclosingProjectsAndJars;
    }

    protected void initialize() throws RubyModelException {
        this.resourcePaths = new HashSet();
        this.elements = new IResource[5];
        this.elementCount = 0;
        this.needsRefresh = false;
        if (this.hierarchy == null) {
            this.hierarchy = this.focusType.newTypeHierarchy(this.owner, null);
        } else {
            this.hierarchy.refresh(null);
        }
        this.buildResourceVector();
    }

    public void processDelta(IRubyElementDelta delta) {
        if (this.needsRefresh) {
            return;
        }
        this.needsRefresh = this.hierarchy == null ? false : ((TypeHierarchy)this.hierarchy).isAffected(delta);
    }

    protected void refresh() throws RubyModelException {
        if (this.hierarchy != null) {
            this.initialize();
        }
    }

    public String toString() {
        return "HierarchyScope on " + ((RubyElement)((Object)this.focusType)).toStringWithAncestors();
    }
}

