/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.pmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.rubypeople.rdt.internal.core.pmd.CPDListener;
import org.rubypeople.rdt.internal.core.pmd.CPDNullListener;
import org.rubypeople.rdt.internal.core.pmd.Match;
import org.rubypeople.rdt.internal.core.pmd.MatchCollector;
import org.rubypeople.rdt.internal.core.pmd.SourceCode;
import org.rubypeople.rdt.internal.core.pmd.TokenEntry;
import org.rubypeople.rdt.internal.core.pmd.Tokens;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchAlgorithm {
    private static final int MOD = 37;
    private int lastHash;
    private int lastMod = 1;
    private List<Match> matches;
    private Map source;
    private Tokens tokens;
    private List code;
    private CPDListener cpdListener;
    private int min;

    public MatchAlgorithm(Map sourceCode, Tokens tokens, int min) {
        this(sourceCode, tokens, min, new CPDNullListener());
    }

    public MatchAlgorithm(Map sourceCode, Tokens tokens, int min, CPDListener listener) {
        this.source = sourceCode;
        this.tokens = tokens;
        this.code = tokens.getTokens();
        this.min = min;
        this.cpdListener = listener;
        int i = 0;
        while (i < min) {
            this.lastMod *= 37;
            ++i;
        }
    }

    public void setListener(CPDListener listener) {
        this.cpdListener = listener;
    }

    public Iterator<Match> matches() {
        return this.matches.iterator();
    }

    public TokenEntry tokenAt(int offset, TokenEntry m) {
        return (TokenEntry)this.code.get(offset + m.getIndex());
    }

    public int getMinimumTileSize() {
        return this.min;
    }

    public void findMatches() {
        this.cpdListener.phaseUpdate(1);
        Map markGroups = this.hash();
        this.cpdListener.phaseUpdate(2);
        MatchCollector matchCollector = new MatchCollector(this);
        Iterator<Object> i = markGroups.values().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof List) {
                Collections.reverse((List)o);
                matchCollector.collect((List)o);
            }
            i.remove();
        }
        this.cpdListener.phaseUpdate(3);
        this.matches = matchCollector.getMatches();
        matchCollector = null;
        for (Match match : this.matches) {
            Iterator<TokenEntry> occurrences = match.iterator();
            while (occurrences.hasNext()) {
                TokenEntry mark = occurrences.next();
                match.setLineCount(this.tokens.getLineCount(mark, match));
                if (occurrences.hasNext()) continue;
                int start = mark.getBeginLine();
                int end = start + match.getLineCount() - 1;
                SourceCode sourceCode = (SourceCode)this.source.get(mark.getTokenSrcID());
                match.setSourceCodeSlice(sourceCode.getSlice(start, end));
            }
        }
        this.cpdListener.phaseUpdate(4);
    }

    private Map hash() {
        HashMap<TokenEntry, Object> markGroups = new HashMap<TokenEntry, Object>(this.tokens.size());
        int i = this.code.size() - 1;
        while (i >= 0) {
            TokenEntry token = (TokenEntry)this.code.get(i);
            if (token != TokenEntry.EOF) {
                ArrayList<Object> l;
                int last = this.tokenAt(this.min, token).getIdentifier();
                this.lastHash = 37 * this.lastHash + token.getIdentifier() - this.lastMod * last;
                token.setHashCode(this.lastHash);
                Object o = markGroups.get(token);
                if (o == null) {
                    markGroups.put(token, token);
                } else if (o instanceof TokenEntry) {
                    l = new ArrayList<Object>();
                    l.add(o);
                    l.add(token);
                    markGroups.put(token, l);
                } else {
                    l = (ArrayList<Object>)o;
                    l.add(token);
                }
            } else {
                this.lastHash = 0;
                int end = Math.max(0, i - this.min + 1);
                while (i > end) {
                    token = (TokenEntry)this.code.get(i - 1);
                    this.lastHash = 37 * this.lastHash + token.getIdentifier();
                    if (token == TokenEntry.EOF) break;
                    --i;
                }
            }
            --i;
        }
        return markGroups;
    }
}

