/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser.warnings;

import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class ConstantReassignmentVisitor
extends RubyLintVisitor {
    private Set<String> assignedConstants = new HashSet<String>();
    private RootNode root;

    public ConstantReassignmentVisitor(String contents) {
        super(contents);
    }

    protected String getOptionKey() {
        return "org.rubypeople.rdt.core.compiler.problem.constantReassignment";
    }

    public Instruction visitRootNode(RootNode iVisited) {
        this.root = iVisited;
        return super.visitRootNode(iVisited);
    }

    public Instruction visitConstDeclNode(ConstDeclNode iVisited) {
        String namespace = ASTUtil.getNamespace((Node)this.root, iVisited.getPosition().getStartOffset());
        String name = String.valueOf(namespace) + "::" + iVisited.getName();
        if (this.assignedConstants.contains(name)) {
            this.createProblem(iVisited.getPosition(), "Reassignment of a constant");
        } else {
            this.assignedConstants.add(name);
        }
        return super.visitConstDeclNode(iVisited);
    }
}

