/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.jruby.CompatVersion;
import org.jruby.ast.Node;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.ParserSupport;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;
import org.jruby.util.KCode;
import org.rubypeople.rdt.internal.core.buffer.LRUCache;
import org.rubypeople.rdt.internal.core.builder.IoUtils;
import org.rubypeople.rdt.internal.core.parser.NullParserResult;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyParser {
    private final RubyParserPool pool;
    private IRubyWarnings warnings;
    private static boolean isDebug;
    private static LRUCache cachedASTs;
    private static int count;

    static {
        cachedASTs = new LRUCache(50);
        count = 0;
    }

    public RubyParser() {
        this((IRubyWarnings)new NullWarnings());
    }

    public RubyParser(IRubyWarnings warnings) {
        this.warnings = warnings;
        this.pool = RubyParserPool.getInstance();
    }

    private RubyParserResult parse(String fileName, Reader content) {
        if (fileName == null) {
            fileName = "";
        }
        DefaultRubyParser parser = null;
        try {
            parser = this.getDefaultRubyParser();
            parser.setWarnings(this.warnings);
            if (isDebug) {
                System.out.println("Parse count: " + count++ + " on file: " + fileName);
            }
            ParserConfiguration config = new ParserConfiguration(KCode.NIL, 0, true, false, CompatVersion.RUBY1_8);
            LexerSource lexerSource = LexerSource.getSource((String)fileName, (Reader)content, null, (ParserConfiguration)config);
            RubyParserResult rubyParserResult = parser.parse(config, lexerSource);
            return rubyParserResult;
        }
        catch (SyntaxException e) {
            throw e;
        }
        finally {
            IoUtils.closeQuietly(content);
            this.returnBorrowedParser(parser);
        }
    }

    protected void returnBorrowedParser(DefaultRubyParser parser) {
        this.pool.returnParser((org.jruby.parser.RubyParser)parser);
    }

    protected DefaultRubyParser getDefaultRubyParser() {
        ParserSupport support = new ParserSupport();
        ParserConfiguration config = new ParserConfiguration(KCode.NIL, 0, true, false, CompatVersion.RUBY1_8);
        support.setConfiguration(config);
        return new DefaultRubyParser(support);
    }

    public static void setDebugging(boolean b) {
        isDebug = b;
    }

    public static boolean isDebugging() {
        return isDebug;
    }

    public Node parse(IFile file) throws CoreException {
        return this.parse(file.getName(), new String(Util.getResourceContentsAsCharArray(file))).getAST();
    }

    public RubyParserResult parse(String source) {
        return this.parse((String)null, source);
    }

    public RubyParserResult parse(IFile file, String source) {
        String name = "";
        if (file != null) {
            name = file.getName();
        }
        return this.parse(name, source);
    }

    public RubyParserResult parse(String fileName, String source) {
        if (source == null) {
            return new NullParserResult();
        }
        RubyParserResult ast = (RubyParserResult)cachedASTs.get(source);
        if (ast != null) {
            return ast;
        }
        ast = this.parse(fileName, new StringReader(source));
        if (ast == null) {
            ast = new NullParserResult();
        }
        cachedASTs.put(source, ast);
        return ast;
    }
}

