/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;

abstract class DefaultProblem
extends CategorizedProblem {
    private ISourcePosition position;
    private String message;
    private int id;
    private String[] arguments;
    private static final String MARKER_TYPE_PROBLEM = "org.rubypeople.rdt.core.problem";
    private static final String MARKER_TYPE_TASK = "org.rubypeople.rdt.core.task";

    public DefaultProblem(ISourcePosition position, String message, int problemID) {
        this(position, message, problemID, null);
    }

    public DefaultProblem(ISourcePosition position, String message, int problemID, String[] args) {
        this.position = position;
        this.message = message;
        this.id = problemID;
        this.arguments = args;
    }

    public String getMessage() {
        return this.message;
    }

    public char[] getOriginatingFileName() {
        return this.position.getFile().toCharArray();
    }

    public int getSourceEnd() {
        return this.position.getEndOffset();
    }

    public int getSourceLineNumber() {
        return this.position.getStartLine();
    }

    public int getSourceStart() {
        return this.position.getStartOffset();
    }

    public String toString() {
        return String.valueOf(this.position.toString()) + " => " + this.message;
    }

    public int getID() {
        return this.id;
    }

    public String getMarkerType() {
        return this.isTask() ? MARKER_TYPE_TASK : MARKER_TYPE_PROBLEM;
    }

    public String[] getArguments() {
        return this.arguments;
    }
}

