/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.compiler.util.HashtableOfObject;
import org.rubypeople.rdt.internal.core.IPathRequestor;
import org.rubypeople.rdt.internal.core.Member;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.hierarchy.HierarchyBuilder;
import org.rubypeople.rdt.internal.core.hierarchy.TypeHierarchy;
import org.rubypeople.rdt.internal.core.search.HandleFactory;
import org.rubypeople.rdt.internal.core.search.IndexQueryRequestor;
import org.rubypeople.rdt.internal.core.search.RubySearchParticipant;
import org.rubypeople.rdt.internal.core.search.SubTypeSearchJob;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.indexing.IndexManager;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.Util;

public class IndexBasedHierarchyBuilder
extends HierarchyBuilder {
    public static final int MAXTICKS = 800;
    private IRubySearchScope scope;
    private HashMap binariesFromIndexMatches = new HashMap(10);

    public IndexBasedHierarchyBuilder(TypeHierarchy hierarchy, IRubySearchScope scope) throws RubyModelException {
        super(hierarchy);
        this.scope = scope;
    }

    public void build(boolean computeSubtypes) throws RubyModelException, CoreException {
        if (computeSubtypes) {
            IType focusType = this.getType();
            boolean focusIsObject = focusType.getElementName().equals(new String(IIndexConstants.OBJECT));
            int amountOfWorkForSubtypes = focusIsObject ? 5 : 80;
            SubProgressMonitor possibleSubtypesMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, amountOfWorkForSubtypes);
            HashSet localTypes = new HashSet(10);
            String[] allPossibleSubtypes = ((Member)((Object)focusType)).getOuterMostLocalContext() == null ? this.determinePossibleSubTypes(localTypes, (IProgressMonitor)possibleSubtypesMonitor) : new String[]{};
            if (allPossibleSubtypes != null) {
                SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 100 - amountOfWorkForSubtypes);
                this.hierarchy.initialize(allPossibleSubtypes.length);
                this.buildFromPotentialSubtypes(allPossibleSubtypes, localTypes, (IProgressMonitor)buildMonitor);
            }
        } else {
            this.hierarchy.initialize(1);
            this.buildSupertypes();
        }
    }

    private void buildFromPotentialSubtypes(String[] allPotentialSubTypes, HashSet localTypes, IProgressMonitor monitor) {
        int wcLength;
        IType focusType = this.getType();
        HashMap<String, IRubyScript> wcPaths = new HashMap<String, IRubyScript>();
        IRubyScript[] workingCopies = this.hierarchy.workingCopies;
        if (workingCopies != null && (wcLength = workingCopies.length) > 0) {
            String[] newPaths = new String[wcLength];
            int i = 0;
            while (i < wcLength) {
                IRubyScript workingCopy = workingCopies[i];
                String path = workingCopy.getPath().toString();
                wcPaths.put(path, workingCopy);
                newPaths[i] = path;
                ++i;
            }
            int potentialSubtypesLength = allPotentialSubTypes.length;
            String[] stringArray = allPotentialSubTypes;
            allPotentialSubTypes = new String[potentialSubtypesLength + wcLength];
            System.arraycopy(stringArray, 0, allPotentialSubTypes, 0, potentialSubtypesLength);
            System.arraycopy(newPaths, 0, allPotentialSubTypes, potentialSubtypesLength, wcLength);
        }
        int length = allPotentialSubTypes.length;
        Openable focusCU = (Openable)((Object)focusType.getRubyScript());
        String focusPath = null;
        if (focusCU != null) {
            focusPath = focusCU.getPath().toString();
            if (length > 0) {
                String[] stringArray = allPotentialSubTypes;
                allPotentialSubTypes = new String[length + 1];
                System.arraycopy(stringArray, 0, allPotentialSubTypes, 0, length);
                allPotentialSubTypes[length] = focusPath;
            } else {
                allPotentialSubTypes = new String[]{focusPath};
            }
            ++length;
        }
        Util.sortReverseOrder(allPotentialSubTypes);
        ArrayList<IOpenable> potentialSubtypes = new ArrayList<IOpenable>();
        try {
            HandleFactory factory = new HandleFactory();
            IRubyProject currentProject = null;
            if (monitor != null) {
                monitor.beginTask("", length * 2);
            }
            int i = 0;
            while (i < length) {
                block26: {
                    try {
                        Openable handle;
                        String resourcePath = allPotentialSubTypes[i];
                        if (i > 0 && resourcePath.equals(allPotentialSubTypes[i - 1])) break block26;
                        IRubyScript workingCopy = (IRubyScript)wcPaths.get(resourcePath);
                        if (workingCopy != null) {
                            handle = (Openable)((Object)workingCopy);
                        } else {
                            Openable openable = handle = resourcePath.equals(focusPath) ? focusCU : factory.createOpenable(resourcePath);
                            if (handle == null) break block26;
                        }
                        IRubyProject project = handle.getRubyProject();
                        if (currentProject == null) {
                            currentProject = project;
                            potentialSubtypes = new ArrayList(5);
                        } else if (!currentProject.equals(project)) {
                            this.buildForProject((RubyProject)currentProject, potentialSubtypes, workingCopies, localTypes, monitor);
                            currentProject = project;
                            potentialSubtypes = new ArrayList(5);
                        }
                        potentialSubtypes.add(handle);
                    }
                    catch (RubyModelException rubyModelException) {}
                }
                ++i;
            }
            try {
                if (currentProject == null) {
                    currentProject = focusType.getRubyProject();
                    potentialSubtypes.add(focusType.getRubyScript());
                }
                this.buildForProject((RubyProject)currentProject, potentialSubtypes, workingCopies, localTypes, monitor);
            }
            catch (RubyModelException rubyModelException) {}
            if (!this.hierarchy.contains(focusType)) {
                try {
                    currentProject = focusType.getRubyProject();
                    potentialSubtypes = new ArrayList();
                    potentialSubtypes.add(focusType.getRubyScript());
                    this.buildForProject((RubyProject)currentProject, potentialSubtypes, workingCopies, localTypes, monitor);
                }
                catch (RubyModelException rubyModelException) {}
            }
            if (!this.hierarchy.contains(focusType)) {
                this.hierarchy.addRootClass(focusType);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void buildForProject(RubyProject project, ArrayList potentialSubtypes, IRubyScript[] workingCopies, HashSet localTypes, IProgressMonitor monitor) throws RubyModelException {
        int openablesLength = potentialSubtypes.size();
        Openable[] openables = new Openable[openablesLength];
        potentialSubtypes.toArray(openables);
        if (openablesLength > 0) {
            IType focusType = this.getType();
            boolean inProjectOfFocusType = focusType != null && focusType.getRubyProject().equals(project);
            IRubyScript[] unitsToLookInside = null;
            if (inProjectOfFocusType) {
                IRubyScript unitToLookInside = focusType.getRubyScript();
                if (unitToLookInside != null) {
                    int wcLength;
                    int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
                    if (wcLength == 0) {
                        unitsToLookInside = new IRubyScript[]{unitToLookInside};
                    } else {
                        unitsToLookInside = new IRubyScript[wcLength + 1];
                        unitsToLookInside[0] = unitToLookInside;
                        System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
                    }
                } else {
                    unitsToLookInside = workingCopies;
                }
            }
            if (focusType != null) {
                Member declaringMember = ((Member)((Object)focusType)).getOuterMostLocalContext();
                if (declaringMember == null) {
                    if (!inProjectOfFocusType) {
                        focusType.getTypeQualifiedName("::").toCharArray();
                        String[] cfr_ignored_0 = ((SourceFolder)focusType.getSourceFolder()).names;
                    }
                } else {
                    Openable openable = (Openable)((Object)declaringMember.getRubyScript());
                    localTypes = new HashSet<String>();
                    localTypes.add(openable.getPath().toString());
                    this.hierarchyResolver.resolve(new Openable[]{openable}, localTypes, monitor);
                    return;
                }
            }
            this.hierarchyResolver.resolve(openables, localTypes, monitor);
        }
    }

    private String[] determinePossibleSubTypes(HashSet localTypes, IProgressMonitor monitor) {
        class PathCollector
        implements IPathRequestor {
            HashSet paths = new HashSet(10);
            private final /* synthetic */ HashSet val$localTypes;

            PathCollector(HashSet hashSet) {
                this.val$localTypes = hashSet;
            }

            public void acceptPath(String path, boolean containsLocalTypes) {
                this.paths.add(path);
                if (containsLocalTypes) {
                    this.val$localTypes.add(path);
                }
            }
        }
        PathCollector collector = new PathCollector(localTypes);
        try {
            if (monitor != null) {
                monitor.beginTask("", 800);
            }
            IndexBasedHierarchyBuilder.searchAllPossibleSubTypes(this.getType(), this.scope, this.binariesFromIndexMatches, collector, 3, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        HashSet paths = collector.paths;
        int length = paths.size();
        String[] result = new String[length];
        int count = 0;
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            result[count++] = (String)iter.next();
        }
        return result;
    }

    public static void searchAllPossibleSubTypes(IType type, IRubySearchScope scope, Map binariesFromIndexMatches, final IPathRequestor pathRequestor, int waitingPolicy, IProgressMonitor progressMonitor) {
        final Queue queue = new Queue();
        final HashtableOfObject foundSuperNames = new HashtableOfObject(5);
        IndexManager indexManager = RubyModelManager.getRubyModelManager().getIndexManager();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant) {
                SuperTypeReferencePattern record = (SuperTypeReferencePattern)indexRecord;
                boolean isLocalOrAnonymous = record.enclosingTypeName == IIndexConstants.ONE_ZERO;
                pathRequestor.acceptPath(documentPath, isLocalOrAnonymous);
                char[] typeName = record.simpleName;
                if (!isLocalOrAnonymous && !foundSuperNames.containsKey(typeName)) {
                    foundSuperNames.put(typeName, typeName);
                    queue.add(typeName);
                }
                return true;
            }
        };
        int superRefKind = type.isClass() ? 2 : 0;
        SuperTypeReferencePattern pattern = new SuperTypeReferencePattern(null, null, superRefKind, 8);
        MatchLocator.setFocus(pattern, type);
        SubTypeSearchJob job = new SubTypeSearchJob(pattern, new RubySearchParticipant(), scope, searchRequestor);
        int ticks = 0;
        queue.add(type.getElementName().toCharArray());
        try {
            while (queue.start <= queue.end) {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return;
                }
                char[] currentTypeName = queue.retrieve();
                if (CharOperation.equals(currentTypeName, IIndexConstants.OBJECT)) {
                    currentTypeName = null;
                }
                String simple = null;
                simple = currentTypeName == null ? "" : new String(currentTypeName);
                int index = simple.lastIndexOf("::");
                if (index != -1) {
                    simple = simple.substring(index + 2);
                }
                pattern.superSimpleName = simple.toCharArray();
                indexManager.performConcurrentJob(job, waitingPolicy, null);
                if (progressMonitor != null && ++ticks <= 800) {
                    progressMonitor.worked(1);
                }
                if (currentTypeName != null) continue;
                break;
            }
        }
        finally {
            job.finished();
        }
    }

    static class Queue {
        public char[][] names = new char[10][];
        public int start = 0;
        public int end = -1;

        Queue() {
        }

        public void add(char[] name) {
            if (++this.end == this.names.length) {
                this.end -= this.start;
                char[][] cArrayArray = new char[this.end * 2][];
                this.names = cArrayArray;
                System.arraycopy(this.names, this.start, cArrayArray, 0, this.end);
                this.start = 0;
            }
            this.names[this.end] = name;
        }

        public char[] retrieve() {
            if (this.start > this.end) {
                return null;
            }
            char[] name = this.names[this.start++];
            if (this.start > this.end) {
                this.start = 0;
                this.end = -1;
            }
            return name;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Queue:\n");
            int i = this.start;
            while (i <= this.end) {
                buffer.append(this.names[i]).append('\n');
                ++i;
            }
            return buffer.toString();
        }
    }
}

