/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.ast.RootNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.CompilationParticipant;
import org.rubypeople.rdt.core.compiler.ReconcileContext;
import org.rubypeople.rdt.core.parser.warnings.DelegatingVisitor;
import org.rubypeople.rdt.internal.core.builder.SyntaxExceptionHandler;
import org.rubypeople.rdt.internal.core.parser.RubyParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyCodeAnalyzer
extends CompilationParticipant {
    @Override
    public boolean isActive(IRubyProject project) {
        return true;
    }

    @Override
    public void buildStarting(BuildContext[] files, boolean isBatch) {
        int i = 0;
        while (i < files.length) {
            BuildContext context = files[i];
            String contents = new String(context.getContents());
            List<CategorizedProblem> problems = this.parse(RubyCore.create(context.getFile()), contents, null);
            context.recordNewProblems(problems.toArray(new CategorizedProblem[problems.size()]));
            ++i;
        }
    }

    private List<CategorizedProblem> parse(IRubyScript script, String contents, RootNode ast) {
        if (ast == null) {
            if (script == null) {
                return Collections.emptyList();
            }
            try {
                RubyParser parser = new RubyParser();
                ast = (RootNode)parser.parse(script.getElementName(), contents).getAST();
            }
            catch (SyntaxException e) {
                ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
                problems.add(SyntaxExceptionHandler.handle(e, contents));
                return problems;
            }
        }
        DelegatingVisitor visitor = new DelegatingVisitor(DelegatingVisitor.createVisitors(script, contents));
        ast.accept((NodeVisitor)visitor);
        return visitor.getProblems();
    }

    @Override
    public void reconcile(ReconcileContext context) {
        try {
            List<CategorizedProblem> problems = this.parse(context.getWorkingCopy(), context.getWorkingCopy().getSource(), context.getAST());
            this.addProblems(context, "org.rubypeople.rdt.core.problem", problems);
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }
}

