/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.builder.AbstractRdtCompiler;
import org.rubypeople.rdt.internal.core.builder.CleanRdtCompiler;
import org.rubypeople.rdt.internal.core.builder.IncrementalRdtCompiler;

public class RubyBuilder
extends IncrementalProjectBuilder {
    public static boolean DEBUG;
    private IProject currentProject;
    private RubyProject rubyProject;
    private IWorkspaceRoot workspaceRoot;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return null;
        }
        AbstractRdtCompiler compiler = this.createCompiler(kind);
        compiler.aboutToBuild();
        if (DEBUG) {
            RubyCore.trace("Started " + this.buildType(kind) + " build of " + this.buildDescription());
        }
        compiler.compile(monitor);
        if (DEBUG) {
            RubyCore.trace("Finished build of " + this.buildDescription());
        }
        IProject[] requiredProjects = this.getRequiredProjects(true);
        return requiredProjects;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return;
        }
        this.initializeBuilder();
        RubyModelManager.getRubyModelManager().indexManager.indexAll(this.currentProject);
        super.clean(monitor);
    }

    private void initializeBuilder() {
        this.rubyProject = (RubyProject)RubyCore.create(this.currentProject);
        this.workspaceRoot = this.currentProject.getWorkspace().getRoot();
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        if (this.rubyProject == null || this.workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            ILoadpathEntry[] entries = this.rubyProject.getExpandedLoadpath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                ILoadpathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = this.workspaceRoot.getProject(path.lastSegment());
                        if (!((LoadpathEntry)entry).isOptional() || RubyProject.hasRubyNature(p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = this.workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    private AbstractRdtCompiler createCompiler(int kind) {
        if (this.isPartialBuild(kind)) {
            return new IncrementalRdtCompiler(this.currentProject, this.getDelta(this.currentProject));
        }
        return new CleanRdtCompiler(this.currentProject);
    }

    private String buildType(int kind) {
        return this.isPartialBuild(kind) ? "Incremental" : "Full";
    }

    private String buildDescription() {
        return String.valueOf(this.currentProject.getName()) + " @ " + new Date(System.currentTimeMillis());
    }

    private boolean isPartialBuild(int kind) {
        return kind == 10 || kind == 9;
    }

    public static void setVerbose(boolean verbose) {
        DEBUG = verbose;
    }

    public static void writeState(Object savedState, DataOutputStream out) {
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.rubypeople.rdt.core.problem", false, 2);
                resource.deleteMarkers("org.rubypeople.rdt.core.task", false, 2);
                HashSet<String> markerTypes = RubyModelManager.getRubyModelManager().compilationParticipants.managedMarkerTypes();
                if (markerTypes.size() == 0) {
                    return;
                }
                Iterator iterator = markerTypes.iterator();
                while (iterator.hasNext()) {
                    resource.deleteMarkers((String)iterator.next(), false, 2);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static void buildStarting() {
    }

    public static void buildFinished() {
    }
}

