/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.compiler.IProblem;
import org.rubypeople.rdt.internal.core.builder.IMarkerManager;
import org.rubypeople.rdt.internal.core.parser.TaskTag;

public class ProblemRequestorMarkerManager
implements IProblemRequestor {
    private IMarkerManager markerManager;
    private boolean active = false;
    private IFile file;

    public ProblemRequestorMarkerManager(IFile file, IMarkerManager markerManager) {
        this.markerManager = markerManager;
        this.file = file;
    }

    public void acceptProblem(IProblem problem) {
        if (problem.isWarning() || problem.isError()) {
            this.markerManager.addProblem(this.file, problem);
            return;
        }
        if (problem.isTask()) {
            ArrayList<TaskTag> tasks = new ArrayList<TaskTag>();
            TaskTag task = (TaskTag)problem;
            tasks.add(task);
            try {
                this.markerManager.createTasks(this.file, tasks);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    public void beginReporting() {
        this.active = true;
    }

    public void endReporting() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }
}

