/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.internal.core.builder.AbstractRdtCompiler;
import org.rubypeople.rdt.internal.core.builder.BuildContextCollector;
import org.rubypeople.rdt.internal.core.builder.ERBBuildContext;
import org.rubypeople.rdt.internal.core.builder.IMarkerManager;
import org.rubypeople.rdt.internal.core.builder.MarkerManager;
import org.rubypeople.rdt.internal.core.util.Util;

public class IncrementalRdtCompiler
extends AbstractRdtCompiler {
    private List<BuildContext> contexts;
    private List<IFile> filesToClear;
    private final IResourceDelta rootDelta;

    public IncrementalRdtCompiler(IProject project, IResourceDelta delta, IMarkerManager markerManager) {
        super(project, markerManager);
        this.rootDelta = delta;
    }

    public IncrementalRdtCompiler(IProject project, IResourceDelta delta) {
        this(project, delta, new MarkerManager());
    }

    protected void removeMarkers(IMarkerManager markerManager) {
        for (IFile file : this.filesToClear) {
            markerManager.removeProblemsAndTasksFor((IResource)file);
        }
    }

    private void analyzeFiles() throws CoreException {
        this.filesToClear = new ArrayList<IFile>();
        this.contexts = new ArrayList<BuildContext>();
        this.rootDelta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                if (this.isRubyFile(resource) || this.isERBFile(resource)) {
                    if (delta.getKind() == 2) {
                        IncrementalRdtCompiler.this.filesToClear.add((IFile)resource);
                    } else if (delta.getKind() == 1 || delta.getKind() == 4) {
                        IncrementalRdtCompiler.this.filesToClear.add((IFile)resource);
                        if (this.isERBFile(resource)) {
                            IncrementalRdtCompiler.this.contexts.add(new ERBBuildContext((IFile)resource));
                        } else {
                            IncrementalRdtCompiler.this.contexts.add(new BuildContext((IFile)resource));
                        }
                    }
                }
                return 2 != resource.getType() || !resource.getProjectRelativePath().equals((Object)new Path("vendor"));
            }

            private boolean isERBFile(IResource resource) {
                if (!(resource instanceof IFile)) {
                    return false;
                }
                String name = resource.getName();
                return BuildContextCollector.isERB(name);
            }

            private boolean isRubyFile(IResource resource) {
                return resource instanceof IFile && Util.isRubyLikeFileName(resource.getName());
            }
        });
    }

    protected BuildContext[] getBuildContexts() throws CoreException {
        if (this.contexts == null) {
            this.analyzeFiles();
        }
        return this.contexts.toArray(new BuildContext[this.contexts.size()]);
    }
}

