/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.internal.core.builder.ERBBuildContext;
import org.rubypeople.rdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildContextCollector
implements IResourceProxyVisitor {
    private static final String RUBY_SOURCE_CONTENT_TYPE_ID = "org.rubypeople.rdt.core.rubySource";
    private final List<BuildContext> contexts = new ArrayList<BuildContext>();
    private HashSet<String> visitedLinks = new HashSet();
    private IRubyProject rubyProject;

    public BuildContextCollector(IProject project) {
        this.rubyProject = RubyCore.create(project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IResourceProxy proxy) throws CoreException {
        switch (proxy.getType()) {
            case 1: {
                if (Util.isRubyLikeFileName(proxy.getName())) {
                    IFile file = this.getFile(proxy);
                    this.contexts.add(new BuildContext(file));
                    return false;
                }
                if (BuildContextCollector.isERB(proxy.getName())) {
                    IFile file = this.getFile(proxy);
                    this.contexts.add(new ERBBuildContext(file));
                    return false;
                }
                IFile file = this.getFile(proxy);
                if (!this.isRubySourceContentType(file)) return false;
                this.contexts.add(new BuildContext(file));
                return false;
            }
            case 2: {
                try {
                    IResource resource = proxy.requestResource();
                    if (resource.getProjectRelativePath().equals((Object)new Path("vendor"))) {
                        return false;
                    }
                    IPath path = resource.getLocation();
                    String unique = path.toFile().getCanonicalPath();
                    if (this.visitedLinks.contains(unique)) {
                        return false;
                    }
                    this.visitedLinks.add(unique);
                    return true;
                }
                catch (IOException e) {
                    RubyCore.log(e);
                    return false;
                }
            }
        }
        return true;
    }

    private IFile getFile(IResourceProxy proxy) {
        return (IFile)proxy.requestResource();
    }

    public static boolean isERB(String name) {
        return name.endsWith(".erb") || name.endsWith(".rhtml");
    }

    private boolean isRubySourceContentType(IFile file) throws CoreException {
        IContentType type;
        IContentDescription contentDescription = file.getContentDescription();
        return contentDescription != null && (type = contentDescription.getContentType()) != null && type.getId().equals(RUBY_SOURCE_CONTENT_TYPE_ID);
    }

    public List<BuildContext> getContexts() {
        return this.contexts;
    }
}

