/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.core.util.Util;

class XMLWriter
extends PrintWriter {
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private int tab = 0;
    private String lineSeparator;

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = XMLWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    private static String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            XMLWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    public XMLWriter(Writer writer, IRubyProject project, boolean printXmlVersion) {
        super(writer);
        this.lineSeparator = Util.getLineSeparator(null, project);
        if (printXmlVersion) {
            this.print(XML_VERSION);
            this.print(this.lineSeparator);
        }
    }

    public void endTag(String name, boolean insertTab, boolean insertNewLine) {
        --this.tab;
        this.printTag(String.valueOf('/') + name, null, insertTab, insertNewLine, false);
    }

    private void printTabulation() {
        int i = 0;
        while (i < this.tab) {
            super.print('\t');
            ++i;
        }
    }

    public void printTag(String name, HashMap parameters, boolean insertTab, boolean insertNewLine, boolean closeTag) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(name);
        if (parameters != null) {
            int length = parameters.size();
            String[] keys = new String[length];
            parameters.keySet().toArray(keys);
            Util.sort(keys);
            int i = 0;
            while (i < length) {
                sb.append(" ");
                sb.append(keys[i]);
                sb.append("=\"");
                sb.append(XMLWriter.getEscaped(String.valueOf(parameters.get(keys[i]))));
                sb.append("\"");
                ++i;
            }
        }
        if (closeTag) {
            sb.append("/>");
        } else {
            sb.append(">");
        }
        this.printString(sb.toString(), insertTab, insertNewLine);
        if (parameters != null && !closeTag) {
            ++this.tab;
        }
    }

    public void printString(String string, boolean insertTab, boolean insertNewLine) {
        if (insertTab) {
            this.printTabulation();
        }
        this.print(string);
        if (insertNewLine) {
            this.print(this.lineSeparator);
        }
    }

    public void startTag(String name, boolean insertTab) {
        this.printTag(name, null, insertTab, true, false);
        ++this.tab;
    }
}

