/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jruby.ast.Node;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.SourceRefElementInfo;
import org.rubypeople.rdt.internal.core.util.DOMFinder;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;

public abstract class SourceRefElement
extends RubyElement
implements ISourceReference {
    public int occurrenceCount = 1;

    public SourceRefElement(RubyElement parent) {
        super(parent);
    }

    public IRubyScript getRubyScript() {
        return ((RubyElement)this.getParent()).getRubyScript();
    }

    public Node findNode(Node ast) {
        DOMFinder finder = new DOMFinder(ast, this);
        try {
            return finder.search();
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
    }

    public IOpenable getOpenableParent() {
        IRubyElement current = this.getParent();
        while (current != null) {
            if (current instanceof IOpenable) {
                return (IOpenable)((Object)current);
            }
            current = current.getParent();
        }
        return null;
    }

    public IResource getCorrespondingResource() throws RubyModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return null;
    }

    public boolean isStructureKnown() throws RubyModelException {
        return true;
    }

    public String getSource() throws RubyModelException {
        IOpenable openable = this.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public ISourceRange getSourceRange() throws RubyModelException {
        SourceRefElementInfo info = (SourceRefElementInfo)this.getElementInfo();
        return info.getSourceRange();
    }

    public IPath getPath() {
        return this.getParent().getPath();
    }

    public IResource getResource() {
        return this.getParent().getResource();
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getParent().getUnderlyingResource();
    }

    protected void closing(Object info) throws RubyModelException {
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws RubyModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent == null) {
            return;
        }
        RubyElementInfo openableParentInfo = (RubyElementInfo)RubyModelManager.getRubyModelManager().getInfo(openableParent);
        if (openableParentInfo == null) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    protected Object createElementInfo() {
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SourceRefElement)) {
            return false;
        }
        return this.occurrenceCount == ((SourceRefElement)o).occurrenceCount && super.equals(o);
    }

    public IRubyElement getHandleUpdatingCountFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        this.occurrenceCount = Integer.parseInt(memento.nextToken());
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
        }
        return this;
    }

    protected void getHandleMemento(StringBuffer buff) {
        super.getHandleMemento(buff);
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }
}

