/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.util.Util;

public class SourceFolderRootInfo
extends OpenableElementInfo {
    protected Object[] fNonRubyResources = null;

    Object[] getNonRubyResources(IResource underlyingResource) {
        if (this.fNonRubyResources == null) {
            try {
                this.fNonRubyResources = SourceFolderRootInfo.computeFolderNonRubyResources((IContainer)underlyingResource);
            }
            catch (RubyModelException rubyModelException) {
                this.fNonRubyResources = NO_NON_RUBY_RESOURCES;
            }
        }
        return this.fNonRubyResources;
    }

    void setNonRubyResources(Object[] resources) {
        this.fNonRubyResources = resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] computeFolderNonRubyResources(IContainer folder) throws RubyModelException {
        Object[] nonRubyResources = new IResource[5];
        int nonRubyResourcesCounter = 0;
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (true) {
                block10: {
                    if (i >= max) {
                        if (nonRubyResources.length != nonRubyResourcesCounter) {
                            Object[] objectArray = nonRubyResources;
                            nonRubyResources = new IResource[nonRubyResourcesCounter];
                            System.arraycopy(objectArray, 0, nonRubyResources, 0, nonRubyResourcesCounter);
                        }
                        return nonRubyResources;
                    }
                    IResource member = members[i];
                    switch (member.getType()) {
                        case 1: {
                            String fileName = member.getName();
                            if (!Util.isValidRubyScriptName(fileName)) break;
                            break block10;
                        }
                        case 2: {
                            break block10;
                        }
                    }
                    if (nonRubyResources.length == nonRubyResourcesCounter) {
                        Object[] objectArray = nonRubyResources;
                        nonRubyResources = new IResource[nonRubyResourcesCounter * 2];
                        System.arraycopy(objectArray, 0, nonRubyResources, 0, nonRubyResourcesCounter);
                    }
                    nonRubyResources[nonRubyResourcesCounter++] = member;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[] computeFolderNonRubyResources(RubyProject project, IContainer folder, char[][] inclusionPatterns, char[][] exclusionPatterns) throws RubyModelException {
        Object[] nonRubyResources = new IResource[5];
        int nonRubyResourcesCounter = 0;
        try {
            ILoadpathEntry[] classpath = project.getResolvedLoadpath(true, false, false);
            IResource[] members = new IResource[]{};
            if (folder != null) {
                members = folder.members();
            }
            int i = 0;
            int max = members.length;
            while (true) {
                block11: {
                    if (i >= max) {
                        if (nonRubyResources.length != nonRubyResourcesCounter) {
                            Object[] objectArray = nonRubyResources;
                            nonRubyResources = new IResource[nonRubyResourcesCounter];
                            System.arraycopy(objectArray, 0, nonRubyResources, 0, nonRubyResourcesCounter);
                        }
                        return nonRubyResources;
                    }
                    IResource member = members[i];
                    switch (member.getType()) {
                        case 1: {
                            String fileName = member.getName();
                            if (!Util.isValidRubyOrERBScriptName(fileName) || Util.isExcluded(member, inclusionPatterns, exclusionPatterns)) break;
                            break block11;
                        }
                        case 2: {
                            if (Util.isValidSourceFolderName(member.getName()) && (!Util.isExcluded(member, inclusionPatterns, exclusionPatterns) || SourceFolderRootInfo.isLoadpathEntry(member.getFullPath(), classpath))) break block11;
                        }
                    }
                    if (nonRubyResources.length == nonRubyResourcesCounter) {
                        Object[] objectArray = nonRubyResources;
                        nonRubyResources = new IResource[nonRubyResourcesCounter * 2];
                        System.arraycopy(objectArray, 0, nonRubyResources, 0, nonRubyResourcesCounter);
                    }
                    nonRubyResources[nonRubyResourcesCounter++] = member;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    private static boolean isLoadpathEntry(IPath path, ILoadpathEntry[] resolvedLoadpath) {
        int i = 0;
        int length = resolvedLoadpath.length;
        while (i < length) {
            ILoadpathEntry entry = resolvedLoadpath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    synchronized Object[] getNonRubyResources(IRubyProject project, IResource underlyingResource, SourceFolderRoot handle) {
        Object[] nonRubyResources = this.fNonRubyResources;
        if (nonRubyResources == null) {
            nonRubyResources = this.computeNonRubyResources(project, underlyingResource, handle);
            this.fNonRubyResources = nonRubyResources;
        }
        return nonRubyResources;
    }

    private Object[] computeNonRubyResources(IRubyProject project, IResource underlyingResource, SourceFolderRoot handle) {
        Object[] nonRubyResources = NO_NON_RUBY_RESOURCES;
        try {
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                nonRubyResources = SourceFolderRootInfo.computeFolderNonRubyResources((RubyProject)project, (IContainer)underlyingResource, handle.fullInclusionPatternChars(), handle.fullExclusionPatternChars());
            }
        }
        catch (RubyModelException rubyModelException) {}
        return nonRubyResources;
    }
}

