/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.CreateSourceFolderOperation;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderRootInfo;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;
import org.rubypeople.rdt.internal.core.util.Util;

public class SourceFolderRoot
extends Openable
implements ISourceFolderRoot {
    protected Object resource;

    protected SourceFolderRoot(IResource resource, RubyProject project) {
        super(project);
        this.resource = resource;
    }

    public boolean hasChildren() throws RubyModelException {
        return true;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws RubyModelException {
        IStatus status = this.validateOnLoadpath();
        if (!status.isOK()) {
            throw this.newRubyModelException(status);
        }
        if (!this.resourceExists()) {
            throw this.newNotPresentException();
        }
        return this.computeChildren(info, newElements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceFolderRoot)) {
            return false;
        }
        SourceFolderRoot other = (SourceFolderRoot)o;
        return this.resource.equals(other.resource) && this.parent.equals(other.parent);
    }

    protected IStatus validateOnLoadpath() {
        IPath path = this.getPath();
        try {
            RubyProject project = (RubyProject)this.getRubyProject();
            ILoadpathEntry[] classpath = project.getResolvedLoadpath(true, false, false);
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                ILoadpathEntry entry = classpath[i];
                if (entry.getPath().equals((Object)path)) {
                    return Status.OK_STATUS;
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            return e.getRubyModelStatus();
        }
        return new RubyModelStatus(1006, this);
    }

    public char[][] fullExclusionPatternChars() {
        LoadpathEntry entry;
        block3: {
            try {
                entry = (LoadpathEntry)this.getRawLoadpathEntry();
                if (entry != null) break block3;
                return null;
            }
            catch (RubyModelException rubyModelException) {
                return null;
            }
        }
        return entry.fullExclusionPatternChars();
    }

    public ILoadpathEntry getRawLoadpathEntry() throws RubyModelException {
        ILoadpathEntry rawEntry = null;
        RubyProject project = (RubyProject)this.getRubyProject();
        project.getResolvedLoadpath(true, false, false);
        RubyModelManager.PerProjectInfo perProjectInfo = project.getPerProjectInfo();
        if (perProjectInfo != null && perProjectInfo.resolvedPathToRawEntries != null) {
            rawEntry = (ILoadpathEntry)perProjectInfo.resolvedPathToRawEntries.get(this.getPath());
        }
        return rawEntry;
    }

    public char[][] fullInclusionPatternChars() {
        LoadpathEntry entry;
        block3: {
            try {
                entry = (LoadpathEntry)this.getRawLoadpathEntry();
                if (entry != null) break block3;
                return null;
            }
            catch (RubyModelException rubyModelException) {
                return null;
            }
        }
        return entry.fullInclusionPatternChars();
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws RubyModelException {
        try {
            IResource underlyingResource = this.getResource();
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                ArrayList vChildren = new ArrayList(5);
                IContainer rootFolder = (IContainer)underlyingResource;
                this.computeFolderChildren(rootFolder, CharOperation.NO_STRINGS, vChildren);
                IRubyElement[] children = new IRubyElement[vChildren.size()];
                vChildren.toArray(children);
                info.setChildren(children);
            }
        }
        catch (RubyModelException e) {
            info.setChildren(new IRubyElement[0]);
            throw e;
        }
        return true;
    }

    protected Object createElementInfo() {
        return new SourceFolderRootInfo();
    }

    public int getElementType() {
        return 2;
    }

    public String getElementName() {
        if (this.resource instanceof IFolder) {
            return ((IFolder)this.resource).getName();
        }
        return "";
    }

    public ISourceFolder createSourceFolder(String names, boolean force, IProgressMonitor monitor) throws RubyModelException {
        CreateSourceFolderOperation op = new CreateSourceFolderOperation(this, names, force);
        op.runOperation(monitor);
        return this.getSourceFolder(op.pkgName);
    }

    protected void computeFolderChildren(IContainer folder, String[] pkgName, ArrayList vChildren) throws RubyModelException {
        SourceFolder pkg = this.getSourceFolder(pkgName);
        vChildren.add(pkg);
        try {
            RubyProject rubyProject = (RubyProject)this.getRubyProject();
            RubyModelManager manager = RubyModelManager.getRubyModelManager();
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                String memberName = member.getName();
                switch (member.getType()) {
                    case 2: {
                        if (!rubyProject.contains(member)) break;
                        String[] newNames = Util.arrayConcat(pkgName, manager.intern(memberName));
                        this.computeFolderChildren((IContainer)((IFolder)member), newNames, vChildren);
                        break;
                    }
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new RubyModelException(e, 969);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    public void delete(int updateResourceFlags, int updateModelFlags, IProgressMonitor monitor) throws RubyModelException {
    }

    public boolean exists() {
        return super.exists() && this.validateOnLoadpath().isOK();
    }

    public SourceFolder getSourceFolder(String[] names) {
        return new SourceFolder(this, names);
    }

    public boolean isExternal() {
        return false;
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public IResource getResource() {
        return (IResource)this.resource;
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getResource();
    }

    public boolean isArchive() {
        return false;
    }

    public Object[] getNonRubyResources() throws RubyModelException {
        return ((SourceFolderRootInfo)this.getElementInfo()).getNonRubyResources(this.getRubyProject(), this.getResource(), this);
    }

    public ISourceFolder getSourceFolder(String packName) {
        String[] names = Util.getTrimmedSimpleNames(packName);
        return this.getSourceFolder(names);
    }

    protected char getHandleMementoDelimiter() {
        return '/';
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = "";
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = "";
                    token = null;
                }
                RubyElement pkg = (RubyElement)((Object)this.getSourceFolder(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    protected void getHandleMemento(StringBuffer buff) {
        IResource underlyingResource = this.getResource();
        IPath path = underlyingResource != null ? (this.getResource().getProject().equals((Object)this.getRubyProject().getProject()) ? underlyingResource.getProjectRelativePath() : underlyingResource.getFullPath()) : this.getPath();
        ((RubyElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, path.toString());
    }
}

