/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.compiler.util.ObjectVector;
import org.rubypeople.rdt.internal.core.DeltaProcessingState;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.search.indexing.IndexManager;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class SetLoadpathOperation
extends RubyModelOperation {
    ILoadpathEntry[] oldResolvedPath;
    ILoadpathEntry[] newResolvedPath;
    ILoadpathEntry[] newRawPath;
    boolean canChangeResources;
    boolean loadpathWasSaved;
    boolean needCycleCheck;
    boolean needValidation;
    boolean needSave;
    IPath newOutputLocation;
    RubyProject project;
    boolean identicalRoots;
    public static final ILoadpathEntry[] DO_NOT_SET_ENTRIES = new ILoadpathEntry[0];
    public static final ILoadpathEntry[] DO_NOT_UPDATE_PROJECT_REFS = new ILoadpathEntry[0];
    public static final IPath DO_NOT_SET_OUTPUT = new Path("Reuse Existing Output Location");

    public SetLoadpathOperation(RubyProject project, ILoadpathEntry[] oldResolvedPath, ILoadpathEntry[] newRawPath, IPath newOutputLocation, boolean canChangeResource, boolean needValidation, boolean needSave) {
        super(new IRubyElement[]{project});
        this.oldResolvedPath = oldResolvedPath;
        this.newRawPath = newRawPath;
        this.newOutputLocation = newOutputLocation;
        this.canChangeResources = canChangeResource;
        this.needValidation = needValidation;
        this.needSave = needSave;
        this.project = project;
    }

    protected void addLoadpathDeltas(ISourceFolderRoot[] roots, int flag, RubyElementDelta delta) {
        int i = 0;
        while (i < roots.length) {
            ISourceFolderRoot root = roots[i];
            delta.changed(root, flag);
            if ((flag & 0x80) != 0 || (flag & 0x1000) != 0 || (flag & 0x2000) != 0) {
                try {
                    root.close();
                }
                catch (RubyModelException rubyModelException) {}
            }
            ++i;
        }
    }

    protected boolean canModifyRoots() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected int classpathContains(ILoadpathEntry[] list, ILoadpathEntry entry) {
        exclusionPatterns = entry.getExclusionPatterns();
        inclusionPatterns = entry.getInclusionPatterns();
        i = 0;
        while (i < list.length) {
            block7: {
                block9: {
                    block8: {
                        other = list[i];
                        if (other.getEntryKind() != entry.getEntryKind() || other.isExported() != entry.isExported() || !other.getPath().equals((Object)entry.getPath())) break block7;
                        otherIncludes = other.getInclusionPatterns();
                        if (inclusionPatterns == otherIncludes) break block8;
                        if (inclusionPatterns == null) break block7;
                        includeLength = inclusionPatterns.length;
                        if (otherIncludes != null && otherIncludes.length == includeLength) {
                            j = 0;
                            while (j < includeLength) {
                                if (inclusionPatterns[j].toString().equals(otherIncludes[j].toString())) {
                                    ++j;
                                } else {
                                    ** GOTO lbl-1000
                                }
                            }
                        }
                        break block7;
lbl-1000:
                        // 2 sources

                        {
                            break block7;
                        }
                    }
                    if (exclusionPatterns == (otherExcludes = other.getExclusionPatterns())) break block9;
                    if (exclusionPatterns == null) break block7;
                    excludeLength = exclusionPatterns.length;
                    if (otherExcludes != null && otherExcludes.length == excludeLength) {
                        j = 0;
                        while (j < excludeLength) {
                            if (exclusionPatterns[j].toString().equals(otherExcludes[j].toString())) {
                                ++j;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    }
                    break block7;
lbl-1000:
                    // 2 sources

                    {
                        break block7;
                    }
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void collectAllSubfolders(IFolder folder, ArrayList collection) throws RubyModelException {
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource r = members[i];
                if (r.getType() == 2) {
                    collection.add(r);
                    this.collectAllSubfolders((IFolder)r, collection);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    protected ArrayList determineAffectedPackageFragments(IPath location) throws RubyModelException {
        ArrayList<SourceFolder> fragments = new ArrayList<SourceFolder>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource resource = null;
        if (location != null) {
            resource = workspace.getRoot().findMember(location);
        }
        if (resource != null && resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            ILoadpathEntry[] classpath = this.project.getExpandedLoadpath(true);
            int i = 0;
            while (i < classpath.length) {
                ILoadpathEntry entry = classpath[i];
                IPath path = classpath[i].getPath();
                if (entry.getEntryKind() != 2 && path.isPrefixOf(location) && !path.equals((Object)location)) {
                    ISourceFolderRoot[] roots = this.project.computeSourceFolderRoots(classpath[i]);
                    SourceFolderRoot root = (SourceFolderRoot)roots[0];
                    ArrayList<IFolder> folders = new ArrayList<IFolder>();
                    folders.add(folder);
                    this.collectAllSubfolders(folder, folders);
                    Iterator elements = folders.iterator();
                    int segments = path.segmentCount();
                    while (elements.hasNext()) {
                        IFolder f = (IFolder)elements.next();
                        IPath relativePath = f.getFullPath().removeFirstSegments(segments);
                        String[] pkgName = relativePath.segments();
                        SourceFolder pkg = root.getSourceFolder(pkgName);
                        fragments.add(pkg);
                    }
                }
                ++i;
            }
        }
        return fragments;
    }

    protected void executeOperation() throws RubyModelException {
        this.updateProjectReferencesIfNecessary();
        this.saveLoadpathIfNecessary();
        try {
            if (this.newRawPath == DO_NOT_UPDATE_PROJECT_REFS) {
                this.newRawPath = this.project.getRawLoadpath();
            }
            if (this.newRawPath != DO_NOT_SET_ENTRIES) {
                this.updateLoadpath();
                this.project.updateSourceFolderRoots();
                RubyModelManager.getRubyModelManager().getDeltaProcessor().addForRefresh(this.project);
            }
        }
        finally {
            block13: {
                if (!this.identicalRoots && this.canChangeResources) {
                    try {
                        this.project.getProject().touch(this.progressMonitor);
                    }
                    catch (CoreException e) {
                        if (!RubyModelManager.CP_RESOLVE_VERBOSE) break block13;
                        Util.verbose("CPContainer INIT - FAILED to touch project: " + this.project.getElementName(), System.err);
                        e.printStackTrace();
                    }
                }
            }
        }
        this.done();
    }

    protected void generateLoadpathChangeDeltas() {
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        if (manager.deltaState.findRubyProject(this.project.getElementName()) == null) {
            return;
        }
        boolean needToUpdateDependents = false;
        RubyElementDelta delta = new RubyElementDelta(this.getRubyModel());
        boolean hasDelta = false;
        if (this.loadpathWasSaved) {
            delta.changed(this.project, 131072);
            hasDelta = true;
        }
        int oldLength = this.oldResolvedPath.length;
        int newLength = this.newResolvedPath.length;
        final IndexManager indexManager = manager.getIndexManager();
        HashMap<IPath, ISourceFolderRoot> oldRoots = null;
        ISourceFolderRoot[] roots = null;
        if (this.project.isOpen()) {
            try {
                roots = this.project.getSourceFolderRoots();
            }
            catch (RubyModelException rubyModelException) {}
        } else {
            Map<IRubyProject, ISourceFolderRoot[]> allRemovedRoots = manager.getDeltaProcessor().removedRoots;
            if (allRemovedRoots != null) {
                roots = allRemovedRoots.get(this.project);
            }
        }
        if (roots != null) {
            oldRoots = new HashMap<IPath, ISourceFolderRoot>();
            int i = 0;
            while (i < roots.length) {
                ISourceFolderRoot root = roots[i];
                oldRoots.put(root.getPath(), root);
                ++i;
            }
        }
        int i = 0;
        while (i < oldLength) {
            int index = this.classpathContains(this.newResolvedPath, this.oldResolvedPath[i]);
            if (index == -1) {
                if (this.oldResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    ISourceFolderRoot oldRoot;
                    Object[] pkgFragmentRoots = null;
                    if (oldRoots != null && (oldRoot = (ISourceFolderRoot)oldRoots.get(this.oldResolvedPath[i].getPath())) != null) {
                        pkgFragmentRoots = new ISourceFolderRoot[]{oldRoot};
                    }
                    if (pkgFragmentRoots == null) {
                        try {
                            ObjectVector accumulatedRoots = new ObjectVector();
                            HashSet<String> rootIDs = new HashSet<String>(5);
                            rootIDs.add(this.project.rootID());
                            this.project.computeSourceFolderRoots(this.oldResolvedPath[i], accumulatedRoots, rootIDs, null, false, false, null);
                            pkgFragmentRoots = new ISourceFolderRoot[accumulatedRoots.size()];
                            accumulatedRoots.copyInto(pkgFragmentRoots);
                        }
                        catch (RubyModelException rubyModelException) {
                            pkgFragmentRoots = new ISourceFolderRoot[]{};
                        }
                    }
                    this.addLoadpathDeltas((ISourceFolderRoot[])pkgFragmentRoots, 128, delta);
                    int changeKind = this.oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3 || this.oldResolvedPath[i].isExported();
                    if (indexManager != null) {
                        ILoadpathEntry oldEntry = this.oldResolvedPath[i];
                        final IPath path = oldEntry.getPath();
                        switch (changeKind) {
                            case 3: {
                                final char[][] inclusionPatterns = ((LoadpathEntry)oldEntry).fullInclusionPatternChars();
                                final char[][] exclusionPatterns = ((LoadpathEntry)oldEntry).fullExclusionPatternChars();
                                this.postAction(new RubyModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        indexManager.removeSourceFolderFromIndex(SetLoadpathOperation.this.project, path, inclusionPatterns, exclusionPatterns);
                                    }
                                }, 2);
                                break;
                            }
                            case 1: {
                                final DeltaProcessingState deltaState = manager.deltaState;
                                this.postAction(new RubyModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        if (deltaState.otherRoots.get(path) == null) {
                                            indexManager.discardJobs(path.toString());
                                            indexManager.removeIndex(path);
                                        }
                                    }
                                }, 2);
                            }
                        }
                    }
                    hasDelta = true;
                }
            } else if (this.oldResolvedPath[i].getEntryKind() == 2) {
                LoadpathEntry oldEntry = (LoadpathEntry)this.oldResolvedPath[i];
                LoadpathEntry newEntry = (LoadpathEntry)this.newResolvedPath[index];
                this.needCycleCheck |= oldEntry.isExported() ^ newEntry.isExported();
            } else {
                needToUpdateDependents |= this.oldResolvedPath[i].isExported() ^ this.newResolvedPath[index].isExported();
                if (index != i) {
                    this.addLoadpathDeltas(this.project.computeSourceFolderRoots(this.oldResolvedPath[i]), 256, delta);
                    int changeKind = this.oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3;
                    hasDelta = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newLength) {
            int index = this.classpathContains(this.oldResolvedPath, this.newResolvedPath[i]);
            if (index == -1) {
                if (this.newResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    this.addLoadpathDeltas(this.project.computeSourceFolderRoots(this.newResolvedPath[i]), 64, delta);
                    int changeKind = this.newResolvedPath[i].getEntryKind();
                    if (indexManager != null) {
                        switch (changeKind) {
                            case 1: {
                                boolean pathHasChanged = true;
                                final IPath newPath = this.newResolvedPath[i].getPath();
                                int j = 0;
                                while (j < oldLength) {
                                    ILoadpathEntry oldEntry = this.oldResolvedPath[j];
                                    if (oldEntry.getPath().equals((Object)newPath)) {
                                        pathHasChanged = false;
                                        break;
                                    }
                                    ++j;
                                }
                                if (!pathHasChanged) break;
                                this.postAction(new RubyModelOperation.IPostAction(){

                                    public String getID() {
                                        return newPath.toString();
                                    }

                                    public void run() {
                                        indexManager.indexLibrary(newPath, SetLoadpathOperation.this.project.getProject());
                                    }
                                }, 2);
                                break;
                            }
                            case 3: {
                                ILoadpathEntry entry = this.newResolvedPath[i];
                                final IPath path = entry.getPath();
                                final char[][] inclusionPatterns = ((LoadpathEntry)entry).fullInclusionPatternChars();
                                final char[][] exclusionPatterns = ((LoadpathEntry)entry).fullExclusionPatternChars();
                                this.postAction(new RubyModelOperation.IPostAction(){

                                    public String getID() {
                                        return path.toString();
                                    }

                                    public void run() {
                                        indexManager.indexSourceFolder(SetLoadpathOperation.this.project, path, inclusionPatterns, exclusionPatterns);
                                    }
                                }, 1);
                            }
                        }
                    }
                    needToUpdateDependents |= changeKind == 3 || this.newResolvedPath[i].isExported();
                    hasDelta = true;
                }
            }
            ++i;
        }
        if (hasDelta) {
            this.addDelta(delta);
        } else {
            this.identicalRoots = true;
        }
        if (needToUpdateDependents) {
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    public boolean isReadOnly() {
        return !this.canChangeResources;
    }

    protected void saveLoadpathIfNecessary() throws RubyModelException {
        if (!this.canChangeResources || !this.needSave) {
            return;
        }
        ILoadpathEntry[] loadpathForSave = this.newRawPath == DO_NOT_SET_ENTRIES || this.newRawPath == DO_NOT_UPDATE_PROJECT_REFS ? this.project.getRawLoadpath() : this.newRawPath;
        if (this.project.saveLoadpath(loadpathForSave, null)) {
            this.loadpathWasSaved = true;
            this.setAttribute("hasModifiedResource", "true");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetLoadpathOperation\n");
        buffer.append(" - classpath : ");
        if (this.newRawPath == DO_NOT_SET_ENTRIES) {
            buffer.append("<Reuse Existing Loadpath Entries>");
        } else {
            buffer.append("{");
            int i = 0;
            while (i < this.newRawPath.length) {
                if (i > 0) {
                    buffer.append(",");
                }
                ILoadpathEntry element = this.newRawPath[i];
                buffer.append(" ").append(element.toString());
                ++i;
            }
        }
        buffer.append("\n - output location : ");
        if (this.newOutputLocation == DO_NOT_SET_OUTPUT) {
            buffer.append("<Reuse Existing Output Location>");
        } else {
            buffer.append(this.newOutputLocation.toString());
        }
        return buffer.toString();
    }

    private void updateLoadpath() throws RubyModelException {
        this.beginTask(Messages.bind(Messages.classpath_settingProgress, this.project.getElementName()), 2);
        this.project.getPerProjectInfo().updateLoadpathInformation(this.newRawPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = this.project.getResolvedLoadpath(true, this.canChangeResources, false);
        }
        if (this.oldResolvedPath != null) {
            this.generateLoadpathChangeDeltas();
        } else {
            this.needCycleCheck = true;
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
        this.updateCycleMarkersIfNecessary();
    }

    protected void updateAffectedProjects(IPath prerequisiteProjectPath) {
        this.removeAllPostAction("UpdateClassPath:" + prerequisiteProjectPath.toString());
        try {
            RubyModel model = RubyModelManager.getRubyModelManager().getRubyModel();
            RubyProject initialProject = this.project;
            IRubyProject[] projects = model.getRubyProjects();
            int i = 0;
            int projectCount = projects.length;
            while (i < projectCount) {
                block7: {
                    try {
                        final RubyProject affectedProject = (RubyProject)projects[i];
                        if (affectedProject.equals(initialProject) || !affectedProject.isOpen()) break block7;
                        ILoadpathEntry[] classpath = affectedProject.getExpandedLoadpath(true);
                        int j = 0;
                        int entryCount = classpath.length;
                        while (j < entryCount) {
                            ILoadpathEntry entry = classpath[j];
                            if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)prerequisiteProjectPath)) {
                                this.postAction(new RubyModelOperation.IPostAction(){

                                    public String getID() {
                                        return "UpdateClassPath:" + affectedProject.getPath().toString();
                                    }

                                    public void run() throws RubyModelException {
                                        affectedProject.setRawLoadpath(DO_NOT_UPDATE_PROJECT_REFS, DO_NOT_SET_OUTPUT, SetLoadpathOperation.this.progressMonitor, SetLoadpathOperation.this.canChangeResources, affectedProject.getResolvedLoadpath(true, false, false), false, false);
                                    }
                                }, 2);
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (RubyModelException rubyModelException) {}
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
    }

    protected void updateCycleMarkersIfNecessary() {
        if (!this.needCycleCheck) {
            return;
        }
        if (!this.canChangeResources) {
            return;
        }
        if (!this.project.hasCycleMarker() && !this.project.hasLoadpathCycle(this.newResolvedPath)) {
            return;
        }
        this.postAction(new RubyModelOperation.IPostAction(){

            public String getID() {
                return "updateCycleMarkers";
            }

            public void run() throws RubyModelException {
                RubyProject.updateAllCycleMarkers(null);
            }
        }, 2);
    }

    protected void updateProjectReferencesIfNecessary() throws RubyModelException {
        if (this.newRawPath == DO_NOT_SET_ENTRIES || this.newRawPath == DO_NOT_UPDATE_PROJECT_REFS) {
            return;
        }
        RubyModelManager.getRubyModelManager().deltaState.updateProjectReferences(this.project, this.oldResolvedPath, this.newResolvedPath, this.newRawPath, this.canChangeResources);
    }

    public IRubyModelStatus verify() {
        IRubyModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.needValidation) {
            ILoadpathEntry[] entries = this.newRawPath;
            if (entries == DO_NOT_SET_ENTRIES) {
                try {
                    entries = this.project.getRawLoadpath();
                }
                catch (RubyModelException e) {
                    return e.getRubyModelStatus();
                }
            }
            return LoadpathEntry.validateLoadpath(this.project, entries, null);
        }
        return RubyModelStatus.VERIFIED_OK;
    }
}

