/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceImport;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.ImportDeclarationElementInfo;
import org.rubypeople.rdt.internal.core.MemberElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyField;
import org.rubypeople.rdt.internal.core.RubyImport;
import org.rubypeople.rdt.internal.core.RubyMethod;
import org.rubypeople.rdt.internal.core.RubyType;

public class RubyTypeElementInfo
extends MemberElementInfo {
    protected static final ImportDeclarationElementInfo[] NO_IMPORTS = new ImportDeclarationElementInfo[0];
    protected static final RubyField[] NO_FIELDS = new RubyField[0];
    protected static final RubyMethod[] NO_METHODS = new RubyMethod[0];
    protected static final RubyType[] NO_TYPES = new RubyType[0];
    protected String superclassName;
    protected String[] includedModuleNames;
    protected String sourceFileName;
    protected String namespaceName;
    private ISourceImport[] imports;
    protected IType handle = null;

    public IType getEnclosingType() {
        IRubyElement parent = this.handle.getParent();
        if (parent != null && parent.getElementType() == 5) {
            try {
                return (IType)((RubyElement)parent).getElementInfo();
            }
            catch (RubyModelException rubyModelException) {
                return null;
            }
        }
        return null;
    }

    public IField[] getFields() {
        RubyField[] fieldHandles = this.getFieldHandles();
        int length = fieldHandles.length;
        IField[] fields = new IField[length];
        int i = 0;
        while (i < length) {
            try {
                IField field;
                fields[i] = field = (IField)fieldHandles[i].getElementInfo();
            }
            catch (RubyModelException rubyModelException) {}
            ++i;
        }
        return fields;
    }

    public RubyField[] getFieldHandles() {
        int length = this.children.length;
        if (length == 0) {
            return NO_FIELDS;
        }
        RubyField[] fields = new RubyField[length];
        int fieldIndex = 0;
        int i = 0;
        while (i < length) {
            IRubyElement child = this.children[i];
            if (child instanceof RubyField) {
                fields[fieldIndex++] = (RubyField)child;
            }
            ++i;
        }
        if (fieldIndex == 0) {
            return NO_FIELDS;
        }
        if (fieldIndex < length) {
            RubyField[] rubyFieldArray = fields;
            fields = new RubyField[fieldIndex];
            System.arraycopy(rubyFieldArray, 0, fields, 0, fieldIndex);
        }
        return fields;
    }

    public String getFileName() {
        return this.sourceFileName;
    }

    public IType getHandle() {
        return this.handle;
    }

    public ISourceImport[] getImports() {
        if (this.imports == null) {
            try {
                IImportDeclaration[] importDeclarations = this.handle.getRubyScript().getImports();
                int length = importDeclarations.length;
                if (length == 0) {
                    this.imports = NO_IMPORTS;
                } else {
                    ImportDeclarationElementInfo[] sourceImports = new ImportDeclarationElementInfo[length];
                    int i = 0;
                    while (i < length) {
                        sourceImports[i] = (ImportDeclarationElementInfo)((RubyImport)importDeclarations[i]).getElementInfo();
                        ++i;
                    }
                    this.imports = sourceImports;
                }
            }
            catch (RubyModelException rubyModelException) {
                this.imports = NO_IMPORTS;
            }
        }
        return this.imports;
    }

    public String[] getIncludedModuleNames() {
        if (this.handle.getElementName().length() == 0) {
            return null;
        }
        return this.includedModuleNames;
    }

    public IType[] getMemberTypes() {
        RubyType[] memberTypeHandles = this.getMemberTypeHandles();
        int length = memberTypeHandles.length;
        IType[] memberTypes = new IType[length];
        int i = 0;
        while (i < length) {
            try {
                IType type;
                memberTypes[i] = type = (IType)memberTypeHandles[i].getElementInfo();
            }
            catch (RubyModelException rubyModelException) {}
            ++i;
        }
        return memberTypes;
    }

    public RubyType[] getMemberTypeHandles() {
        int length = this.children.length;
        if (length == 0) {
            return NO_TYPES;
        }
        RubyType[] memberTypes = new RubyType[length];
        int typeIndex = 0;
        int i = 0;
        while (i < length) {
            IRubyElement child = this.children[i];
            if (child instanceof RubyType) {
                memberTypes[typeIndex++] = (RubyType)child;
            }
            ++i;
        }
        if (typeIndex == 0) {
            return NO_TYPES;
        }
        if (typeIndex < length) {
            RubyType[] rubyTypeArray = memberTypes;
            memberTypes = new RubyType[typeIndex];
            System.arraycopy(rubyTypeArray, 0, memberTypes, 0, typeIndex);
        }
        return memberTypes;
    }

    public IMethod[] getMethods() {
        return this.getMethodHandles();
    }

    public RubyMethod[] getMethodHandles() {
        int length = this.children.length;
        if (length == 0) {
            return NO_METHODS;
        }
        RubyMethod[] methods = new RubyMethod[length];
        int methodIndex = 0;
        int i = 0;
        while (i < length) {
            IRubyElement child = this.children[i];
            if (child instanceof RubyMethod) {
                methods[methodIndex++] = (RubyMethod)child;
            }
            ++i;
        }
        if (methodIndex == 0) {
            return NO_METHODS;
        }
        if (methodIndex < length) {
            RubyMethod[] rubyMethodArray = methods;
            methods = new RubyMethod[methodIndex];
            System.arraycopy(rubyMethodArray, 0, methods, 0, methodIndex);
        }
        return methods;
    }

    public char[] getName() {
        return this.handle.getElementName().toCharArray();
    }

    public String getNamespace() {
        return this.namespaceName;
    }

    public String getSuperclassName() {
        String[] interfaceNames;
        if (this.handle.getElementName().length() == 0 && (interfaceNames = this.includedModuleNames) != null && interfaceNames.length > 0) {
            return interfaceNames[0];
        }
        return this.superclassName;
    }

    protected void setHandle(IType handle) {
        this.handle = handle;
    }

    protected void setNamespaceName(String name) {
        this.namespaceName = name;
    }

    protected void setSourceFileName(String name) {
        this.sourceFileName = name;
    }

    protected void setSuperclassName(String superclassName) {
        this.superclassName = superclassName;
    }

    protected void setIncludedModuleNames(String[] includedModuleNames) {
        this.includedModuleNames = includedModuleNames;
    }

    public String toString() {
        return "Info for " + this.handle.toString();
    }
}

