/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.core.CreateMethodOperation;
import org.rubypeople.rdt.internal.core.CreateTypeHierarchyOperation;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.NamedMember;
import org.rubypeople.rdt.internal.core.RubyClassVar;
import org.rubypeople.rdt.internal.core.RubyConstant;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyGlobal;
import org.rubypeople.rdt.internal.core.RubyInstVar;
import org.rubypeople.rdt.internal.core.RubyMethod;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.RubyTypeElementInfo;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;

public class RubyType
extends NamedMember
implements IType {
    private static final String[] CORE_NAMES = new String[]{"Array", "BasicSocket", "Bignum", "Class", "Complex", "Continuation", "Data", "Date", "DateTime", "Delegator", "Dir", "Enumerable", "Error", "FalseClass", "File", "Fixnum", "Float", "Generator", "Hash", "IO", "IPSocket", "Iconv", "Integer", "Interrupt", "InvalidArgument", "List", "LoadError", "LocalJumpError", "Monitor", "NameError", "NilClass", "Numeric", "ParseError", "Prime", "Range", "RangeError", "Rational", "RegAnd", "RegOr", "Regexp", "RegexpError", "ScriptError", "SecurityError", "Set", "Shell", "SignalException", "SimpleDelegator", "SizedQueue", "Socket", "SocketError", "SortedSet", "StandardError", "String", "StringIO", "Struct", "Symbol", "SyncEnumerator", "SyntaxError", "SystemCallError", "SystemExit", " \tSystemStackError", "TCPServer", "TCPSocket", "TempFile", "Thread", "ThreadError", "Time", "Timeout", "Tracer", "TrueClass", "TruncatedDataError", "TypeError", "UDPSocket", "URI", "UnboundMethod", "Vector", "ZeroDivisionError"};

    public RubyType(RubyElement parent, String name) {
        super(parent, name);
    }

    public String getSuperclassName() throws RubyModelException {
        IType type;
        if (this.isCoreClass() && !this.isCoreStub() && (type = this.getCoreClass(this.getElementName())) != null) {
            return type.getSuperclassName();
        }
        RubyTypeElementInfo info = (RubyTypeElementInfo)this.getElementInfo();
        return info.getSuperclassName();
    }

    private boolean isCoreStub() throws RubyModelException {
        ISourceFolderRoot root = (ISourceFolderRoot)this.getAncestor(2);
        return root.equals(this.getCoreStubRoot());
    }

    private IType getCoreClass(String elementName) throws RubyModelException {
        ISourceFolderRoot root = this.getCoreStubRoot();
        if (root == null) {
            return null;
        }
        ISourceFolder folder = root.getSourceFolder(new String[0]);
        IRubyScript script = folder.getRubyScript(String.valueOf(elementName.toLowerCase()) + ".rb");
        return script.getType(elementName);
    }

    private ISourceFolderRoot getCoreStubRoot() throws RubyModelException {
        ISourceFolderRoot[] roots = this.getRubyProject().getSourceFolderRoots();
        int i = 0;
        while (i < roots.length) {
            IPath path = roots[i].getPath();
            String string = path.toPortableString();
            if (string.contains("org.rubypeople.rdt.launching")) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isCoreClass() {
        String name = this.getElementName();
        int i = 0;
        while (i < CORE_NAMES.length) {
            if (CORE_NAMES[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getIncludedModuleNames() throws RubyModelException {
        RubyTypeElementInfo info = (RubyTypeElementInfo)this.getElementInfo();
        String[] modules = info.getIncludedModuleNames();
        if ((modules == null || modules.length == 0) && this.getFullyQualifiedName().equals("Object")) {
            return new String[]{"Kernel"};
        }
        return modules;
    }

    public boolean isMember() {
        return this.getDeclaringType() != null;
    }

    public int getElementType() {
        return 5;
    }

    public IField getField(String fieldName) {
        if (fieldName.startsWith("@@")) {
            return new RubyClassVar(this, fieldName);
        }
        if (fieldName.startsWith("@")) {
            return new RubyInstVar(this, fieldName);
        }
        if (fieldName.startsWith("$")) {
            return new RubyGlobal((IRubyElement)this, fieldName);
        }
        if (Character.isUpperCase(fieldName.charAt(0))) {
            return new RubyConstant(this, fieldName);
        }
        Assert.isTrue((boolean)false, (String)"Tried to access a field which isn't an instance variable, class variable, global or constant");
        return null;
    }

    public IField[] getFields() throws RubyModelException {
        ArrayList<IRubyElement> list = this.getChildrenOfType(9);
        list.addAll(this.getChildrenOfType(11));
        list.addAll(this.getChildrenOfType(10));
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    public IMethod getMethod(String name, String[] parameterNames) {
        return new RubyMethod(this, name, parameterNames);
    }

    public IMethod[] getMethods() throws RubyModelException {
        ArrayList<IRubyElement> list = this.getChildrenOfType(6);
        IMethod[] array = new IMethod[list.size()];
        list.toArray(array);
        return array;
    }

    public IType getDeclaringType() {
        for (IRubyElement parentElement = this.getParent(); parentElement != null; parentElement = parentElement.getParent()) {
            if (parentElement.getElementType() == 5) {
                return (IType)parentElement;
            }
            if (parentElement instanceof IMember) {
                continue;
            }
            return null;
        }
        return null;
    }

    public IRubyElement getPrimaryElement(boolean checkOwner) {
        RubyScript cu;
        if (checkOwner && (cu = (RubyScript)this.getAncestor(4)).isPrimary()) {
            return this;
        }
        IRubyElement primaryParent = this.parent.getPrimaryElement(false);
        switch (primaryParent.getElementType()) {
            case 4: {
                return ((IRubyScript)primaryParent).getType(this.name);
            }
            case 5: {
                return ((IType)primaryParent).getType(this.name);
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return ((IMember)primaryParent).getType(this.name, this.occurrenceCount);
            }
        }
        return this;
    }

    public IType getType(String typeName) {
        return new RubyType(this, typeName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RubyType)) {
            return false;
        }
        return super.equals(o);
    }

    public boolean isClass() {
        return true;
    }

    public boolean isModule() {
        return false;
    }

    public IMethod createMethod(String contents, IRubyElement sibling, boolean force, IProgressMonitor monitor) throws RubyModelException {
        CreateMethodOperation op = new CreateMethodOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return (IMethod)op.getResultElements()[0];
    }

    public ISourceFolder getSourceFolder() {
        IRubyElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 3) {
                return (ISourceFolder)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public String getFullyQualifiedName() {
        IType declaring = this.getDeclaringType();
        if (declaring != null) {
            return String.valueOf(declaring.getFullyQualifiedName()) + "::" + this.getElementName();
        }
        return this.getElementName();
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String fieldName = memento.nextToken();
                RubyElement field = (RubyElement)((Object)this.getField(fieldName));
                return field.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '~': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String selector = memento.nextToken();
                ArrayList<String> params = new ArrayList<String>();
                block13: while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    switch (token.charAt(0)) {
                        case '[': {
                            break block13;
                        }
                        case '~': {
                            if (!memento.hasMoreTokens()) {
                                return this;
                            }
                            String param = memento.nextToken();
                            StringBuffer buffer = new StringBuffer();
                            params.add(String.valueOf(buffer.toString()) + param);
                            break;
                        }
                        default: {
                            break block13;
                        }
                    }
                }
                String[] parameters = new String[params.size()];
                params.toArray(parameters);
                RubyElement method = (RubyElement)((Object)this.getMethod(selector, parameters));
                switch (token.charAt(0)) {
                    case '@': 
                    case '[': {
                        return method.getHandleFromMemento(token, memento, workingCopyOwner);
                    }
                }
                return method;
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                RubyElement type = (RubyElement)((Object)this.getType(typeName));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
        }
        return null;
    }

    public String getTypeQualifiedName(String enclosingTypeSeparator) {
        try {
            return this.getTypeQualifiedName(enclosingTypeSeparator, false);
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
    }

    public IType[] getTypes() throws RubyModelException {
        ArrayList<IRubyElement> list = this.getChildrenOfType(5);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public ITypeHierarchy newTypeHierarchy(IProgressMonitor monitor) throws RubyModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, null, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws RubyModelException {
        IRubyScript[] workingCopies = RubyModelManager.getRubyModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws RubyModelException {
        return this.newSupertypeHierarchy(DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws RubyModelException {
        IRubyScript[] workingCopies = RubyModelManager.getRubyModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    public IMethod[] findMethods(IMethod method) {
        ArrayList<IMethod> filtered = new ArrayList<IMethod>();
        try {
            ArrayList<IRubyElement> list = this.getChildrenOfType(6);
            for (IRubyElement element : list) {
                IMethod other = (IMethod)element;
                if (!other.getElementName().equals(method.getElementName())) continue;
                filtered.add(other);
            }
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
        IMethod[] array = new IMethod[filtered.size()];
        filtered.toArray(array);
        return array;
    }
}

