/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.util.HashtableOfArrayToObject;
import org.rubypeople.rdt.internal.core.util.Util;

class RubyProjectElementInfo
extends OpenableElementInfo {
    private Object[] nonRubyResources = null;
    public ProjectCache projectCache;

    private Object[] computeNonRubyResources(RubyProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = null;
        ILoadpathEntry[] classpath = null;
        try {
            classpath = project.getResolvedLoadpath(true, false, false);
            int i = 0;
            while (i < classpath.length) {
                ILoadpathEntry entry = classpath[i];
                if (projectPath.equals((Object)entry.getPath())) {
                    srcIsProject = true;
                    inclusionPatterns = ((LoadpathEntry)entry).fullInclusionPatternChars();
                    exclusionPatterns = ((LoadpathEntry)entry).fullExclusionPatternChars();
                    break;
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        Object[] resources = new IResource[5];
        int resourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource res = members[i];
                switch (res.getType()) {
                    case 1: {
                        IPath resFullPath = res.getFullPath();
                        res.getName();
                        if (srcIsProject && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns)) break;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                        break;
                    }
                    case 2: {
                        IPath resFullPath = res.getFullPath();
                        if (srcIsProject && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) || this.isLoadpathEntryOrOutputLocation(resFullPath, classpath)) break;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                    }
                }
                ++i;
            }
            if (resources.length != resourcesCounter) {
                Object[] objectArray = resources;
                resources = new IResource[resourcesCounter];
                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
            }
        }
        catch (CoreException coreException) {
            resources = NO_NON_RUBY_RESOURCES;
            resourcesCounter = 0;
        }
        return resources;
    }

    Object[] getNonRubyResources(RubyProject project) {
        if (this.nonRubyResources == null) {
            this.nonRubyResources = this.computeNonRubyResources(project);
        }
        return this.nonRubyResources;
    }

    private boolean isLoadpathEntryOrOutputLocation(IPath path, ILoadpathEntry[] resolvedLoadpath) {
        int i = 0;
        int length = resolvedLoadpath.length;
        while (i < length) {
            ILoadpathEntry entry = resolvedLoadpath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void resetCaches() {
        this.projectCache = null;
    }

    void setNonRubyResources(Object[] resources) {
        this.nonRubyResources = resources;
    }

    ProjectCache getProjectCache(RubyProject project) {
        ProjectCache cache = this.projectCache;
        if (cache == null) {
            ISourceFolderRoot[] roots;
            HashMap reverseMap = new HashMap(3);
            try {
                roots = project.getAllSourceFolderRoots(reverseMap);
            }
            catch (RubyModelException rubyModelException) {
                roots = new ISourceFolderRoot[]{};
                reverseMap.clear();
            }
            HashtableOfArrayToObject fragmentsCache = new HashtableOfArrayToObject();
            HashtableOfArrayToObject isPackageCache = new HashtableOfArrayToObject();
            int i = 0;
            int length = roots.length;
            while (i < length) {
                block11: {
                    ISourceFolderRoot root = roots[i];
                    IRubyElement[] frags = null;
                    try {
                        frags = root.getChildren();
                    }
                    catch (RubyModelException rubyModelException) {
                        break block11;
                    }
                    int j = 0;
                    int length2 = frags.length;
                    while (j < length2) {
                        SourceFolder fragment = (SourceFolder)frags[j];
                        Object[] pkgName = fragment.names;
                        Object existing = fragmentsCache.get(pkgName);
                        if (existing == null) {
                            fragmentsCache.put(pkgName, root);
                            RubyProjectElementInfo.addNames((String[])pkgName, isPackageCache);
                        } else if (existing instanceof SourceFolderRoot) {
                            fragmentsCache.put(pkgName, new ISourceFolderRoot[]{(SourceFolderRoot)existing, root});
                        } else {
                            ISourceFolderRoot[] entry = (ISourceFolderRoot[])existing;
                            ISourceFolderRoot[] copy = new ISourceFolderRoot[entry.length + 1];
                            System.arraycopy(entry, 0, copy, 0, entry.length);
                            copy[entry.length] = root;
                            fragmentsCache.put(pkgName, copy);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            this.projectCache = cache = new ProjectCache(roots, fragmentsCache, isPackageCache, reverseMap);
        }
        return cache;
    }

    public static void addNames(String[] name, HashtableOfArrayToObject set) {
        set.put(name, name);
        int length = name.length;
        int i = length - 1;
        while (i > 0) {
            Object[] superName = new String[i];
            System.arraycopy(name, 0, superName, 0, i);
            set.put(superName, superName);
            --i;
        }
    }

    static class ProjectCache {
        public ISourceFolderRoot[] allPkgFragmentRootsCache;
        public HashtableOfArrayToObject allPkgFragmentsCache;
        public HashtableOfArrayToObject isPackageCache;
        public Map rootToResolvedEntries;

        ProjectCache(ISourceFolderRoot[] allPkgFragmentRootsCache, HashtableOfArrayToObject allPkgFragmentsCache, HashtableOfArrayToObject isPackageCache, Map rootToResolvedEntries) {
            this.allPkgFragmentRootsCache = allPkgFragmentRootsCache;
            this.allPkgFragmentsCache = allPkgFragmentsCache;
            this.isPackageCache = isPackageCache;
            this.rootToResolvedEntries = rootToResolvedEntries;
        }
    }
}

