/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRegion;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.compiler.util.ObjectVector;
import org.rubypeople.rdt.internal.core.CreateTypeHierarchyOperation;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.ExternalSourceFolderRoot;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyProjectElementInfo;
import org.rubypeople.rdt.internal.core.SetLoadpathOperation;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.XMLWriter;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RubyProject
extends Openable
implements IProjectNature,
IRubyElement,
IRubyProject {
    protected IProject project;
    protected boolean scratched;
    private static final String PREF_FILENAME = ".rprefs";
    private static final ILoadpathEntry[] RESOLUTION_IN_PROGRESS = new ILoadpathEntry[0];
    static final String LOADPATH_FILENAME = ".loadpath";
    static final ILoadpathEntry[] INVALID_LOADPATH = new ILoadpathEntry[0];
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    protected static final String[] NO_PREREQUISITES = new String[0];

    public RubyProject() {
        super(null);
    }

    public RubyProject(IProject aProject, RubyElement parent) {
        super(parent);
        this.setProject(aProject);
    }

    public void configure() throws CoreException {
        this.addToBuildSpec("org.rubypeople.rdt.core.rubybuilder");
    }

    protected boolean addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        int commandIndex = this.getRubyCommandIndex(description.getBuildSpec());
        if (commandIndex == -1) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setRubyCommand(description, command);
            return true;
        }
        return false;
    }

    private int getRubyCommandIndex(ICommand[] buildSpec) {
        int i = 0;
        while (i < buildSpec.length) {
            if (buildSpec[i].getBuilderName().equals("org.rubypeople.rdt.core.rubybuilder")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setRubyCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldBuildSpec = description.getBuildSpec();
        int oldRubyCommandIndex = this.getRubyCommandIndex(oldBuildSpec);
        if (oldRubyCommandIndex == -1) {
            newCommands = new ICommand[oldBuildSpec.length + 1];
            System.arraycopy(oldBuildSpec, 0, newCommands, 1, oldBuildSpec.length);
            newCommands[0] = newCommand;
        } else {
            oldBuildSpec[oldRubyCommandIndex] = newCommand;
            newCommands = oldBuildSpec;
        }
        description.setBuildSpec(newCommands);
        this.project.setDescription(description, null);
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.rubypeople.rdt.core.rubybuilder");
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RubyProject)) {
            return false;
        }
        RubyProject other = (RubyProject)o;
        return this.project.equals((Object)other.getProject());
    }

    public int hashCode() {
        if (this.project == null) {
            return super.hashCode() * 10 + 1;
        }
        return this.project.hashCode() * 10 + 2;
    }

    public boolean exists() {
        return RubyProject.hasRubyNature(this.project);
    }

    public RubyModelManager.PerProjectInfo getPerProjectInfo() throws RubyModelException {
        return RubyModelManager.getRubyModelManager().getPerProjectInfoCheckExistence(this.project);
    }

    private IPath getPluginWorkingLocation() {
        return this.project.getWorkingLocation("org.rubypeople.rdt.core");
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getPath() {
        return this.project.getFullPath();
    }

    protected IProject getProject(String name) {
        return RubyCore.getWorkspace().getRoot().getProject(name);
    }

    public void setProject(IProject aProject) {
        this.project = aProject;
    }

    public IResource getResource() {
        return this.project;
    }

    public String[] getRequiredProjectNames() throws RubyModelException {
        return this.projectPrerequisites(this.getResolvedLoadpath(true, false, false));
    }

    public String[] projectPrerequisites(ILoadpathEntry[] entries) throws RubyModelException {
        ArrayList<String> prerequisites = new ArrayList<String>();
        entries = this.getResolvedLoadpath(entries, null, true, false, null);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            ILoadpathEntry entry = entries[i];
            if (entry.getEntryKind() == 2) {
                prerequisites.add(entry.getPath().lastSegment());
            }
            ++i;
        }
        int size = prerequisites.size();
        if (size == 0) {
            return NO_PREREQUISITES;
        }
        String[] result = new String[size];
        prerequisites.toArray(result);
        return result;
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.project;
    }

    public IEclipsePreferences getEclipsePreferences() {
        if (!RubyProject.hasRubyNature(this.project)) {
            return null;
        }
        RubyModelManager.PerProjectInfo perProjectInfo = RubyModelManager.getRubyModelManager().getPerProjectInfo(this.project, true);
        if (perProjectInfo.preferences != null) {
            return perProjectInfo.preferences;
        }
        ProjectScope context = new ProjectScope(this.getProject());
        final IEclipsePreferences eclipsePreferences = context.getNode("org.rubypeople.rdt.core");
        this.updatePreferences(eclipsePreferences);
        perProjectInfo.preferences = eclipsePreferences;
        IEclipsePreferences.INodeChangeListener nodeListener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == eclipsePreferences) {
                    RubyModelManager.getRubyModelManager().resetProjectPreferences(RubyProject.this);
                }
            }
        };
        ((IEclipsePreferences)eclipsePreferences.parent()).addNodeChangeListener(nodeListener);
        IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                RubyModelManager.getRubyModelManager().resetProjectOptions(RubyProject.this);
            }
        };
        eclipsePreferences.addPreferenceChangeListener(preferenceListener);
        return eclipsePreferences;
    }

    public String getElementName() {
        if (this.project == null) {
            return super.getElementName();
        }
        return this.project.getName();
    }

    public int getElementType() {
        return 1;
    }

    public boolean hasChildren() {
        return true;
    }

    public IType findType(String fullyQualifiedName) {
        return this.findType(fullyQualifiedName, null);
    }

    public IType findType(String fullyQualifiedName, IProgressMonitor monitor) {
        try {
            SearchEngine engine = new SearchEngine();
            SearchPattern pattern = SearchPattern.createPattern(5, fullyQualifiedName, 0, 0);
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            IRubySearchScope scope = SearchEngine.createWorkspaceScope();
            CollectingSearchRequestor requestor = new CollectingSearchRequestor();
            engine.search(pattern, participants, scope, requestor, monitor);
            List<SearchMatch> matches = requestor.getResults();
            for (SearchMatch match : matches) {
                IType type = (IType)match.getElement();
                if (!type.getFullyQualifiedName().equals(fullyQualifiedName)) continue;
                return type;
            }
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
        return null;
    }

    public static boolean hasRubyNature(IProject project) {
        try {
            return project.hasNature("org.rubypeople.rdt.core.rubynature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws RubyModelException {
        if (!RubyProject.hasRubyNature((IProject)underlyingResource)) {
            throw new RubyModelException(new RubyModelStatus(1007, this));
        }
        ILoadpathEntry[] resolvedClasspath = this.getResolvedLoadpath(true, false, false);
        info.setChildren(this.computeSourceFolderRoots(resolvedClasspath, false, null));
        this.getPerProjectInfo().rememberExternalLibTimestamps();
        return true;
    }

    public ISourceFolderRoot[] computeSourceFolderRoots(ILoadpathEntry[] resolvedClasspath, boolean retrieveExportedRoots, Map rootToResolvedEntries) throws RubyModelException {
        ObjectVector accumulatedRoots = new ObjectVector();
        this.computeSourceFolderRoots(resolvedClasspath, accumulatedRoots, new HashSet(5), null, true, retrieveExportedRoots, rootToResolvedEntries);
        Object[] rootArray = new ISourceFolderRoot[accumulatedRoots.size()];
        accumulatedRoots.copyInto(rootArray);
        return rootArray;
    }

    public void computeSourceFolderRoots(ILoadpathEntry[] resolvedClasspath, ObjectVector accumulatedRoots, HashSet rootIDs, ILoadpathEntry referringEntry, boolean checkExistency, boolean retrieveExportedRoots, Map rootToResolvedEntries) throws RubyModelException {
        if (referringEntry == null) {
            rootIDs.add(this.rootID());
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            this.computeSourceFolderRoots(resolvedClasspath[i], accumulatedRoots, rootIDs, referringEntry, checkExistency, retrieveExportedRoots, rootToResolvedEntries);
            ++i;
        }
    }

    public void computeSourceFolderRoots(ILoadpathEntry resolvedEntry, ObjectVector accumulatedRoots, HashSet rootIDs, ILoadpathEntry referringEntry, boolean checkExistency, boolean retrieveExportedRoots, Map rootToResolvedEntries) throws RubyModelException {
        String rootID = ((LoadpathEntry)resolvedEntry).rootID();
        if (rootIDs.contains(rootID)) {
            return;
        }
        IPath projectPath = this.project.getFullPath();
        IPath entryPath = resolvedEntry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ISourceFolderRoot root = null;
        switch (resolvedEntry.getEntryKind()) {
            case 3: {
                if (!projectPath.isPrefixOf(entryPath)) break;
                if (checkExistency) {
                    Object target = RubyModel.getTarget(entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!(target instanceof IFolder) && !(target instanceof IProject)) break;
                    root = this.getSourceFolderRoot((IResource)target);
                    break;
                }
                root = this.getFolderSourceFolderRoot(entryPath);
                break;
            }
            case 1: {
                if (referringEntry != null && !resolvedEntry.isExported()) {
                    return;
                }
                if (checkExistency) {
                    Object target = RubyModel.getTarget(entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (target instanceof IResource) {
                        root = this.getSourceFolderRoot((IResource)target);
                        break;
                    }
                    if (!RubyModel.isFolder(target)) break;
                    root = new ExternalSourceFolderRoot(entryPath, this);
                    break;
                }
                root = this.getSourceFolderRoot(entryPath);
                break;
            }
            case 2: {
                IProject requiredProjectRsc;
                if (!retrieveExportedRoots) {
                    return;
                }
                if (referringEntry != null && !resolvedEntry.isExported()) {
                    return;
                }
                IResource member = workspaceRoot.findMember(entryPath);
                if (member == null || member.getType() != 4 || !RubyProject.hasRubyNature(requiredProjectRsc = (IProject)member)) break;
                rootIDs.add(rootID);
                RubyProject requiredProject = (RubyProject)RubyCore.create(requiredProjectRsc);
                requiredProject.computeSourceFolderRoots(requiredProject.getResolvedLoadpath(true, false, false), accumulatedRoots, rootIDs, rootToResolvedEntries == null ? resolvedEntry : ((LoadpathEntry)resolvedEntry).combineWith((LoadpathEntry)referringEntry), checkExistency, retrieveExportedRoots, rootToResolvedEntries);
            }
        }
        if (root != null) {
            accumulatedRoots.add(root);
            rootIDs.add(rootID);
            if (rootToResolvedEntries != null) {
                rootToResolvedEntries.put(root, ((LoadpathEntry)resolvedEntry).combineWith((LoadpathEntry)referringEntry));
            }
        }
    }

    public ISourceFolderRoot getSourceFolderRoot(IPath path) {
        if (!path.isAbsolute()) {
            path = this.getPath().append(path);
        }
        int segmentCount = path.segmentCount();
        switch (segmentCount) {
            case 0: {
                return null;
            }
            case 1: {
                if (!path.equals((Object)this.getPath())) break;
                return this.getSourceFolderRoot((IResource)this.project);
            }
        }
        if (segmentCount == 1) {
            return this.getSourceFolderRoot((IResource)this.project.getWorkspace().getRoot().getProject(path.lastSegment()));
        }
        return this.getSourceFolderRoot((IResource)this.project.getWorkspace().getRoot().getFolder(path));
    }

    public boolean contains(IResource resource) {
        return true;
    }

    public String rootID() {
        return "[PRJ]" + this.project.getFullPath();
    }

    protected Object createElementInfo() {
        return new RubyProjectElementInfo();
    }

    public String getOption(String optionName, boolean inheritRubyCoreOptions) {
        String propertyName = optionName;
        if (RubyModelManager.getRubyModelManager().optionNames.contains(propertyName)) {
            String javaCoreDefault;
            IEclipsePreferences projectPreferences = this.getEclipsePreferences();
            String string = javaCoreDefault = inheritRubyCoreOptions ? RubyCore.getOption(propertyName) : null;
            if (projectPreferences == null) {
                return javaCoreDefault;
            }
            String value = projectPreferences.get(propertyName, javaCoreDefault);
            return value == null ? null : value.trim();
        }
        return null;
    }

    public Map getOptions(boolean inheritRubyCoreOptions) {
        Hashtable<String, String> options = inheritRubyCoreOptions ? RubyCore.getOptions() : new Hashtable<String, String>(5);
        RubyModelManager.PerProjectInfo perProjectInfo = null;
        Hashtable<String, String> projectOptions = null;
        HashSet<String> optionNames = RubyModelManager.getRubyModelManager().optionNames;
        try {
            perProjectInfo = this.getPerProjectInfo();
            projectOptions = perProjectInfo.options;
            if (projectOptions == null) {
                IEclipsePreferences projectPreferences = this.getEclipsePreferences();
                if (projectPreferences == null) {
                    return options;
                }
                String[] propertyNames = projectPreferences.keys();
                projectOptions = new Hashtable(propertyNames.length);
                int i = 0;
                while (i < propertyNames.length) {
                    String propertyName = propertyNames[i];
                    String value = projectPreferences.get(propertyName, null);
                    if (value != null && optionNames.contains(propertyName)) {
                        projectOptions.put(propertyName, value.trim());
                    }
                    ++i;
                }
                perProjectInfo.options = projectOptions;
            }
        }
        catch (RubyModelException rubyModelException) {
            projectOptions = new Hashtable();
        }
        catch (BackingStoreException backingStoreException) {
            projectOptions = new Hashtable();
        }
        if (inheritRubyCoreOptions) {
            for (Map.Entry<String, String> entry : projectOptions.entrySet()) {
                String propertyName = entry.getKey();
                String propertyValue = entry.getValue();
                if (propertyValue == null || !optionNames.contains(propertyName)) continue;
                options.put(propertyName, propertyValue.trim());
            }
            return options;
        }
        return projectOptions;
    }

    private void updatePreferences(IEclipsePreferences preferences) {
        Preferences oldPreferences = this.loadPreferences();
        if (oldPreferences != null) {
            String[] propertyNames = oldPreferences.propertyNames();
            int i = 0;
            while (i < propertyNames.length) {
                String propertyName = propertyNames[i];
                String propertyValue = oldPreferences.getString(propertyName);
                if (!"".equals(propertyValue)) {
                    preferences.put(propertyName, propertyValue);
                }
                ++i;
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private Preferences loadPreferences() {
        File prefFile;
        Preferences preferences = new Preferences();
        IPath projectMetaLocation = this.getPluginWorkingLocation();
        if (projectMetaLocation != null && (prefFile = projectMetaLocation.append(PREF_FILENAME).toFile()).exists()) {
            block15: {
                InputStream in = null;
                try {
                    try {
                        in = new BufferedInputStream(new FileInputStream(prefFile));
                        preferences.load(in);
                    }
                    catch (IOException iOException) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            prefFile.delete();
            return preferences;
        }
        return null;
    }

    public void resetCaches() {
        RubyProjectElementInfo info = (RubyProjectElementInfo)RubyModelManager.getRubyModelManager().peekAtInfo(this);
        if (info != null) {
            info.resetCaches();
        }
    }

    public Object[] getNonRubyResources() throws RubyModelException {
        return ((RubyProjectElementInfo)this.getElementInfo()).getNonRubyResources(this);
    }

    public ISourceFolder[] getSourceFolders() throws RubyModelException {
        ISourceFolderRoot[] roots = this.getSourceFolderRoots();
        return this.getSourceFoldersInRoots(roots);
    }

    public ISourceFolder[] getSourceFoldersInRoots(ISourceFolderRoot[] roots) {
        ArrayList<IRubyElement> frags = new ArrayList<IRubyElement>();
        int i = 0;
        while (i < roots.length) {
            ISourceFolderRoot root = roots[i];
            try {
                IRubyElement[] rootFragments = root.getChildren();
                int j = 0;
                while (j < rootFragments.length) {
                    frags.add(rootFragments[j]);
                    ++j;
                }
            }
            catch (RubyModelException rubyModelException) {}
            ++i;
        }
        ISourceFolder[] fragments = new ISourceFolder[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    public ILoadpathEntry[] getRawLoadpath(boolean createMarkers, boolean logProblems) throws RubyModelException {
        ILoadpathEntry[] classpath;
        RubyModelManager.PerProjectInfo perProjectInfo = null;
        if (createMarkers) {
            this.flushLoadpathProblemMarkers(false, true);
            classpath = this.readLoadpathFile(createMarkers, logProblems);
        } else {
            perProjectInfo = this.getPerProjectInfo();
            classpath = perProjectInfo.rawLoadpath;
            if (classpath != null) {
                return classpath;
            }
            classpath = this.readLoadpathFile(createMarkers, logProblems);
        }
        if (classpath == null) {
            return this.defaultLoadpath();
        }
        if (!createMarkers) {
            perProjectInfo.rawLoadpath = classpath;
            perProjectInfo.outputLocation = null;
        }
        return classpath;
    }

    protected ILoadpathEntry[] defaultLoadpath() {
        return new ILoadpathEntry[]{RubyCore.newSourceEntry(this.project.getFullPath())};
    }

    public ILoadpathEntry[] readRawLoadpath() {
        return this.readLoadpathFile(false, false);
    }

    protected ILoadpathEntry[] readLoadpathFile(boolean createMarker, boolean logProblems) {
        return this.readLoadpathFile(createMarker, logProblems, null);
    }

    protected ILoadpathEntry[] readLoadpathFile(boolean createMarker, boolean logProblems, Map unknownElements) {
        String xmlClasspath;
        block6: {
            try {
                xmlClasspath = this.getSharedProperty(LOADPATH_FILENAME);
                if (xmlClasspath != null) break block6;
                if (createMarker && this.project.isAccessible()) {
                    this.createLoadpathProblemMarker(new RubyModelStatus(1000, Messages.bind(Messages.classpath_cannotReadClasspathFile, this.getElementName())));
                }
                return null;
            }
            catch (CoreException e) {
                if (createMarker && this.project.isAccessible()) {
                    this.createLoadpathProblemMarker(new RubyModelStatus(1000, Messages.bind(Messages.classpath_cannotReadClasspathFile, this.getElementName())));
                }
                if (logProblems) {
                    Util.log(e, "Exception while retrieving " + this.getPath() + "/.loadpath, will revert to default loadpath");
                }
                return null;
            }
        }
        return this.decodeLoadpath(xmlClasspath, createMarker, logProblems, unknownElements);
    }

    protected ILoadpathEntry[] decodeLoadpath(String xmlClasspath, boolean createMarker, boolean logProblems, Map unknownElements) {
        ArrayList<ILoadpathEntry> paths;
        block17: {
            paths = new ArrayList<ILoadpathEntry>();
            if (xmlClasspath != null) break block17;
            return null;
        }
        try {
            Element cpElement;
            StringReader reader = new StringReader(xmlClasspath);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(Messages.file_badFormat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(Messages.file_badFormat);
                }
            }
            finally {
                reader.close();
            }
            if (!cpElement.getNodeName().equalsIgnoreCase("loadpath")) {
                throw new IOException(Messages.file_badFormat);
            }
            NodeList list = cpElement.getElementsByTagName("pathentry");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                ILoadpathEntry entry;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && (entry = LoadpathEntry.elementDecode((Element)node, this, unknownElements)) != null) {
                    paths.add(entry);
                }
                ++i;
            }
        }
        catch (IOException e) {
            if (createMarker && this.project.isAccessible()) {
                this.createLoadpathProblemMarker(new RubyModelStatus(1000, Messages.bind(Messages.classpath_xmlFormatError, new String[]{this.getElementName(), e.getMessage()})));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will mark classpath as invalid");
            }
            return INVALID_LOADPATH;
        }
        catch (AssertionFailedException e) {
            if (createMarker && this.project.isAccessible()) {
                this.createLoadpathProblemMarker(new RubyModelStatus(1000, Messages.bind(Messages.classpath_illegalEntryInClasspathFile, new String[]{this.getElementName(), e.getMessage()})));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will mark classpath as invalid");
            }
            return INVALID_LOADPATH;
        }
        int pathSize = paths.size();
        ILoadpathEntry[] entries = new ILoadpathEntry[pathSize];
        paths.toArray(entries);
        return entries;
    }

    public String getSharedProperty(String key) throws CoreException {
        String property = null;
        IFile rscFile = this.project.getFile(key);
        if (rscFile.exists()) {
            byte[] bytes = Util.getResourceContentsAsByteArray(rscFile);
            try {
                property = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.log(e, "Could not read .classpath with UTF-8 encoding");
                property = new String(bytes);
            }
        } else {
            File file;
            URI location = rscFile.getLocationURI();
            if (location != null && (file = Util.toLocalFile(location, null)) != null && file.exists()) {
                byte[] bytes;
                try {
                    bytes = org.rubypeople.rdt.core.util.Util.getFileByteContent(file);
                }
                catch (IOException iOException) {
                    return null;
                }
                try {
                    property = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Util.log(e, "Could not read .classpath with UTF-8 encoding");
                    property = new String(bytes);
                }
            }
        }
        return property;
    }

    public ILoadpathEntry[] getResolvedLoadpath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError) throws RubyModelException {
        return this.getResolvedLoadpath(ignoreUnresolvedEntry, generateMarkerOnError, true);
    }

    public ILoadpathEntry[] getResolvedLoadpath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, boolean returnResolutionInProgress) throws RubyModelException {
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        RubyModelManager.PerProjectInfo perProjectInfo = null;
        if (ignoreUnresolvedEntry && !generateMarkerOnError && (perProjectInfo = this.getPerProjectInfo()) != null) {
            ILoadpathEntry[] infoPath = perProjectInfo.resolvedLoadpath;
            if (infoPath != null) {
                return infoPath;
            }
            if (returnResolutionInProgress && manager.isLoadpathBeingResolved(this)) {
                if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                    Util.verbose("CPResolution: reentering raw loadpath resolution, will use empty loadpath instead\tproject: " + this.getElementName() + '\n' + "\tinvocation stack trace:");
                    new Exception("<Fake exception>").printStackTrace(System.out);
                }
                return RESOLUTION_IN_PROGRESS;
            }
        }
        HashMap rawReverseMap = perProjectInfo == null ? null : new HashMap(5);
        ILoadpathEntry[] resolvedPath = null;
        boolean nullOldResolvedCP = perProjectInfo != null && perProjectInfo.resolvedLoadpath == null;
        try {
            if (nullOldResolvedCP) {
                manager.setLoadpathBeingResolved(this, true);
            }
            resolvedPath = this.getResolvedLoadpath(this.getRawLoadpath(generateMarkerOnError, !generateMarkerOnError), null, ignoreUnresolvedEntry, generateMarkerOnError, rawReverseMap);
        }
        finally {
            if (nullOldResolvedCP) {
                perProjectInfo.resolvedLoadpath = null;
            }
        }
        if (perProjectInfo != null) {
            if (perProjectInfo.rawLoadpath == null && generateMarkerOnError && RubyProject.hasRubyNature(this.project)) {
                this.flushLoadpathProblemMarkers(false, true);
                this.createLoadpathProblemMarker(new RubyModelStatus(1000, Messages.bind(Messages.classpath_cannotReadClasspathFile, this.getElementName())));
            }
            perProjectInfo.resolvedLoadpath = resolvedPath;
            perProjectInfo.resolvedPathToRawEntries = rawReverseMap;
            manager.setLoadpathBeingResolved(this, false);
        }
        return resolvedPath;
    }

    /*
     * Unable to fully structure code
     */
    public ILoadpathEntry[] getResolvedLoadpath(ILoadpathEntry[] classpathEntries, IPath projectOutputLocation, boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, Map rawReverseMap) throws RubyModelException {
        if (generateMarkerOnError) {
            this.flushLoadpathProblemMarkers(false, false);
        }
        length = classpathEntries.length;
        resolvedEntries = new ArrayList<ILoadpathEntry>();
        i = 0;
        while (i < length) {
            block17: {
                block16: {
                    rawEntry = classpathEntries[i];
                    status = null;
                    if (!generateMarkerOnError && ignoreUnresolvedEntry) break block16;
                    status = LoadpathEntry.validateLoadpathEntry(this, rawEntry, false, false);
                    if (!generateMarkerOnError || status.isOK()) break block16;
                    if (status.getCode() == 964 && ((LoadpathEntry)rawEntry).isOptional()) break block17;
                    this.createLoadpathProblemMarker(status);
                }
                switch (rawEntry.getEntryKind()) {
                    case 4: {
                        resolvedEntry = null;
                        try {
                            resolvedEntry = RubyCore.getResolvedLoadpathEntry(rawEntry);
                        }
                        catch (AssertionFailedException v0) {
                            if (ignoreUnresolvedEntry) ** GOTO lbl24
                            throw new RubyModelException(status);
                        }
lbl24:
                        // 2 sources

                        if (resolvedEntry == null) {
                            if (ignoreUnresolvedEntry) break;
                            throw new RubyModelException(status);
                        }
                        if (rawReverseMap != null && rawReverseMap.get(resolvedPath = resolvedEntry.getPath()) == null) {
                            rawReverseMap.put(resolvedPath, rawEntry);
                        }
                        resolvedEntries.add(resolvedEntry);
                        break;
                    }
                    case 5: {
                        container = RubyCore.getLoadpathContainer(rawEntry.getPath(), this);
                        if (container == null) {
                            if (ignoreUnresolvedEntry) break;
                            throw new RubyModelException(status);
                        }
                        containerEntries = container.getLoadpathEntries();
                        if (containerEntries == null) break;
                        j = 0;
                        containerLength = containerEntries.length;
                        while (j < containerLength) {
                            cEntry = (LoadpathEntry)containerEntries[j];
                            if (generateMarkerOnError && !(containerStatus = LoadpathEntry.validateLoadpathEntry(this, cEntry, false, true)).isOK()) {
                                this.createLoadpathProblemMarker(containerStatus);
                            }
                            cEntry = cEntry.combineWith((LoadpathEntry)rawEntry);
                            if (rawReverseMap != null && rawReverseMap.get(resolvedPath = cEntry.getPath()) == null) {
                                rawReverseMap.put(resolvedPath, rawEntry);
                            }
                            resolvedEntries.add(cEntry);
                            ++j;
                        }
                        break;
                    }
                    default: {
                        if (rawReverseMap != null && rawReverseMap.get(resolvedPath = rawEntry.getPath()) == null) {
                            rawReverseMap.put(resolvedPath, rawEntry);
                        }
                        resolvedEntries.add(rawEntry);
                    }
                }
            }
            ++i;
        }
        resolvedPath = new ILoadpathEntry[resolvedEntries.size()];
        resolvedEntries.toArray(resolvedPath);
        if (generateMarkerOnError && projectOutputLocation != null && !(status = LoadpathEntry.validateLoadpath(this, resolvedPath, projectOutputLocation)).isOK()) {
            this.createLoadpathProblemMarker(status);
        }
        return resolvedPath;
    }

    public ISourceFolderRoot getFolderSourceFolderRoot(IPath path) {
        if (path.segmentCount() == 1) {
            return this.getSourceFolderRoot((IResource)this.project);
        }
        return this.getSourceFolderRoot((IResource)this.project.getWorkspace().getRoot().getFolder(path));
    }

    public ISourceFolderRoot getSourceFolderRoot(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return null;
            }
            case 2: {
                return new SourceFolderRoot(resource, this);
            }
            case 4: {
                return new SourceFolderRoot(resource, this);
            }
        }
        return null;
    }

    void createLoadpathProblemMarker(IRubyModelStatus status) {
        block11: {
            int severity;
            IMarker marker = null;
            String[] arguments = new String[]{};
            boolean isCycleProblem = false;
            boolean isClasspathFileFormatProblem = false;
            switch (status.getCode()) {
                case 1001: {
                    isCycleProblem = true;
                    if ("error".equals(this.getOption("org.rubypeople.rdt.core.circularClasspath", true))) {
                        severity = 2;
                        break;
                    }
                    severity = 1;
                    break;
                }
                case 1000: {
                    isClasspathFileFormatProblem = true;
                    severity = 2;
                    break;
                }
                case 1004: {
                    String setting = this.getOption("org.rubypeople.rdt.core.incompatibleJDKLevel", true);
                    if ("error".equals(setting)) {
                        severity = 2;
                        break;
                    }
                    if ("warning".equals(setting)) {
                        severity = 1;
                        break;
                    }
                    return;
                }
                default: {
                    IPath path = status.getPath();
                    if (path != null) {
                        arguments = new String[]{path.toString()};
                    }
                    severity = "error".equals(this.getOption("org.rubypeople.rdt.core.incompleteClasspath", true)) ? 2 : 1;
                }
            }
            try {
                marker = this.project.createMarker("org.rubypeople.rdt.core.buildpath_problem");
                marker.setAttributes(new String[]{"message", "severity", "location", "cycleDetected", "classpathFileFormat", "id", "arguments", "categoryId"}, new Object[]{status.getMessage(), new Integer(severity), Messages.classpath_buildPath, isCycleProblem ? "true" : "false", isClasspathFileFormatProblem ? "true" : "false", status.getCode(), Util.getProblemArgumentsForMarker(arguments), new Integer(10)});
            }
            catch (CoreException e) {
                if (!RubyModelManager.VERBOSE) break block11;
                e.printStackTrace();
            }
        }
    }

    protected void flushLoadpathProblemMarkers(boolean flushCycleMarkers, boolean flushClasspathFormatMarkers) {
        block7: {
            try {
                if (this.project.isAccessible()) {
                    IMarker[] markers = this.project.findMarkers("org.rubypeople.rdt.core.buildpath_problem", false, 0);
                    int i = 0;
                    int length = markers.length;
                    while (i < length) {
                        IMarker marker = markers[i];
                        if (flushCycleMarkers && flushClasspathFormatMarkers) {
                            marker.delete();
                        } else {
                            String cycleAttr = (String)marker.getAttribute("cycleDetected");
                            String classpathFileFormatAttr = (String)marker.getAttribute("classpathFileFormat");
                            if (flushCycleMarkers == (cycleAttr != null && cycleAttr.equals("true")) && flushClasspathFormatMarkers == (classpathFileFormatAttr != null && classpathFileFormatAttr.equals("true"))) {
                                marker.delete();
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                if (!RubyModelManager.VERBOSE) break block7;
                e.printStackTrace();
            }
        }
    }

    public static IPath canonicalizedPath(IPath externalPath) {
        Path result;
        if (externalPath == null) {
            return null;
        }
        if (IS_CASE_SENSITIVE) {
            return externalPath;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        Path canonicalPath = null;
        try {
            canonicalPath = new Path(new File(externalPath.toOSString()).getCanonicalPath());
        }
        catch (IOException iOException) {
            return externalPath;
        }
        int canonicalLength = canonicalPath.segmentCount();
        if (canonicalLength == 0) {
            return externalPath;
        }
        if (externalPath.isAbsolute()) {
            result = canonicalPath;
        } else {
            int externalLength = externalPath.segmentCount();
            if (canonicalLength >= externalLength) {
                result = canonicalPath.removeFirstSegments(canonicalLength - externalLength);
            } else {
                return externalPath;
            }
        }
        if (externalPath.getDevice() == null) {
            result = result.setDevice(null);
        }
        return result;
    }

    public ILoadpathEntry[] getRawLoadpath() throws RubyModelException {
        return this.getRawLoadpath(false, true);
    }

    public ISourceFolderRoot[] getSourceFolderRoots() throws RubyModelException {
        IRubyElement[] children = this.getChildren();
        int length = children.length;
        ISourceFolderRoot[] roots = new ISourceFolderRoot[length];
        System.arraycopy(children, 0, roots, 0, length);
        return roots;
    }

    public boolean isOnLoadpath(IRubyElement element) {
        ILoadpathEntry[] rawClasspath;
        try {
            rawClasspath = this.getRawLoadpath();
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
        int elementType = element.getElementType();
        boolean isPackageFragmentRoot = false;
        boolean isFolderPath = false;
        boolean isSource = false;
        switch (elementType) {
            case 0: {
                return false;
            }
            case 1: {
                break;
            }
            case 2: {
                isPackageFragmentRoot = true;
                break;
            }
            case 3: {
                isFolderPath = !((ISourceFolderRoot)element.getParent()).isArchive();
                break;
            }
            case 4: {
                isSource = true;
                break;
            }
            default: {
                isSource = element.getAncestor(4) != null;
            }
        }
        IPath elementPath = element.getPath();
        int length = rawClasspath.length;
        int i = 0;
        while (i < length) {
            ILoadpathEntry entry = rawClasspath[i];
            switch (entry.getEntryKind()) {
                case 1: 
                case 2: 
                case 3: {
                    if (!this.isOnLoadpathEntry(elementPath, isFolderPath, isPackageFragmentRoot, entry)) break;
                    return true;
                }
            }
            ++i;
        }
        if (isSource) {
            return false;
        }
        i = 0;
        while (i < length) {
            ILoadpathEntry rawEntry = rawClasspath[i];
            switch (rawEntry.getEntryKind()) {
                case 5: {
                    ILoadpathEntry[] containerEntries;
                    ILoadpathContainer container;
                    try {
                        container = RubyCore.getLoadpathContainer(rawEntry.getPath(), this);
                    }
                    catch (RubyModelException rubyModelException) {
                        break;
                    }
                    if (container == null || (containerEntries = container.getLoadpathEntries()) == null) break;
                    int j = 0;
                    int containerLength = containerEntries.length;
                    while (j < containerLength) {
                        ILoadpathEntry resolvedEntry = containerEntries[j];
                        if (this.isOnLoadpathEntry(elementPath, isFolderPath, isPackageFragmentRoot, resolvedEntry)) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
                case 4: {
                    ILoadpathEntry resolvedEntry = RubyCore.getResolvedLoadpathEntry(rawEntry);
                    if (resolvedEntry == null || !this.isOnLoadpathEntry(elementPath, isFolderPath, isPackageFragmentRoot, resolvedEntry)) break;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isOnLoadpathEntry(IPath elementPath, boolean isFolderPath, boolean isPackageFragmentRoot, ILoadpathEntry entry) {
        IPath entryPath = entry.getPath();
        return isPackageFragmentRoot ? entryPath.equals((Object)elementPath) : entryPath.isPrefixOf(elementPath) && !Util.isExcluded(elementPath, ((LoadpathEntry)entry).fullInclusionPatternChars(), ((LoadpathEntry)entry).fullExclusionPatternChars(), isFolderPath);
    }

    public ILoadpathEntry[] getResolvedLoadpath(boolean ignoreUnresolvedEntry) throws RubyModelException {
        return this.getResolvedLoadpath(ignoreUnresolvedEntry, false, true);
    }

    public ISourceFolderRoot[] computeSourceFolderRoots(ILoadpathEntry resolvedEntry) {
        try {
            return this.computeSourceFolderRoots(new ILoadpathEntry[]{resolvedEntry}, false, null);
        }
        catch (RubyModelException rubyModelException) {
            return new ISourceFolderRoot[0];
        }
    }

    public ILoadpathEntry[] getExpandedLoadpath(boolean ignoreUnresolvedVariable) throws RubyModelException {
        return this.getExpandedLoadpath(ignoreUnresolvedVariable, false, null, null);
    }

    private ILoadpathEntry[] getExpandedLoadpath(boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, Map preferredClasspaths, Map preferredOutputs) throws RubyModelException {
        ObjectVector accumulatedEntries = new ObjectVector();
        this.computeExpandedLoadpath(null, ignoreUnresolvedVariable, generateMarkerOnError, new HashSet(5), accumulatedEntries, preferredClasspaths, preferredOutputs);
        Object[] expandedPath = new ILoadpathEntry[accumulatedEntries.size()];
        accumulatedEntries.copyInto(expandedPath);
        return expandedPath;
    }

    private void computeExpandedLoadpath(LoadpathEntry referringEntry, boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, HashSet rootIDs, ObjectVector accumulatedEntries, Map preferredClasspaths, Map preferredOutputs) throws RubyModelException {
        String projectRootId = this.rootID();
        if (rootIDs.contains(projectRootId)) {
            return;
        }
        rootIDs.add(projectRootId);
        ILoadpathEntry[] preferredClasspath = preferredClasspaths != null ? (ILoadpathEntry[])preferredClasspaths.get(this) : null;
        IPath preferredOutput = preferredOutputs != null ? (IPath)preferredOutputs.get(this) : null;
        ILoadpathEntry[] immediateClasspath = preferredClasspath != null ? this.getResolvedLoadpath(preferredClasspath, preferredOutput, ignoreUnresolvedVariable, generateMarkerOnError, null) : this.getResolvedLoadpath(ignoreUnresolvedVariable, generateMarkerOnError, false);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        boolean isInitialProject = referringEntry == null;
        int i = 0;
        int length = immediateClasspath.length;
        while (i < length) {
            String rootID;
            LoadpathEntry entry = (LoadpathEntry)immediateClasspath[i];
            if ((isInitialProject || entry.isExported()) && !rootIDs.contains(rootID = entry.rootID())) {
                LoadpathEntry combinedEntry = entry.combineWith(referringEntry);
                accumulatedEntries.add(combinedEntry);
                if (entry.getEntryKind() == 2) {
                    IProject projRsc;
                    IResource member = workspaceRoot.findMember(entry.getPath());
                    if (member != null && member.getType() == 4 && RubyProject.hasRubyNature(projRsc = (IProject)member)) {
                        RubyProject javaProject = (RubyProject)RubyCore.create(projRsc);
                        javaProject.computeExpandedLoadpath(combinedEntry, ignoreUnresolvedVariable, false, rootIDs, accumulatedEntries, preferredClasspaths, preferredOutputs);
                    }
                } else {
                    rootIDs.add(rootID);
                }
            }
            ++i;
        }
    }

    public void updateSourceFolderRoots() {
        if (this.isOpen()) {
            try {
                RubyProjectElementInfo info = this.getRubyProjectElementInfo();
                this.computeChildren(info);
                info.resetCaches();
            }
            catch (RubyModelException rubyModelException) {
                try {
                    this.close();
                }
                catch (RubyModelException rubyModelException2) {}
            }
        }
    }

    protected RubyProjectElementInfo getRubyProjectElementInfo() throws RubyModelException {
        return (RubyProjectElementInfo)this.getElementInfo();
    }

    public void computeChildren(RubyProjectElementInfo info) throws RubyModelException {
        ILoadpathEntry[] classpath;
        block3: {
            ISourceFolderRoot[] newRoots;
            ISourceFolderRoot[] oldRoots;
            classpath = this.getResolvedLoadpath(true, false, false);
            RubyProjectElementInfo.ProjectCache projectCache = info.projectCache;
            if (projectCache != null && (oldRoots = projectCache.allPkgFragmentRootsCache).length == (newRoots = this.computeSourceFolderRoots(classpath, true, null)).length) {
                int i = 0;
                int length = oldRoots.length;
                while (i < length) {
                    if (oldRoots[i].equals(newRoots[i])) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return;
            }
        }
        info.setNonRubyResources(null);
        info.setChildren(this.computeSourceFolderRoots(classpath, false, null));
    }

    public ISourceFolderRoot[] getAllSourceFolderRoots(Map rootToResolvedEntries) throws RubyModelException {
        return this.computeSourceFolderRoots(this.getResolvedLoadpath(true, false, false), true, rootToResolvedEntries);
    }

    public boolean hasCycleMarker() {
        return this.getCycleMarker() != null;
    }

    public IMarker getCycleMarker() {
        try {
            if (this.project.isAccessible()) {
                IMarker[] markers = this.project.findMarkers("org.rubypeople.rdt.core.buildpath_problem", false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    String cycleAttr = (String)marker.getAttribute("cycleDetected");
                    if (cycleAttr != null && cycleAttr.equals("true")) {
                        return marker;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public boolean hasLoadpathCycle(ILoadpathEntry[] preferredClasspath) {
        HashSet cycleParticipants = new HashSet();
        HashMap<RubyProject, ILoadpathEntry[]> preferredClasspaths = new HashMap<RubyProject, ILoadpathEntry[]>(1);
        preferredClasspaths.put(this, preferredClasspath);
        this.updateCycleParticipants(new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2), preferredClasspaths);
        return !cycleParticipants.isEmpty();
    }

    public void updateCycleParticipants(ArrayList prereqChain, HashSet cycleParticipants, IWorkspaceRoot workspaceRoot, HashSet traversed, Map preferredClasspaths) {
        IPath path = this.getPath();
        prereqChain.add(path);
        traversed.add(path);
        try {
            ILoadpathEntry[] classpath = null;
            if (preferredClasspaths != null) {
                classpath = (ILoadpathEntry[])preferredClasspaths.get(this);
            }
            if (classpath == null) {
                classpath = this.getResolvedLoadpath(true, false, false);
            }
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                ILoadpathEntry entry = classpath[i];
                if (entry.getEntryKind() == 2) {
                    IResource member;
                    int index;
                    IPath prereqProjectPath = entry.getPath();
                    int n = index = cycleParticipants.contains(prereqProjectPath) ? 0 : prereqChain.indexOf(prereqProjectPath);
                    if (index >= 0) {
                        int size = prereqChain.size();
                        while (index < size) {
                            cycleParticipants.add(prereqChain.get(index));
                            ++index;
                        }
                    } else if (!traversed.contains(prereqProjectPath) && (member = workspaceRoot.findMember(prereqProjectPath)) != null && member.getType() == 4) {
                        RubyProject javaProject = (RubyProject)RubyCore.create((IProject)member);
                        javaProject.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredClasspaths);
                    }
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        prereqChain.remove(path);
    }

    /*
     * Unable to fully structure code
     */
    public static void updateAllCycleMarkers(Map preferredClasspaths) throws RubyModelException {
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        rscProjects = workspaceRoot.getProjects();
        length = rscProjects.length;
        projects = new RubyProject[length];
        cycleParticipants = new HashSet<E>();
        traversed = new HashSet<E>();
        prereqChain = new ArrayList<E>();
        i = 0;
        while (i < length) {
            if (RubyProject.hasRubyNature(rscProjects[i]) && !traversed.contains((project = (projects[i] = (RubyProject)RubyCore.create(rscProjects[i]))).getPath())) {
                prereqChain.clear();
                project.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredClasspaths);
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            project = projects[i];
            if (project != null) {
                if (cycleParticipants.contains(project.getPath())) {
                    cycleMarker = project.getCycleMarker();
                    circularCPOption = project.getOption("org.rubypeople.rdt.core.circularClasspath", true);
                    v0 = circularCPSeverity = "error".equals(circularCPOption) != false ? 2 : 1;
                    if (cycleMarker != null) {
                        try {
                            existingSeverity = (Integer)cycleMarker.getAttribute("severity");
                            if (existingSeverity == circularCPSeverity) ** GOTO lbl34
                            cycleMarker.setAttribute("severity", circularCPSeverity);
                        }
                        catch (CoreException e) {
                            throw new RubyModelException(e);
                        }
                    } else {
                        project.createLoadpathProblemMarker(new RubyModelStatus(1001, project));
                    }
                } else {
                    project.flushLoadpathProblemMarkers(true, false);
                }
            }
lbl34:
            // 6 sources

            ++i;
        }
    }

    public void setRawLoadpath(ILoadpathEntry[] newEntries, IPath newOutputLocation, IProgressMonitor monitor, boolean canChangeResource, ILoadpathEntry[] oldResolvedPath, boolean needValidation, boolean needSave) throws RubyModelException {
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        try {
            ILoadpathEntry[] newRawPath = newEntries;
            if (newRawPath == null) {
                newRawPath = this.defaultLoadpath();
            }
            SetLoadpathOperation op = new SetLoadpathOperation(this, oldResolvedPath, newRawPath, newOutputLocation, canChangeResource, needValidation, needSave);
            op.runOperation(monitor);
        }
        catch (RubyModelException e) {
            manager.getDeltaProcessor().flush();
            throw e;
        }
    }

    public boolean saveLoadpath(ILoadpathEntry[] newLoadpath, IPath newOutputLocation) throws RubyModelException {
        if (!this.project.isAccessible()) {
            return false;
        }
        HashMap unknownElements = new HashMap();
        ILoadpathEntry[] fileEntries = this.readLoadpathFile(false, false, unknownElements);
        if (fileEntries != null && this.isLoadpathEqualsTo(newLoadpath, newOutputLocation, fileEntries)) {
            return false;
        }
        try {
            this.setSharedProperty(LOADPATH_FILENAME, this.encodeLoadpath(newLoadpath, newOutputLocation, true, unknownElements));
            return true;
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    public void setSharedProperty(String key, String value) throws CoreException {
        IFile rscFile = this.project.getFile(key);
        byte[] bytes = null;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.log(e, "Could not write .loadpath with UTF-8 encoding ");
            bytes = value.getBytes();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        if (rscFile.exists()) {
            if (rscFile.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
            }
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
    }

    public boolean isLoadpathEqualsTo(ILoadpathEntry[] newClasspath, IPath newOutputLocation, ILoadpathEntry[] otherClasspathWithOutput) {
        if (otherClasspathWithOutput == null || otherClasspathWithOutput.length == 0) {
            return false;
        }
        int length = otherClasspathWithOutput.length;
        if (length != newClasspath.length + 1) {
            return false;
        }
        int i = 0;
        while (i < length - 1) {
            if (!otherClasspathWithOutput[i].equals(newClasspath[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String encodeLoadpath(ILoadpathEntry[] classpath, IPath outputLocation, boolean indent, Map unknownElements) throws RubyModelException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter(writer, this, true);
            xmlWriter.startTag("loadpath", indent);
            int i = 0;
            while (i < classpath.length) {
                ((LoadpathEntry)classpath[i]).elementEncode(xmlWriter, this.project.getFullPath(), indent, true, unknownElements);
                ++i;
            }
            xmlWriter.endTag("loadpath", indent, true);
            writer.flush();
            writer.close();
            return s.toString("UTF8");
        }
        catch (IOException e) {
            throw new RubyModelException(e, 985);
        }
    }

    public void setRawLoadpath(ILoadpathEntry[] entries, boolean canModifyResources, IProgressMonitor monitor) throws RubyModelException {
        this.setRawLoadpath(entries, SetLoadpathOperation.DO_NOT_SET_OUTPUT, monitor, canModifyResources, this.getResolvedLoadpath(true, false, false), true, canModifyResources);
    }

    public void setRawLoadpath(ILoadpathEntry[] entries, IProgressMonitor monitor) throws RubyModelException {
        this.setRawLoadpath(entries, SetLoadpathOperation.DO_NOT_SET_OUTPUT, monitor, true, this.getResolvedLoadpath(true, false, false), true, true);
    }

    public void setRawLoadpath(ILoadpathEntry[] entries, IPath outputLocation, IProgressMonitor monitor) throws RubyModelException {
        this.setRawLoadpath(entries, outputLocation, monitor, true, this.getResolvedLoadpath(true, false, false), true, true);
    }

    public ISourceFolderRoot getSourceFolderRoot(String string) {
        return this.getPackageFragmentRoot0(RubyProject.canonicalizedPath((IPath)new Path(string)));
    }

    private ISourceFolderRoot getPackageFragmentRoot0(IPath path) {
        return new ExternalSourceFolderRoot(path, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void forceLoadpathReload(IProgressMonitor monitor) throws RubyModelException {
        ILoadpathEntry[] fileEntries;
        boolean wasSuccessful;
        block16: {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            wasSuccessful = false;
            fileEntries = this.readLoadpathFile(false, false);
            if (fileEntries != null) break block16;
            if (wasSuccessful) return;
            try {
                this.getPerProjectInfo().updateLoadpathInformation(INVALID_LOADPATH);
                this.updateSourceFolderRoots();
                return;
            }
            catch (RubyModelException rubyModelException) {}
            return;
        }
        try {
            try {
                RubyModelManager.PerProjectInfo info = this.getPerProjectInfo();
                if (info.rawLoadpath != null && this.isLoadpathEqualsTo(info.rawLoadpath, info.outputLocation, fileEntries)) {
                    return;
                }
                ILoadpathEntry[] oldResolvedLoadpath = info.resolvedLoadpath;
                this.setRawLoadpath(fileEntries, SetLoadpathOperation.DO_NOT_SET_OUTPUT, monitor, !ResourcesPlugin.getWorkspace().isTreeLocked(), oldResolvedLoadpath != null ? oldResolvedLoadpath : this.getResolvedLoadpath(true, false, false), true, false);
                return;
            }
            catch (RuntimeException e) {
                if (!this.project.isAccessible()) throw e;
                Util.log(e, "Could not set loadpath for " + this.getPath());
                throw e;
            }
            catch (RubyModelException e) {
                if (ResourcesPlugin.getWorkspace().isTreeLocked()) throw e;
                if (!this.project.isAccessible()) throw e;
                if (e.getRubyModelStatus().getException() instanceof CoreException) {
                    this.createLoadpathProblemMarker(new RubyModelStatus(1000, Messages.bind(Messages.classpath_couldNotWriteClasspathFile, new String[]{this.getElementName(), e.getMessage()})));
                    throw e;
                } else {
                    this.createLoadpathProblemMarker(new RubyModelStatus(1000, Messages.bind(Messages.classpath_invalidClasspathInClasspathFile, new String[]{this.getElementName(), e.getMessage()})));
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (wasSuccessful) throw throwable;
            try {
                this.getPerProjectInfo().updateLoadpathInformation(INVALID_LOADPATH);
                this.updateSourceFolderRoots();
                throw throwable;
            }
            catch (RubyModelException rubyModelException) {}
            throw throwable;
        }
    }

    public void updateLoadpathMarkers(Map preferredClasspaths, Map preferredOutputs) {
        this.flushLoadpathProblemMarkers(false, true);
        this.flushLoadpathProblemMarkers(false, false);
        ILoadpathEntry[] classpath = this.readLoadpathFile(true, false);
        if (preferredClasspaths != null) {
            preferredClasspaths.put(this, classpath == null ? INVALID_LOADPATH : classpath);
        }
        if (preferredOutputs != null) {
            preferredOutputs.put(this, null);
        }
        if (classpath != null) {
            int i = 0;
            while (i < classpath.length) {
                IRubyModelStatus status = LoadpathEntry.validateLoadpathEntry(this, classpath[i], false, true);
                if (!(status.isOK() || status.getCode() == 964 && ((LoadpathEntry)classpath[i]).isOptional())) {
                    this.createLoadpathProblemMarker(status);
                }
                ++i;
            }
            IRubyModelStatus status = LoadpathEntry.validateLoadpath(this, classpath, null);
            if (!status.isOK()) {
                this.createLoadpathProblemMarker(status);
            }
        }
    }

    public ILoadpathEntry[] decodeLoadpath(String xmlClasspath, boolean createMarker, boolean logProblems) {
        return this.decodeLoadpath(xmlClasspath, createMarker, logProblems, null);
    }

    public ISourceFolderRoot findSourceFolderRoot(IPath path) throws RubyModelException {
        return this.findSourceFolderRoot0(RubyProject.canonicalizedPath(path));
    }

    public ISourceFolderRoot findSourceFolderRoot0(IPath path) throws RubyModelException {
        ISourceFolderRoot[] allRoots = this.getAllSourceFolderRoots();
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Messages.path_mustBeAbsolute);
        }
        int i = 0;
        while (i < allRoots.length) {
            ISourceFolderRoot classpathRoot = allRoots[i];
            if (classpathRoot.getPath().equals((Object)path)) {
                return classpathRoot;
            }
            ++i;
        }
        return null;
    }

    public ISourceFolderRoot[] findSourceFolderRoots(ILoadpathEntry entry) {
        try {
            ILoadpathEntry[] classpath = this.getRawLoadpath();
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                if (classpath[i].equals(entry)) {
                    return this.computeSourceFolderRoots(this.getResolvedLoadpath(new ILoadpathEntry[]{entry}, null, true, false, null), false, null);
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return new ISourceFolderRoot[0];
    }

    public ISourceFolderRoot[] getAllSourceFolderRoots() throws RubyModelException {
        return this.getAllSourceFolderRoots(null);
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '/': {
                Path path;
                String rootPath = "";
                token = null;
                while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    char firstChar = token.charAt(0);
                    if (firstChar == '<' || firstChar == '!') break;
                    rootPath = String.valueOf(rootPath) + token;
                }
                RubyElement root = (path = new Path(rootPath)).isAbsolute() ? (RubyElement)((Object)this.getPackageFragmentRoot0((IPath)path)) : (RubyElement)((Object)this.getSourceFolderRoot((IPath)path));
                if (token != null && token.charAt(0) == '<') {
                    return root.getHandleFromMemento(token, memento, owner);
                }
                return root.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '=';
    }

    public ITypeHierarchy newTypeHierarchy(IRegion region, IProgressMonitor monitor) throws RubyModelException {
        return this.newTypeHierarchy(region, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(IRegion region, WorkingCopyOwner owner, IProgressMonitor monitor) throws RubyModelException {
        if (region == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullRegion);
        }
        IRubyScript[] workingCopies = RubyModelManager.getRubyModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(region, workingCopies, null, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public boolean isOnLoadpath(IResource resource) {
        ILoadpathEntry[] classpath;
        IPath exactPath;
        IPath path = exactPath = resource.getFullPath();
        boolean isFolderPath = resource.getType() == 2;
        try {
            classpath = this.getResolvedLoadpath(true, false, false);
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            ILoadpathEntry entry = classpath[i];
            IPath entryPath = entry.getPath();
            if (entryPath.equals((Object)exactPath)) {
                return true;
            }
            if (entryPath.isPrefixOf(path) && !Util.isExcluded(path, ((LoadpathEntry)entry).fullInclusionPatternChars(), ((LoadpathEntry)entry).fullExclusionPatternChars(), isFolderPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

