/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.DeltaProcessor;
import org.rubypeople.rdt.internal.core.DocumentAdapter;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RubyModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected static final int APPEND = 1;
    protected static final int REMOVEALL_APPEND = 2;
    protected static final int KEEP_EXISTING = 3;
    protected static boolean POST_ACTION_VERBOSE;
    protected IPostAction[] actions;
    protected int actionsStart = 0;
    protected int actionsEnd = -1;
    protected HashMap<Object, Object> attributes;
    public static final String HAS_MODIFIED_RESOURCE_ATTR = "hasModifiedResource";
    public static final String TRUE = "true";
    protected IRubyElement[] elementsToProcess;
    protected IRubyElement[] parentElements;
    protected static IRubyElement[] NO_ELEMENTS;
    protected IRubyElement[] resultElements = NO_ELEMENTS;
    protected IProgressMonitor progressMonitor = null;
    protected boolean isNested = false;
    protected boolean force = false;
    protected static ThreadLocal<ArrayList<RubyModelOperation>> operationStacks;

    static {
        NO_ELEMENTS = new IRubyElement[0];
        operationStacks = new ThreadLocal();
    }

    protected RubyModelOperation() {
    }

    protected RubyModelOperation(IRubyElement[] elements) {
        this.elementsToProcess = elements;
    }

    protected RubyModelOperation(IRubyElement[] elementsToProcess, IRubyElement[] parentElements) {
        this.elementsToProcess = elementsToProcess;
        this.parentElements = parentElements;
    }

    protected RubyModelOperation(IRubyElement[] elementsToProcess, IRubyElement[] parentElements, boolean force) {
        this.elementsToProcess = elementsToProcess;
        this.parentElements = parentElements;
        this.force = force;
    }

    protected RubyModelOperation(IRubyElement[] elements, boolean force) {
        this.elementsToProcess = elements;
        this.force = force;
    }

    protected RubyModelOperation(IRubyElement element) {
        this.elementsToProcess = new IRubyElement[]{element};
    }

    protected RubyModelOperation(IRubyElement element, boolean force) {
        this.elementsToProcess = new IRubyElement[]{element};
        this.force = force;
    }

    protected void addAction(IPostAction action) {
        int length = this.actions.length;
        if (length == ++this.actionsEnd) {
            this.actions = new IPostAction[length * 2];
            System.arraycopy(this.actions, 0, this.actions, 0, length);
        }
        this.actions[this.actionsEnd] = action;
    }

    protected void addDelta(IRubyElementDelta delta) {
        RubyModelManager.getRubyModelManager().getDeltaProcessor().registerRubyModelDelta(delta);
    }

    protected void addReconcileDelta(IRubyScript workingCopy, IRubyElementDelta delta) {
        HashMap<IRubyScript, IRubyElementDelta> reconcileDeltas = RubyModelManager.getRubyModelManager().getDeltaProcessor().reconcileDeltas;
        RubyElementDelta previousDelta = (RubyElementDelta)reconcileDeltas.get(workingCopy);
        if (previousDelta != null) {
            IRubyElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                RubyElementDelta child = (RubyElementDelta)children[i];
                previousDelta.insertDeltaTree(child.getElement(), child);
                ++i;
            }
            if ((delta.getFlags() & 0x80000) != 0) {
                previousDelta.changedAST(delta.getRubyScriptAST());
            }
        } else {
            reconcileDeltas.put(workingCopy, delta);
        }
    }

    protected void removeReconcileDelta(IRubyScript workingCopy) {
        RubyModelManager.getRubyModelManager().getDeltaProcessor().reconcileDeltas.remove(workingCopy);
    }

    public void beginTask(String name, int totalWork) {
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask(name, totalWork);
        }
    }

    protected boolean canModifyRoots() {
        return false;
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException(Messages.operation_cancelled);
        }
    }

    protected IRubyModelStatus commonVerify() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return new RubyModelStatus(968);
        }
        int i = 0;
        while (i < this.elementsToProcess.length) {
            if (this.elementsToProcess[i] == null) {
                return new RubyModelStatus(968);
            }
            ++i;
        }
        return RubyModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] resources, IPath destinationPath) throws RubyModelException {
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.copy(resources, destinationPath, false, subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    protected void createFile(IContainer folder, String name, InputStream contents, boolean forceFlag) throws RubyModelException {
        IFile file = folder.getFile((IPath)new Path(name));
        try {
            file.create(contents, forceFlag ? 3 : 2, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    protected void createFolder(IContainer parentFolder, String name, boolean forceFlag) throws RubyModelException {
        IFolder folder = parentFolder.getFolder((IPath)new Path(name));
        try {
            folder.create(forceFlag ? 3 : 2, true, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    protected void deleteResource(IResource resource, int flags) throws RubyModelException {
        try {
            resource.delete(flags, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    protected void deleteResources(IResource[] resources, boolean forceFlag) throws RubyModelException {
        if (resources == null || resources.length == 0) {
            return;
        }
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.delete(resources, forceFlag ? 3 : 2, subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    public void done() {
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    protected boolean equalsOneOf(IPath path, IPath[] otherPaths) {
        int i = 0;
        int length = otherPaths.length;
        while (i < length) {
            if (path.equals((Object)otherPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void executeNestedOperation(RubyModelOperation operation, int subWorkAmount) throws RubyModelException {
        IRubyModelStatus status = operation.verify();
        if (!status.isOK()) {
            throw new RubyModelException(status);
        }
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(subWorkAmount);
        try {
            operation.setNested(true);
            operation.run(subProgressMonitor);
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof RubyModelException) {
                throw (RubyModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof RubyModelException) {
                throw (RubyModelException)((Object)e);
            }
            throw new RubyModelException(ce);
        }
    }

    protected abstract void executeOperation() throws RubyModelException;

    protected Object getAttribute(Object key) {
        ArrayList<RubyModelOperation> stack = this.getCurrentOperationStack();
        if (stack.size() == 0) {
            return null;
        }
        RubyModelOperation topLevelOp = stack.get(0);
        if (topLevelOp.attributes == null) {
            return null;
        }
        return topLevelOp.attributes.get(key);
    }

    protected IRubyScript getRubyScriptFor(IRubyElement element) {
        return ((RubyElement)element).getRubyScript();
    }

    protected ArrayList<RubyModelOperation> getCurrentOperationStack() {
        ArrayList<RubyModelOperation> stack = operationStacks.get();
        if (stack == null) {
            stack = new ArrayList();
            operationStacks.set(stack);
        }
        return stack;
    }

    protected IDocument getDocument(IRubyScript cu) throws RubyModelException {
        IBuffer buffer = cu.getBuffer();
        if (buffer instanceof IDocument) {
            return (IDocument)buffer;
        }
        return new DocumentAdapter(buffer);
    }

    protected IRubyElement[] getElementsToProcess() {
        return this.elementsToProcess;
    }

    protected IRubyElement getElementToProcess() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return null;
        }
        return this.elementsToProcess[0];
    }

    public IRubyModel getRubyModel() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return this.getParentElement().getRubyModel();
        }
        return this.elementsToProcess[0].getRubyModel();
    }

    protected IRubyElement getParentElement() {
        if (this.parentElements == null || this.parentElements.length == 0) {
            return null;
        }
        return this.parentElements[0];
    }

    protected IRubyElement[] getParentElements() {
        return this.parentElements;
    }

    public IRubyElement[] getResultElements() {
        return this.resultElements;
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProgressMonitor getSubProgressMonitor(int workAmount) {
        SubProgressMonitor sub = null;
        if (this.progressMonitor != null) {
            sub = new SubProgressMonitor(this.progressMonitor, workAmount, 4);
        }
        return sub;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && this.getAttribute(HAS_MODIFIED_RESOURCE_ATTR) == TRUE;
    }

    public void internalWorked(double work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isTopLevelOperation() {
        ArrayList<RubyModelOperation> stack = this.getCurrentOperationStack();
        return stack.size() > 0 && stack.get(0) == this;
    }

    protected int firstActionWithID(String id, int start) {
        int i = start;
        while (i <= this.actionsEnd) {
            if (this.actions[i].getID().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void moveResources(IResource[] resources, IPath destinationPath) throws RubyModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.progressMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.progressMonitor, resources.length, 4);
        }
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.move(resources, destinationPath, false, (IProgressMonitor)subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new RubyModelException(e);
        }
    }

    public RubyElementDelta newRubyElementDelta() {
        return new RubyElementDelta(this.getRubyModel());
    }

    protected RubyModelOperation popOperation() {
        ArrayList<RubyModelOperation> stack = this.getCurrentOperationStack();
        int size = stack.size();
        if (size > 0) {
            if (size == 1) {
                operationStacks.set(null);
            }
            return stack.remove(size - 1);
        }
        return null;
    }

    protected void postAction(IPostAction action, int insertionMode) {
        if (POST_ACTION_VERBOSE) {
            System.out.print("(" + Thread.currentThread() + ") [RubyModelOperation.postAction(IPostAction, int)] Posting action " + action.getID());
            switch (insertionMode) {
                case 2: {
                    System.out.println(" (REMOVEALL_APPEND)");
                    break;
                }
                case 3: {
                    System.out.println(" (KEEP_EXISTING)");
                    break;
                }
                case 1: {
                    System.out.println(" (APPEND)");
                }
            }
        }
        RubyModelOperation topLevelOp = this.getCurrentOperationStack().get(0);
        IPostAction[] postActions = topLevelOp.actions;
        if (postActions == null) {
            topLevelOp.actions = postActions = new IPostAction[1];
            postActions[0] = action;
            topLevelOp.actionsEnd = 0;
        } else {
            String id = action.getID();
            switch (insertionMode) {
                case 2: {
                    int index = this.actionsStart - 1;
                    while ((index = topLevelOp.firstActionWithID(id, index + 1)) >= 0) {
                        System.arraycopy(postActions, index + 1, postActions, index, topLevelOp.actionsEnd - index);
                        postActions[topLevelOp.actionsEnd--] = null;
                    }
                    topLevelOp.addAction(action);
                    break;
                }
                case 3: {
                    if (topLevelOp.firstActionWithID(id, 0) >= 0) break;
                    topLevelOp.addAction(action);
                    break;
                }
                case 1: {
                    topLevelOp.addAction(action);
                }
            }
        }
    }

    protected boolean prefixesOneOf(IPath path, IPath[] otherPaths) {
        int i = 0;
        int length = otherPaths.length;
        while (i < length) {
            if (path.isPrefixOf(otherPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void pushOperation(RubyModelOperation operation) {
        this.getCurrentOperationStack().add(operation);
    }

    protected void removeAllPostAction(String actionID) {
        if (POST_ACTION_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [RubyModelOperation.removeAllPostAction(String)] Removing actions " + actionID);
        }
        RubyModelOperation topLevelOp = this.getCurrentOperationStack().get(0);
        IPostAction[] postActions = topLevelOp.actions;
        if (postActions == null) {
            return;
        }
        int index = this.actionsStart - 1;
        while ((index = topLevelOp.firstActionWithID(actionID, index + 1)) >= 0) {
            System.arraycopy(postActions, index + 1, postActions, index, topLevelOp.actionsEnd - index);
            postActions[topLevelOp.actionsEnd--] = null;
        }
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        block17: {
            RubyModelManager manager = RubyModelManager.getRubyModelManager();
            DeltaProcessor deltaProcessor = manager.getDeltaProcessor();
            int previousDeltaCount = deltaProcessor.rubyModelDeltas.size();
            try {
                this.progressMonitor = monitor;
                this.pushOperation(this);
                try {
                    if (this.canModifyRoots()) {
                        RubyModelManager.getRubyModelManager().deltaState.initializeRoots();
                    }
                    this.executeOperation();
                }
                catch (Throwable throwable) {
                    if (this.isTopLevelOperation()) {
                        this.runPostActions();
                    }
                    throw throwable;
                }
                if (this.isTopLevelOperation()) {
                    this.runPostActions();
                }
            }
            finally {
                try {
                    deltaProcessor = manager.getDeltaProcessor();
                    int i = previousDeltaCount;
                    int size = deltaProcessor.rubyModelDeltas.size();
                    while (i < size) {
                        deltaProcessor.updateRubyModel(deltaProcessor.rubyModelDeltas.get(i));
                        ++i;
                    }
                    i = 0;
                    int length = this.resultElements.length;
                    while (i < length) {
                        IRubyElement element = this.resultElements[i];
                        Openable openable = (Openable)element.getOpenable();
                        if (!(openable instanceof RubyScript) || !((RubyScript)openable).isWorkingCopy()) {
                            ((RubyElement)openable.getParent()).close();
                        }
                        ++i;
                    }
                    if (!(!this.isTopLevelOperation() || deltaProcessor.rubyModelDeltas.size() <= previousDeltaCount && deltaProcessor.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                        deltaProcessor.fire(null, 0);
                    }
                    break block17;
                }
                finally {
                    this.popOperation();
                }
            }
            {
            }
        }
    }

    public void runOperation(IProgressMonitor monitor) throws RubyModelException {
        IRubyModelStatus status = this.verify();
        if (!status.isOK()) {
            throw new RubyModelException(status);
        }
        try {
            if (this.isReadOnly()) {
                this.run(monitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this, this.getSchedulingRule(), 1, monitor);
            }
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof RubyModelException) {
                throw (RubyModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof RubyModelException) {
                throw (RubyModelException)((Object)e);
            }
            throw new RubyModelException(ce);
        }
    }

    protected void runPostActions() throws RubyModelException {
        while (this.actionsStart <= this.actionsEnd) {
            IPostAction postAction = this.actions[this.actionsStart++];
            if (POST_ACTION_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [RubyModelOperation.runPostActions()] Running action " + postAction.getID());
            }
            postAction.run();
        }
    }

    protected void setAttribute(Object key, Object attribute) {
        RubyModelOperation topLevelOp = this.getCurrentOperationStack().get(0);
        if (topLevelOp.attributes == null) {
            topLevelOp.attributes = new HashMap();
        }
        topLevelOp.attributes.put(key, attribute);
    }

    public void setCanceled(boolean b) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setCanceled(b);
        }
    }

    protected void setNested(boolean nested) {
        this.isNested = nested;
    }

    public void setTaskName(String name) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTaskName(name);
        }
    }

    public void subTask(String name) {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(name);
        }
    }

    protected IRubyModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int work) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(work);
            this.checkCanceled();
        }
    }

    protected static interface IPostAction {
        public String getID();

        public void run() throws RubyModelException;
    }
}

