/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.core.ElementCache;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelInfo;

public class RubyModelCache {
    public static final int CACHE_RATIO = 20;
    protected RubyModelInfo modelInfo;
    protected HashMap projectCache;
    protected ElementCache folderCache;
    protected ElementCache rootCache;
    protected ElementCache openableCache;
    protected Map childrenCache;
    public static final int DEFAULT_PROJECT_SIZE = 5;
    public static final int DEFAULT_ROOT_SIZE = 50;
    public static final int DEFAULT_FOLDER_SIZE = 500;
    public static final int DEFAULT_OPENABLE_SIZE = 500;
    public static final int DEFAULT_CHILDREN_SIZE = 10000;
    protected double memoryRatio = -1.0;

    public RubyModelCache() {
        double ratio = this.getMemoryRatio();
        this.rootCache = new ElementCache((int)(50.0 * ratio));
        this.projectCache = new HashMap(5);
        this.openableCache = new ElementCache((int)(500.0 * ratio));
        this.folderCache = new ElementCache((int)(500.0 * ratio));
        this.childrenCache = new HashMap((int)(10000.0 * ratio));
    }

    protected double getMemoryRatio() {
        if (this.memoryRatio == -1.0) {
            long maxMemory = Runtime.getRuntime().maxMemory();
            this.memoryRatio = maxMemory == Long.MAX_VALUE ? 4.0 : (double)maxMemory / 6.7108864E7;
        }
        return this.memoryRatio;
    }

    public Object getInfo(IRubyElement element) {
        switch (element.getElementType()) {
            case 0: {
                return this.modelInfo;
            }
            case 1: {
                return this.projectCache.get(element);
            }
            case 2: {
                return this.rootCache.get(element);
            }
            case 3: {
                return this.folderCache.get(element);
            }
            case 4: {
                return this.openableCache.get(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected Object peekAtInfo(IRubyElement element) {
        switch (element.getElementType()) {
            case 0: {
                return this.modelInfo;
            }
            case 1: {
                return this.projectCache.get(element);
            }
            case 2: {
                return this.rootCache.peek(element);
            }
            case 3: {
                return this.folderCache.peek(element);
            }
            case 4: {
                return this.openableCache.peek(element);
            }
        }
        return this.childrenCache.get(element);
    }

    protected void putInfo(IRubyElement element, Object info) {
        switch (element.getElementType()) {
            case 0: {
                this.modelInfo = (RubyModelInfo)info;
                break;
            }
            case 1: {
                this.projectCache.put(element, info);
                this.rootCache.ensureSpaceLimit(((RubyElementInfo)info).children.length, element);
                break;
            }
            case 2: {
                this.rootCache.put(element, info);
                this.folderCache.ensureSpaceLimit(((RubyElementInfo)info).children.length, element);
                break;
            }
            case 3: {
                this.folderCache.put(element, info);
                this.openableCache.ensureSpaceLimit(((RubyElementInfo)info).children.length, element);
                break;
            }
            case 4: {
                this.openableCache.put(element, info);
                break;
            }
            default: {
                this.childrenCache.put(element, info);
            }
        }
    }

    protected void removeInfo(IRubyElement element) {
        switch (element.getElementType()) {
            case 0: {
                this.modelInfo = null;
                break;
            }
            case 1: {
                this.projectCache.remove(element);
                this.rootCache.resetSpaceLimit((int)(50.0 * this.getMemoryRatio()), element);
                break;
            }
            case 2: {
                this.rootCache.remove(element);
                this.folderCache.resetSpaceLimit((int)(500.0 * this.getMemoryRatio()), element);
                break;
            }
            case 3: {
                this.folderCache.remove(element);
                this.openableCache.resetSpaceLimit((int)(500.0 * this.getMemoryRatio()), element);
                break;
            }
            case 4: {
                this.openableCache.remove(element);
                break;
            }
            default: {
                this.childrenCache.remove(element);
            }
        }
    }

    public String toStringFillingRation(String prefix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append("Project cache: ");
        buffer.append(this.projectCache.size());
        buffer.append(" projects\n");
        buffer.append(prefix);
        buffer.append(this.rootCache.toStringFillingRation("Root cache"));
        buffer.append('\n');
        buffer.append(prefix);
        buffer.append(this.folderCache.toStringFillingRation("Folder cache"));
        buffer.append('\n');
        buffer.append(prefix);
        buffer.append("Openable cache: ");
        buffer.append(NumberFormat.getInstance().format(this.openableCache.fillingRatio()));
        buffer.append("%\n");
        return buffer.toString();
    }
}

