/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.NamedMember;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyMethodElementInfo;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyMethod
extends NamedMember
implements IMethod {
    private String[] parameterNames;

    public RubyMethod(RubyElement parent, String name, String[] parameterNames) {
        super(parent, name);
        this.parameterNames = parameterNames;
    }

    public int getElementType() {
        return 6;
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((RubyElement)this.getParent()).getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.parameterNames.length) {
            buff.append(delimiter);
            this.escapeMementoName(buff, this.parameterNames[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public IRubyElement getPrimaryElement(boolean checkOwner) {
        RubyScript cu;
        if (checkOwner && (cu = (RubyScript)this.getAncestor(4)).isPrimary()) {
            return this;
        }
        IRubyElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getMethod(this.name, this.parameterNames);
    }

    public boolean isConstructor() {
        return this.getElementName().equals("initialize");
    }

    public boolean equals(Object o) {
        if (!(o instanceof RubyMethod)) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        int length = this.parameterNames.length;
        while (i < length) {
            hash = Util.combineHashCodes(hash, this.parameterNames[i].hashCode());
            ++i;
        }
        return hash;
    }

    public IType getDeclaringType() {
        IRubyElement parent = this.getParent();
        if (parent instanceof IType) {
            return (IType)parent;
        }
        return null;
    }

    public int getVisibility() throws RubyModelException {
        if (this.isConstructor()) {
            return 1;
        }
        RubyMethodElementInfo info = (RubyMethodElementInfo)this.getElementInfo();
        return info.getVisibility();
    }

    public String[] getParameterNames() throws RubyModelException {
        return this.parameterNames;
    }

    public int getNumberOfParameters() throws RubyModelException {
        return this.getParameterNames().length;
    }

    public boolean isSingleton() {
        try {
            RubyMethodElementInfo info = (RubyMethodElementInfo)this.getElementInfo();
            return info.isSingleton();
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
            return this.isConstructor();
        }
    }

    public static RubyMethod singleton(RubyElement currentType, String name, String[] parameterNames2) {
        RubyMethod method = new RubyMethod(currentType, name, parameterNames2);
        try {
            RubyMethodElementInfo info = (RubyMethodElementInfo)method.getElementInfo();
            info.setIsSingleton(true);
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
        return method;
    }

    public boolean isPrivate() throws RubyModelException {
        return this.getVisibility() == 2;
    }

    public boolean isPublic() throws RubyModelException {
        return this.getVisibility() == 1;
    }

    public boolean isProtected() throws RubyModelException {
        return this.getVisibility() == 4;
    }

    public String[] getBlockParameters() throws RubyModelException {
        RubyMethodElementInfo info = (RubyMethodElementInfo)this.getElementInfo();
        return info.getBlockVars();
    }
}

