/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.core.RubyElement;

class RubyElementInfo {
    protected IRubyElement[] children = RubyElement.NO_ELEMENTS;
    protected boolean isStructureKnown = false;
    static Object[] NO_NON_RUBY_RESOURCES = new Object[0];

    protected RubyElementInfo() {
    }

    public void addChild(IRubyElement child) {
        if (this.children == RubyElement.NO_ELEMENTS) {
            this.setChildren(new IRubyElement[]{child});
        } else if (!this.includesChild(child)) {
            this.setChildren(this.growAndAddToArray(this.children, child));
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public IRubyElement[] getChildren() {
        return this.children;
    }

    protected IRubyElement[] growAndAddToArray(IRubyElement[] array, IRubyElement addition) {
        IRubyElement[] old = array;
        array = new IRubyElement[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected boolean includesChild(IRubyElement child) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i].equals(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isStructureKnown() {
        return this.isStructureKnown;
    }

    protected IRubyElement[] removeAndShrinkArray(IRubyElement[] array, IRubyElement deletion) {
        IRubyElement[] old = array;
        array = new IRubyElement[old.length - 1];
        int j = 0;
        int i = 0;
        while (i < old.length) {
            if (old[i].equals(deletion)) {
                System.arraycopy(old, i + 1, array, j, old.length - (i + 1));
                return array;
            }
            array[j] = old[i];
            ++j;
            ++i;
        }
        return array;
    }

    public void removeChild(IRubyElement child) {
        if (this.includesChild(child)) {
            this.setChildren(this.removeAndShrinkArray(this.children, child));
        }
    }

    public void setChildren(IRubyElement[] children) {
        this.children = children;
    }

    public void setIsStructureKnown(boolean newIsStructureKnown) {
        this.isStructureKnown = newIsStructureKnown;
    }
}

