/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IResourceDelta;
import org.jruby.ast.Node;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.SimpleDelta;

public class RubyElementDelta
extends SimpleDelta
implements IRubyElementDelta {
    protected IRubyElementDelta[] affectedChildren = EMPTY_DELTA;
    protected Node ast = null;
    protected IRubyElement changedElement;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected IRubyElement movedFromHandle = null;
    protected IRubyElement movedToHandle = null;
    protected static IRubyElementDelta[] EMPTY_DELTA = new IRubyElementDelta[0];

    public RubyElementDelta(IRubyElement element) {
        this.changedElement = element;
    }

    protected void addAffectedChild(RubyElementDelta child) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 8;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 8;
            }
        }
        if (this.changedElement.getElementType() >= 4) {
            this.fineGrained();
        }
        if (this.affectedChildren.length == 0) {
            this.affectedChildren = new IRubyElementDelta[]{child};
            return;
        }
        SimpleDelta existingChild = null;
        int existingChildIndex = -1;
        if (this.affectedChildren != null) {
            int i = 0;
            while (i < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[i].getElement(), child.getElement())) {
                    existingChild = (RubyElementDelta)this.affectedChildren[i];
                    existingChildIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (existingChild == null) {
            this.affectedChildren = this.growAndAddToArray(this.affectedChildren, child);
        } else {
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.kind = 4;
                            this.affectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.affectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 4: {
                            IResourceDelta[] resDeltas;
                            IRubyElementDelta[] children = child.getAffectedChildren();
                            int i = 0;
                            while (i < children.length) {
                                RubyElementDelta childsChild = (RubyElementDelta)children[i];
                                ((RubyElementDelta)existingChild).addAffectedChild(childsChild);
                                ++i;
                            }
                            boolean childHadContentFlag = (child.changeFlags & 1) != 0;
                            boolean existingChildHadChildrenFlag = (((RubyElementDelta)existingChild).changeFlags & 8) != 0;
                            ((RubyElementDelta)existingChild).changeFlags |= child.changeFlags;
                            if (childHadContentFlag && existingChildHadChildrenFlag) {
                                ((RubyElementDelta)existingChild).changeFlags &= 0xFFFFFFFE;
                            }
                            if ((resDeltas = child.getResourceDeltas()) != null) {
                                ((RubyElementDelta)existingChild).resourceDeltas = resDeltas;
                                ((RubyElementDelta)existingChild).resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.affectedChildren[existingChildIndex] = child;
                    child.changeFlags |= flags;
                }
            }
        }
    }

    public void added(IRubyElement element) {
        this.added(element, 0);
    }

    public void added(IRubyElement element, int flags) {
        RubyElementDelta addedDelta = new RubyElementDelta(element);
        addedDelta.added();
        addedDelta.changeFlags |= flags;
        this.insertDeltaTree(element, addedDelta);
    }

    protected void addResourceDelta(IResourceDelta child) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 1;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    public RubyElementDelta changed(IRubyElement element, int changeFlag) {
        RubyElementDelta changedDelta = new RubyElementDelta(element);
        changedDelta.changed(changeFlag);
        this.insertDeltaTree(element, changedDelta);
        return changedDelta;
    }

    public void changedAST(Node changedAST) {
        this.ast = changedAST;
        this.changed(524288);
    }

    public void contentChanged() {
        this.changeFlags |= 1;
    }

    public void closed(IRubyElement element) {
        RubyElementDelta delta = new RubyElementDelta(element);
        delta.changed(1024);
        this.insertDeltaTree(element, delta);
    }

    protected RubyElementDelta createDeltaTree(IRubyElement element, RubyElementDelta delta) {
        RubyElementDelta childDelta = delta;
        ArrayList ancestors = this.getAncestors(element);
        if (ancestors == null) {
            if (this.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.kind = delta.kind;
                this.changeFlags = delta.changeFlags;
                this.movedToHandle = delta.movedToHandle;
                this.movedFromHandle = delta.movedFromHandle;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                IRubyElement ancestor = (IRubyElement)ancestors.get(i);
                RubyElementDelta ancestorDelta = new RubyElementDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    protected boolean equalsAndSameParent(IRubyElement e1, IRubyElement e2) {
        IRubyElement parent1;
        return e1.equals(e2) && (parent1 = e1.getParent()) != null && parent1.equals(e2.getParent());
    }

    protected RubyElementDelta find(IRubyElement e) {
        if (this.equalsAndSameParent(this.changedElement, e)) {
            return this;
        }
        int i = 0;
        while (i < this.affectedChildren.length) {
            RubyElementDelta delta = ((RubyElementDelta)this.affectedChildren[i]).find(e);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public void fineGrained() {
        this.changed(16384);
    }

    public IRubyElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    public IRubyElementDelta[] getAffectedChildren() {
        return this.affectedChildren;
    }

    private ArrayList getAncestors(IRubyElement element) {
        IRubyElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<IRubyElement> parents = new ArrayList<IRubyElement>();
        while (!parent.equals(this.changedElement)) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    public Node getRubyScriptAST() {
        return this.ast;
    }

    public IRubyElementDelta[] getChangedChildren() {
        return this.getChildrenOfType(4);
    }

    protected IRubyElementDelta[] getChildrenOfType(int type) {
        int length = this.affectedChildren.length;
        if (length == 0) {
            return new IRubyElementDelta[0];
        }
        ArrayList<IRubyElementDelta> children = new ArrayList<IRubyElementDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.affectedChildren[i].getKind() == type) {
                children.add(this.affectedChildren[i]);
            }
            ++i;
        }
        IRubyElementDelta[] childrenOfType = new IRubyElementDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    protected RubyElementDelta getDeltaFor(IRubyElement element) {
        if (this.equalsAndSameParent(this.getElement(), element)) {
            return this;
        }
        if (this.affectedChildren.length == 0) {
            return null;
        }
        int childrenCount = this.affectedChildren.length;
        int i = 0;
        while (i < childrenCount) {
            RubyElementDelta delta = (RubyElementDelta)this.affectedChildren[i];
            if (this.equalsAndSameParent(delta.getElement(), element)) {
                return delta;
            }
            if ((delta = delta.getDeltaFor(element)) != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public IRubyElement getElement() {
        return this.changedElement;
    }

    public IRubyElement getMovedFromElement() {
        return this.movedFromHandle;
    }

    public IRubyElement getMovedToElement() {
        return this.movedToHandle;
    }

    public IRubyElementDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected IRubyElementDelta[] growAndAddToArray(IRubyElementDelta[] array, IRubyElementDelta addition) {
        IRubyElementDelta[] old = array;
        array = new IRubyElementDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected void insertDeltaTree(IRubyElement element, RubyElementDelta delta) {
        RubyElementDelta childDelta = this.createDeltaTree(element, delta);
        if (!this.equalsAndSameParent(element, this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    public void movedFrom(IRubyElement movedFromElement, IRubyElement movedToElement) {
        RubyElementDelta removedDelta = new RubyElementDelta(movedFromElement);
        removedDelta.kind = 2;
        removedDelta.changeFlags |= 0x20;
        removedDelta.movedToHandle = movedToElement;
        this.insertDeltaTree(movedFromElement, removedDelta);
    }

    public void movedTo(IRubyElement movedToElement, IRubyElement movedFromElement) {
        RubyElementDelta addedDelta = new RubyElementDelta(movedToElement);
        addedDelta.kind = 1;
        addedDelta.changeFlags |= 0x10;
        addedDelta.movedFromHandle = movedFromElement;
        this.insertDeltaTree(movedToElement, addedDelta);
    }

    public void opened(IRubyElement element) {
        RubyElementDelta delta = new RubyElementDelta(element);
        delta.changed(512);
        this.insertDeltaTree(element, delta);
    }

    protected void removeAffectedChild(RubyElementDelta child) {
        int index = -1;
        if (this.affectedChildren != null) {
            int i = 0;
            while (i < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[i].getElement(), child.getElement())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, index);
        }
    }

    protected IRubyElementDelta[] removeAndShrinkArray(IRubyElementDelta[] old, int index) {
        int rest;
        IRubyElementDelta[] array = new IRubyElementDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    public void removed(IRubyElement element) {
        this.removed(element, 0);
    }

    public void removed(IRubyElement element, int flags) {
        RubyElementDelta removedDelta = new RubyElementDelta(element);
        this.insertDeltaTree(element, removedDelta);
        RubyElementDelta actualDelta = this.getDeltaFor(element);
        if (actualDelta != null) {
            actualDelta.removed();
            actualDelta.changeFlags |= flags;
            actualDelta.affectedChildren = EMPTY_DELTA;
        }
    }

    public void sourceAttached(IRubyElement element) {
        RubyElementDelta attachedDelta = new RubyElementDelta(element);
        attachedDelta.changed(4096);
        this.insertDeltaTree(element, attachedDelta);
    }

    public void sourceDetached(IRubyElement element) {
        RubyElementDelta detachedDelta = new RubyElementDelta(element);
        detachedDelta.changed(8192);
        this.insertDeltaTree(element, detachedDelta);
    }

    public String toDebugString(int depth) {
        int i;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < depth) {
            buffer.append('\t');
            ++i2;
        }
        buffer.append(((RubyElement)this.getElement()).toDebugString());
        this.toDebugString(buffer);
        IRubyElementDelta[] children = this.getAffectedChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                buffer.append("\n");
                buffer.append(((RubyElementDelta)children[i]).toDebugString(depth + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.resourceDeltasCounter) {
            buffer.append("\n");
            int j = 0;
            while (j < depth + 1) {
                buffer.append('\t');
                ++j;
            }
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            buffer.append(resourceDelta.toString());
            buffer.append("[");
            switch (resourceDelta.getKind()) {
                case 1: {
                    buffer.append('+');
                    break;
                }
                case 2: {
                    buffer.append('-');
                    break;
                }
                case 4: {
                    buffer.append('*');
                    break;
                }
                default: {
                    buffer.append('?');
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    protected boolean toDebugString(StringBuffer buffer, int flags) {
        boolean prev = super.toDebugString(buffer, flags);
        if ((flags & 8) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CHILDREN");
            prev = true;
        }
        if ((flags & 1) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((flags & 0x10) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_FROM(" + ((RubyElement)this.getMovedFromElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x20) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_TO(" + ((RubyElement)this.getMovedToElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((flags & 0x40) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ADDED TO CLASSPATH");
            prev = true;
        }
        if ((flags & 0x80) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REMOVED FROM CLASSPATH");
            prev = true;
        }
        if ((flags & 0x100) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REORDERED");
            prev = true;
        }
        if ((flags & 0x8000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ARCHIVE CONTENT CHANGED");
            prev = true;
        }
        if ((flags & 0x1000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SOURCE ATTACHED");
            prev = true;
        }
        if ((flags & 0x2000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SOURCE DETACHED");
            prev = true;
        }
        if ((flags & 0x4000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("FINE GRAINED");
            prev = true;
        }
        if ((flags & 0x10000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("PRIMARY WORKING COPY");
            prev = true;
        }
        if ((flags & 0x20000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CLASSPATH CHANGED");
            prev = true;
        }
        if ((flags & 0x40000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("PRIMARY RESOURCE");
            prev = true;
        }
        if ((flags & 0x200) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("OPENED");
            prev = true;
        }
        if ((flags & 0x400) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CLOSED");
            prev = true;
        }
        if ((flags & 0x80000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("AST AFFECTED");
            prev = true;
        }
        if ((flags & 0x100000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CATEGORIES");
            prev = true;
        }
        return prev;
    }

    public String toString() {
        return this.toDebugString(0);
    }
}

