/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.jruby.ast.Node;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.Assert;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.SourceRefElement;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;
import org.rubypeople.rdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RubyElement
extends PlatformObject
implements IRubyElement {
    public static final char JEM_ESCAPE = '\\';
    public static final char JEM_RUBYPROJECT = '=';
    public static final char JEM_SOURCEFOLDERROOT = '/';
    public static final char JEM_SOURCE_FOLDER = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_RUBYSCRIPT = '{';
    public static final char JEM_TYPE = '[';
    public static final char JEM_IMPORTDECLARATION = '#';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    public static final IRubyElement[] NO_ELEMENTS = new IRubyElement[0];
    protected static final Object NO_INFO = new Object();
    protected RubyElement parent;

    public RubyElement(RubyElement parent) {
        this.parent = parent;
    }

    @Override
    public String getElementName() {
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        RubyElement other = (RubyElement)o;
        return this.getElementName().equals(other.getElementName()) && this.parent.equals(other.parent);
    }

    @Override
    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
    }

    @Override
    public abstract int getElementType();

    void setParent(RubyElement parent) {
        this.parent = parent;
    }

    @Override
    public IRubyElement getParent() {
        return this.parent;
    }

    @Override
    public IRubyElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IRubyElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    protected IRubyElement getSourceElementAt(int position) throws RubyModelException {
        if (this instanceof ISourceReference) {
            IRubyElement[] children = this.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                IRubyElement aChild = children[i];
                if (aChild instanceof SourceRefElement) {
                    SourceRefElement child = (SourceRefElement)children[i];
                    ISourceRange range = child.getSourceRange();
                    int start = range.getOffset();
                    int end = start + range.getLength();
                    if (start <= position && position <= end) {
                        if (child instanceof IField) {
                            int declarationStart = start;
                            SourceRefElement candidate = null;
                            do {
                                if (position > (range = ((IField)((Object)child)).getNameRange()).getOffset() + range.getLength()) {
                                    return candidate == null ? child.getSourceElementAt(position) : candidate.getSourceElementAt(position);
                                }
                                candidate = child;
                                SourceRefElement sourceRefElement = child = --i >= 0 ? (SourceRefElement)children[i] : null;
                            } while (child != null && child.getSourceRange().getOffset() == declarationStart);
                            return candidate.getSourceElementAt(position);
                        }
                        if (child instanceof IParent) {
                            return child.getSourceElementAt(position);
                        }
                        return child;
                    }
                }
                --i;
            }
        } else {
            Assert.isTrue(false);
        }
        return this;
    }

    @Override
    public IRubyElement getAncestor(int ancestorType) {
        IRubyElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public IRubyElement[] getChildren() throws RubyModelException {
        Object elementInfo = this.getElementInfo();
        if (elementInfo instanceof RubyElementInfo) {
            return ((RubyElementInfo)elementInfo).getChildren();
        }
        return NO_ELEMENTS;
    }

    public ArrayList<IRubyElement> getChildrenOfType(int type) throws RubyModelException {
        IRubyElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<IRubyElement> list = new ArrayList<IRubyElement>(size);
        int i = 0;
        while (i < size) {
            RubyElement elt = (RubyElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public boolean hasChildren() throws RubyModelException {
        Object elementInfo = RubyModelManager.getRubyModelManager().getInfo(this);
        if (elementInfo instanceof RubyElementInfo) {
            return ((RubyElementInfo)elementInfo).getChildren().length > 0;
        }
        return true;
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getElementName().hashCode(), this.parent.hashCode());
    }

    @Override
    public boolean isType(int type) {
        return type == this.getElementType();
    }

    public IRubyScript getRubyScript() {
        return null;
    }

    @Override
    public IRubyProject getRubyProject() {
        IRubyElement current = this;
        do {
            if (!(current instanceof IRubyProject)) continue;
            return (IRubyProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public IRubyModel getRubyModel() {
        IRubyElement current = this;
        do {
            if (!(current instanceof IRubyModel)) continue;
            return (IRubyModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public void close() throws RubyModelException {
        RubyModelManager.getRubyModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws RubyModelException;

    public boolean isAncestorOf(IRubyElement e) {
        IRubyElement parentElement = e.getParent();
        while (parentElement != null && !parentElement.equals(this)) {
            parentElement = parentElement.getParent();
        }
        return parentElement != null;
    }

    protected Object openWhenClosed(Object info, IProgressMonitor monitor) throws RubyModelException {
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        boolean hadTemporaryCache = manager.hasTemporaryCache();
        try {
            HashMap newElements = manager.getTemporaryCache();
            this.generateInfos(info, newElements, monitor);
            if (info == null) {
                info = newElements.get(this);
            }
            if (info == null) {
                Openable openable = (Openable)this.getOpenable();
                if (newElements.containsKey(openable)) {
                    openable.closeBuffer();
                }
                throw this.newNotPresentException();
            }
            if (!hadTemporaryCache) {
                manager.putInfos(this, newElements);
            }
        }
        finally {
            if (!hadTemporaryCache) {
                manager.resetTemporaryCache();
            }
        }
        return info;
    }

    public RubyModelException newNotPresentException() {
        return new RubyModelException(new RubyModelStatus(969, this));
    }

    public RubyModelException newRubyModelException(IStatus status) {
        if (status instanceof IRubyModelStatus) {
            return new RubyModelException((IRubyModelStatus)status);
        }
        return new RubyModelException(new RubyModelStatus(status.getSeverity(), status.getCode(), status.getMessage()));
    }

    protected abstract void generateInfos(Object var1, HashMap var2, IProgressMonitor var3) throws RubyModelException;

    @Override
    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    public String readableName() {
        return this.getElementName();
    }

    public Object getElementInfo() throws RubyModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws RubyModelException {
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), monitor);
    }

    protected abstract Object createElementInfo();

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors(boolean showResolvedInfo) {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, showResolvedInfo);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public String toStringWithAncestors() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        RubyElement parentElement = (RubyElement)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof RubyElementInfo)) {
            return;
        }
        IRubyElement[] children = ((RubyElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((RubyElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = RubyModelManager.getRubyModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getElementName());
    }

    public Node findNode(Node cuAST) {
        return null;
    }

    public abstract IRubyElement getHandleFromMemento(String var1, MementoTokenizer var2, WorkingCopyOwner var3);

    public IRubyElement getHandleFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    @Override
    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer();
        this.getHandleMemento(buff);
        return buff.toString();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((RubyElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    protected abstract char getHandleMementoDelimiter();

    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
        int i = 0;
        int length = mementoName.length();
        while (i < length) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '!': 
                case '#': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '~': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
            ++i;
        }
    }

    public IRubyElement unresolved() {
        return this;
    }
}

