/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.CompilationParticipant;
import org.rubypeople.rdt.core.compiler.ReconcileContext;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyElementDeltaBuilder;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.RubyScriptProblemFinder;
import org.rubypeople.rdt.internal.core.parser.MarkerUtility;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class ReconcileWorkingCopyOperation
extends RubyModelOperation {
    public static boolean PERF = false;
    boolean createAST;
    boolean forceProblemDetection;
    WorkingCopyOwner workingCopyOwner;
    public RootNode ast;
    public RubyElementDeltaBuilder deltaBuilder;
    public HashMap problems;

    public ReconcileWorkingCopyOperation(IRubyElement workingCopy, boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner) {
        super(new IRubyElement[]{workingCopy});
        this.forceProblemDetection = forceProblemDetection;
        this.workingCopyOwner = workingCopyOwner;
    }

    protected void executeOperation() throws RubyModelException {
        if (this.progressMonitor != null) {
            if (this.progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.progressMonitor.beginTask(Messages.element_reconciling, 2);
        }
        RubyScript workingCopy = this.getWorkingCopy();
        boolean wasConsistent = workingCopy.isConsistent();
        RubyModelManager.PerWorkingCopyInfo problemRequestor = workingCopy.getPerWorkingCopyInfo();
        this.deltaBuilder = new RubyElementDeltaBuilder(workingCopy);
        this.makeConsistent(workingCopy, problemRequestor);
        this.notifyParticipants(workingCopy);
        if (this.problems != null && (this.forceProblemDetection || !wasConsistent)) {
            try {
                problemRequestor.beginReporting();
                block6: for (CategorizedProblem[] categorizedProblems : this.problems.values()) {
                    if (categorizedProblems == null) continue;
                    int i = 0;
                    int length = categorizedProblems.length;
                    while (i < length) {
                        CategorizedProblem problem = categorizedProblems[i];
                        if (RubyModelManager.VERBOSE) {
                            System.out.println("PROBLEM FOUND while reconciling : " + problem.getMessage());
                        }
                        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) continue block6;
                        if (!MarkerUtility.ignoring(workingCopy.getResource(), problem.getID(), problem.getSourceStart(), problem.getSourceEnd())) {
                            problemRequestor.acceptProblem(problem);
                        }
                        ++i;
                    }
                }
            }
            finally {
                problemRequestor.endReporting();
            }
        }
        try {
            RubyElementDelta delta = this.deltaBuilder.delta;
            if (delta != null) {
                this.addReconcileDelta(workingCopy, delta);
            }
        }
        finally {
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }
    }

    public RootNode makeConsistent(RubyScript workingCopy, IProblemRequestor problemRequestor) throws RubyModelException {
        if (!workingCopy.isConsistent()) {
            if (this.problems == null) {
                this.problems = new HashMap();
            }
            this.ast = workingCopy.makeConsistent(true, this.problems, this.progressMonitor);
            this.deltaBuilder.buildDeltas();
            if (this.ast != null && this.deltaBuilder.delta != null) {
                this.deltaBuilder.delta.changedAST((Node)this.ast);
            }
            return this.ast;
        }
        if (this.ast != null) {
            return this.ast;
        }
        if (this.forceProblemDetection) {
            if (RubyProject.hasRubyNature(workingCopy.getRubyProject().getProject())) {
                HashMap problemMap;
                if (this.problems == null) {
                    problemMap = new HashMap();
                    if (this.forceProblemDetection) {
                        this.problems = problemMap;
                    }
                } else {
                    problemMap = this.problems;
                }
                char[] contents = workingCopy.getContents();
                this.ast = RubyScriptProblemFinder.process(workingCopy, contents, problemMap, this.progressMonitor);
                if (this.ast != null) {
                    this.deltaBuilder.delta = new RubyElementDelta(workingCopy);
                    this.deltaBuilder.delta.changedAST((Node)this.ast);
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(1);
                }
            }
            return this.ast;
        }
        return null;
    }

    protected RubyScript getWorkingCopy() {
        return (RubyScript)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected IRubyModelStatus verify() {
        IRubyModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        RubyScript workingCopy = this.getWorkingCopy();
        if (!workingCopy.isWorkingCopy()) {
            return new RubyModelStatus(969, workingCopy);
        }
        return status;
    }

    private void notifyParticipants(RubyScript workingCopy) {
        IRubyProject rubyProject = this.getWorkingCopy().getRubyProject();
        CompilationParticipant[] participants = RubyModelManager.getRubyModelManager().compilationParticipants.getCompilationParticipants(rubyProject);
        if (participants == null) {
            return;
        }
        final ReconcileContext context = new ReconcileContext(this, workingCopy);
        int i = 0;
        int length = participants.length;
        while (i < length) {
            final CompilationParticipant participant = participants[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    if (exception instanceof Error) {
                        throw (Error)exception;
                    }
                    if (exception instanceof OperationCanceledException) {
                        throw (OperationCanceledException)exception;
                    }
                    if (exception instanceof UnsupportedOperationException) {
                        Util.log(exception, "Reconcile participant attempted to modify the buffer of the working copy being reconciled");
                    } else {
                        Util.log(exception, "Exception occurred in reconcile participant");
                    }
                }

                public void run() throws Exception {
                    participant.reconcile(context);
                }
            });
            ++i;
        }
    }
}

