/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.MemberElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyType;
import org.rubypeople.rdt.internal.core.SourceRange;
import org.rubypeople.rdt.internal.core.SourceRefElement;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;

public abstract class Member
extends SourceRefElement
implements IMember {
    protected Member(RubyElement parent) {
        super(parent);
    }

    protected static boolean areSimilarMethods(String name1, String[] params1, String name2, String[] params2, String[] simpleNames1) {
        int params1Length;
        return name1.equals(name2) && (params1Length = params1.length) == params2.length;
    }

    public IType getDeclaringType() {
        RubyElement parentElement = (RubyElement)this.getParent();
        if (parentElement.getElementType() == 5) {
            return (IType)((Object)parentElement);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Member getOuterMostLocalContext() {
        Member member = this;
        Member lastLocalContext = null;
        while (true) {
            void var1_2;
            switch (var1_2.getElementType()) {
                case 4: {
                    return lastLocalContext;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 10: 
                case 11: {
                    lastLocalContext = (Member)var1_2;
                }
            }
            IRubyElement iRubyElement = var1_2.getParent();
        }
    }

    public ISourceRange getNameRange() throws RubyModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return new SourceRange(info.getNameSourceStart(), info.getNameSourceEnd() - info.getNameSourceStart() + 1);
    }

    public IType getType(String typeName, int count) {
        RubyType type = new RubyType(this, typeName);
        type.occurrenceCount = count;
        return type;
    }

    public String readableName() {
        IType declaringType = this.getDeclaringType();
        if (declaringType != null) {
            String declaringName = ((RubyElement)((Object)this.getDeclaringType())).readableName();
            StringBuffer buffer = new StringBuffer(declaringName);
            buffer.append("::");
            buffer.append(this.getElementName());
            return buffer.toString();
        }
        return super.readableName();
    }

    protected void updateNameRange(int nameStart, int nameEnd) {
        try {
            MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
            info.setNameSourceStart(nameStart);
            info.setNameSourceEnd(nameEnd);
        }
        catch (RubyModelException rubyModelException) {
            return;
        }
    }

    public IRubyElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                RubyElement type = (RubyElement)((Object)this.getType(typeName, 1));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '[';
    }
}

