/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.buffer.LRUCache;
import org.rubypeople.rdt.internal.core.buffer.OverflowingLRUCache;

public class ElementCache
extends OverflowingLRUCache {
    IRubyElement spaceLimitParent = null;

    public ElementCache(int size) {
        super(size);
    }

    public ElementCache(int size, int overflow) {
        super(size, overflow);
    }

    protected void ensureSpaceLimit(int childrenSize, IRubyElement parent) {
        int spaceNeeded = 1 + (int)((1.0 + this.fLoadFactor) * (double)(childrenSize + this.fOverflow));
        if (this.fSpaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    protected void resetSpaceLimit(int defaultLimit, IRubyElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }

    protected boolean close(LRUCache.LRUCacheEntry entry) {
        Openable element;
        block3: {
            element = (Openable)entry._fKey;
            try {
                if (element.canBeRemovedFromCache()) break block3;
                return false;
            }
            catch (RubyModelException rubyModelException) {
                return false;
            }
        }
        element.close();
        return true;
    }

    protected LRUCache newInstance(int size, int overflow) {
        return new ElementCache(size, overflow);
    }
}

