/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.DeltaProcessingState;
import org.rubypeople.rdt.internal.core.ExternalSourceFolderRoot;
import org.rubypeople.rdt.internal.core.ModelUpdater;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyProjectElementInfo;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.SourceElementParser;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderInfo;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.SourceFolderRootInfo;
import org.rubypeople.rdt.internal.core.builder.RubyBuilder;
import org.rubypeople.rdt.internal.core.hierarchy.TypeHierarchy;
import org.rubypeople.rdt.internal.core.search.AbstractSearchScope;
import org.rubypeople.rdt.internal.core.search.RubyWorkspaceScope;
import org.rubypeople.rdt.internal.core.search.indexing.IndexManager;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaProcessor {
    private static final String EXTERNAL_JAR_ADDED = "external jar added";
    private static final String EXTERNAL_JAR_CHANGED = "external jar changed";
    private static final String EXTERNAL_JAR_REMOVED = "external jar removed";
    private static final String EXTERNAL_JAR_UNCHANGED = "external jar unchanged";
    private static final String INTERNAL_JAR_IGNORE = "internal jar ignore";
    public static final int DEFAULT_CHANGE_EVENT = 0;
    private static final int NON_RUBY_RESOURCE = -1;
    public static boolean DEBUG;
    public static boolean VERBOSE;
    public static boolean PERF;
    private final ModelUpdater modelUpdater = new ModelUpdater();
    private HashSet<IRubyProject> projectCachesToReset = new HashSet();
    public Map<IRubyProject, ISourceFolderRoot[]> removedRoots;
    private HashSet<IRubyElement> refreshedElements;
    private DeltaProcessingState state;
    private RubyModelManager manager;
    private boolean isFiring = true;
    public ArrayList<IRubyElementDelta> rubyModelDeltas = new ArrayList();
    public HashMap<IRubyScript, IRubyElementDelta> reconcileDeltas = new HashMap();
    private Openable currentElement;
    private HashSet<IRubyProject> rootsToRefresh = new HashSet();
    private RubyElementDelta currentDelta;
    public int overridenEventType = -1;
    private SourceElementParser sourceElementParserCache;

    static {
        VERBOSE = false;
        PERF = false;
    }

    public DeltaProcessor(DeltaProcessingState state, RubyModelManager manager) {
        this.state = state;
        this.manager = manager;
    }

    public void registerRubyModelDelta(IRubyElementDelta delta) {
        this.rubyModelDeltas.add(delta);
    }

    public void updateRubyModel(IRubyElementDelta customDelta) {
        if (customDelta == null) {
            int i = 0;
            int length = this.rubyModelDeltas.size();
            while (i < length) {
                IRubyElementDelta delta = this.rubyModelDeltas.get(i);
                this.modelUpdater.processRubyDelta(delta);
                ++i;
            }
        } else {
            this.modelUpdater.processRubyDelta(customDelta);
        }
    }

    public void fire(IRubyElementDelta customDelta, int eventType) {
        IRubyElementDelta deltaToNotify;
        if (!this.isFiring) {
            return;
        }
        if (DEBUG) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        if ((deltaToNotify = customDelta == null ? this.mergeDeltas(this.rubyModelDeltas) : customDelta) != null) {
            for (AbstractSearchScope scope : this.manager.searchScopes.keySet()) {
                scope.processDelta(deltaToNotify, eventType);
            }
            RubyWorkspaceScope workspaceScope = this.manager.workspaceScope;
            if (workspaceScope != null) {
                workspaceScope.processDelta(deltaToNotify, eventType);
            }
        }
        IElementChangedListener[] listeners = this.state.elementChangedListeners;
        int[] listenerMask = this.state.elementChangedListenerMasks;
        int listenerCount = this.state.elementChangedListenerCount;
        switch (eventType) {
            case 0: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                break;
            }
            case 1: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
            }
        }
    }

    private IRubyElementDelta mergeDeltas(Collection deltas) {
        if (deltas.size() == 0) {
            return null;
        }
        if (deltas.size() == 1) {
            return (IRubyElementDelta)deltas.iterator().next();
        }
        if (VERBOSE) {
            System.out.println("MERGING " + deltas.size() + " DELTAS [" + Thread.currentThread() + "]");
        }
        Iterator iterator = deltas.iterator();
        RubyElementDelta rootDelta = new RubyElementDelta(this.manager.rubyModel);
        boolean insertedTree = false;
        while (iterator.hasNext()) {
            IRubyElement element;
            RubyElementDelta delta = (RubyElementDelta)iterator.next();
            if (VERBOSE) {
                System.out.println(delta.toString());
            }
            if (this.manager.rubyModel.equals(element = delta.getElement())) {
                IRubyElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    RubyElementDelta projectDelta = (RubyElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                if (resourceDeltas == null) continue;
                int i = 0;
                int length = resourceDeltas.length;
                while (i < length) {
                    rootDelta.addResourceDelta(resourceDeltas[i]);
                    insertedTree = true;
                    ++i;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            return rootDelta;
        }
        return null;
    }

    private void firePostChangeDelta(IRubyElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DEBUG) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 1, listeners, listenerMask, listenerCount);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        IRubyElementDelta deltaToNotify = this.mergeDeltas(this.reconcileDeltas.values());
        if (DEBUG) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(deltaToNotify, 4, listeners, listenerMask, listenerCount);
        }
    }

    public void flush() {
        this.rubyModelDeltas = new ArrayList();
    }

    private void notifyListeners(IRubyElementDelta deltaToNotify, int eventType, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        final ElementChangedEvent extraEvent = new ElementChangedEvent(deltaToNotify, eventType);
        int i = 0;
        while (i < listenerCount) {
            if ((listenerMask[i] & eventType) != 0) {
                final IElementChangedListener listener = listeners[i];
                long start = -1L;
                if (VERBOSE) {
                    System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                    start = System.currentTimeMillis();
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of Java element change notification");
                    }

                    public void run() throws Exception {
                        PerformanceStats stats = null;
                        if (PERF) {
                            stats = PerformanceStats.getStats((String)"org.rubypeople.rdt.core/perf/rubydeltalistener", (Object)listener);
                            stats.startRun();
                        }
                        listener.elementChanged(extraEvent);
                        if (PERF) {
                            stats.endRun();
                        }
                    }
                });
                if (VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resourceChanged(IResourceChangeEvent event) {
        if (!(event.getSource() instanceof IWorkspace)) return;
        int eventType = this.overridenEventType == -1 ? event.getType() : this.overridenEventType;
        IResource resource = event.getResource();
        IResourceDelta delta = event.getDelta();
        switch (eventType) {
            case 4: {
                try {
                    if (resource.getType() != 4 || !((IProject)resource).hasNature("org.rubypeople.rdt.core.rubynature")) return;
                    this.deleting((IProject)resource);
                    return;
                }
                catch (CoreException coreException) {}
                return;
            }
            case 1: {
                if (!this.isAffectedBy(delta)) return;
                try {
                    int listenerCount;
                    IElementChangedListener[] listeners;
                    try {
                        IRubyElementDelta translatedDelta;
                        this.stopDeltas();
                        this.checkProjectsBeingAddedOrRemoved(delta);
                        if (this.refreshedElements != null) {
                            this.createExternalArchiveDelta(null);
                        }
                        if ((translatedDelta = this.processResourceDelta(delta)) != null) {
                            this.registerRubyModelDelta(translatedDelta);
                        }
                    }
                    finally {
                        this.startDeltas();
                    }
                    DeltaProcessingState deltaProcessingState = this.state;
                    synchronized (deltaProcessingState) {
                        listeners = this.state.elementChangedListeners;
                        listenerCount = this.state.elementChangedListenerCount;
                    }
                    this.notifyTypeHierarchies(listeners, listenerCount);
                    this.fire(null, 1);
                    return;
                }
                finally {
                    this.state.resetOldRubyProjectNames();
                    this.removedRoots = null;
                }
            }
            case 8: {
                DeltaProcessingState.ProjectUpdateInfo[] updates = this.state.removeAllProjectUpdates();
                if (updates != null) {
                    int i = 0;
                    int length = updates.length;
                    while (i < length) {
                        try {
                            updates[i].updateProjectReferencesIfNecessary();
                        }
                        catch (RubyModelException rubyModelException) {}
                        ++i;
                    }
                }
                if (!this.isAffectedBy(delta)) return;
                this.updateLoadpathMarkers(delta, updates);
                RubyBuilder.buildStarting();
                return;
            }
            case 16: {
                RubyBuilder.buildFinished();
                return;
            }
        }
    }

    private void notifyTypeHierarchies(IElementChangedListener[] listeners, int listenerCount) {
        int i = 0;
        while (i < listenerCount) {
            final IElementChangedListener listener = listeners[i];
            if (listener instanceof TypeHierarchy) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of Ruby element change notification");
                    }

                    public void run() throws Exception {
                        TypeHierarchy typeHierarchy = (TypeHierarchy)listener;
                        if (typeHierarchy.hasFineGrainChanges()) {
                            typeHierarchy.needsRefresh = true;
                            typeHierarchy.fireChange();
                        }
                    }
                });
            }
            ++i;
        }
    }

    private void updateLoadpathMarkers(IResourceDelta delta, DeltaProcessingState.ProjectUpdateInfo[] updates) {
        HashMap<RubyProject, ILoadpathEntry[]> preferredClasspaths = new HashMap<RubyProject, ILoadpathEntry[]>(5);
        HashMap preferredOutputs = new HashMap(5);
        HashSet<IPath> affectedProjects = new HashSet<IPath>(5);
        RubyModel.flushExternalFileCache();
        this.updateLoadpathMarkers(delta, affectedProjects, preferredClasspaths, preferredOutputs);
        if (!affectedProjects.isEmpty()) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            int length = projects.length;
            int i = 0;
            while (i < length) {
                IProject project = projects[i];
                RubyProject rubyProject = (RubyProject)RubyCore.create(project);
                if (preferredClasspaths.get(rubyProject) == null) {
                    try {
                        IPath projectPath = project.getFullPath();
                        ILoadpathEntry[] classpath = rubyProject.getResolvedLoadpath(true, false, false);
                        int j = 0;
                        int cpLength = classpath.length;
                        while (j < cpLength) {
                            ILoadpathEntry entry = classpath[j];
                            switch (entry.getEntryKind()) {
                                case 2: {
                                    if (!affectedProjects.contains(entry.getPath())) break;
                                    rubyProject.updateLoadpathMarkers(null, null);
                                    break;
                                }
                                case 1: {
                                    IPath entryPath = entry.getPath();
                                    IPath libProjectPath = entryPath.removeLastSegments(entryPath.segmentCount() - 1);
                                    if (libProjectPath.equals((Object)projectPath) || !affectedProjects.contains(libProjectPath)) break;
                                    rubyProject.updateLoadpathMarkers(null, null);
                                }
                            }
                            ++j;
                        }
                    }
                    catch (RubyModelException rubyModelException) {}
                }
                ++i;
            }
        }
        if (!affectedProjects.isEmpty() || updates != null) {
            if (updates != null) {
                int i = 0;
                int length = updates.length;
                while (i < length) {
                    DeltaProcessingState.ProjectUpdateInfo info = updates[i];
                    if (!preferredClasspaths.containsKey(info.project)) {
                        preferredClasspaths.put(info.project, info.newResolvedPath);
                    }
                    ++i;
                }
            }
            try {
                RubyProject.updateAllCycleMarkers(preferredClasspaths);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    private void updateLoadpathMarkers(IResourceDelta delta, HashSet<IPath> affectedProjects, Map preferredClasspaths, Map preferredOutputs) {
        IResource resource = delta.getResource();
        boolean processChildren = false;
        switch (resource.getType()) {
            case 8: {
                if (delta.getKind() != 4) break;
                processChildren = true;
                break;
            }
            case 4: {
                IProject project = (IProject)resource;
                int kind = delta.getKind();
                boolean isRubyProject = RubyProject.hasRubyNature(project);
                switch (kind) {
                    case 1: {
                        processChildren = isRubyProject;
                        affectedProjects.add(project.getFullPath());
                        break;
                    }
                    case 4: {
                        processChildren = isRubyProject;
                        if ((delta.getFlags() & 0x4000) != 0) {
                            affectedProjects.add(project.getFullPath());
                            if (!isRubyProject) break;
                            RubyProject rubyProject = (RubyProject)RubyCore.create(project);
                            rubyProject.updateLoadpathMarkers(preferredClasspaths, preferredOutputs);
                            break;
                        }
                        if ((delta.getFlags() & 0x80000) != 0) {
                            boolean wasRubyProject;
                            boolean bl = wasRubyProject = this.state.findRubyProject(project.getName()) != null;
                            if (!wasRubyProject || isRubyProject) break;
                            affectedProjects.add(project.getFullPath());
                            RubyProject javaProject = (RubyProject)RubyCore.create(project);
                            javaProject.flushLoadpathProblemMarkers(true, true);
                            RubyBuilder.removeProblemsAndTasksFor((IResource)project);
                            break;
                        }
                        if (!isRubyProject) break;
                        try {
                            RubyProject javaProject = (RubyProject)RubyCore.create(project);
                            javaProject.getResolvedLoadpath(true, true, false);
                        }
                        catch (RubyModelException rubyModelException) {}
                        break;
                    }
                    case 2: {
                        affectedProjects.add(project.getFullPath());
                    }
                }
                break;
            }
            case 1: {
                IFile file = (IFile)resource;
                if (!file.getName().equals(".loadpath")) break;
                affectedProjects.add(file.getProject().getFullPath());
                RubyProject rubyProject = (RubyProject)RubyCore.create(file.getProject());
                rubyProject.updateLoadpathMarkers(preferredClasspaths, preferredOutputs);
            }
        }
        if (processChildren) {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.updateLoadpathMarkers(children[i], affectedProjects, preferredClasspaths, preferredOutputs);
                ++i;
            }
        }
    }

    private IRubyElementDelta processResourceDelta(IResourceDelta changes) {
        try {
            RubyModel model = this.manager.getRubyModel();
            if (!model.isOpen()) {
                try {
                    model.open(null);
                }
                catch (RubyModelException e) {
                    if (VERBOSE) {
                        e.printStackTrace();
                    }
                    this.currentDelta = null;
                    this.rootsToRefresh.clear();
                    this.projectCachesToReset.clear();
                    return null;
                }
            }
            this.state.initializeRoots();
            this.currentElement = null;
            IResourceDelta[] deltas = changes.getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IResourceDelta delta = deltas[i];
                IResource res = delta.getResource();
                RootInfo rootInfo = null;
                IProject proj = (IProject)res;
                boolean wasRubyProject = this.state.findRubyProject(proj.getName()) != null;
                boolean isRubyProject = RubyProject.hasRubyNature(proj);
                int elementType = !wasRubyProject && !isRubyProject ? -1 : ((rootInfo = this.enclosingRootInfo(res.getFullPath(), delta.getKind())) != null && rootInfo.isRootOfProject(res.getFullPath()) ? 2 : 1);
                this.traverseDelta(delta, elementType, rootInfo);
                if (elementType == -1 || wasRubyProject != isRubyProject && delta.getKind() == 4) {
                    try {
                        this.nonRubyResourcesChanged(model, delta);
                    }
                    catch (RubyModelException rubyModelException) {}
                }
                ++i;
            }
            this.resetProjectCaches();
            RubyElementDelta rubyElementDelta = this.currentDelta;
            return rubyElementDelta;
        }
        finally {
            this.currentDelta = null;
            this.rootsToRefresh.clear();
            this.projectCachesToReset.clear();
        }
    }

    private RootInfo enclosingRootInfo(IPath path, int kind) {
        while (path != null && path.segmentCount() > 0) {
            RootInfo rootInfo = this.rootInfo(path, kind);
            if (rootInfo != null) {
                return rootInfo;
            }
            path = path.removeLastSegments(1);
        }
        return null;
    }

    private RootInfo rootInfo(IPath path, int kind) {
        if (kind == 2) {
            return (RootInfo)this.state.oldRoots.get(path);
        }
        return (RootInfo)this.state.roots.get(path);
    }

    private void refreshSourceFolderRoots() {
        for (RubyProject rubyProject : this.rootsToRefresh) {
            rubyProject.updateSourceFolderRoots();
        }
    }

    private RubyElementDelta currentDelta() {
        if (this.currentDelta == null) {
            this.currentDelta = new RubyElementDelta(this.manager.getRubyModel());
        }
        return this.currentDelta;
    }

    private void resetProjectCaches() {
        Iterator<IRubyProject> iterator = this.projectCachesToReset.iterator();
        HashMap projectDepencies = this.state.projectDependencies;
        HashSet<IRubyProject> affectedDependents = new HashSet<IRubyProject>();
        while (iterator.hasNext()) {
            RubyProject rubyProject = (RubyProject)iterator.next();
            rubyProject.resetCaches();
            this.addDependentProjects(rubyProject, projectDepencies, affectedDependents);
        }
        for (RubyProject rubyProject : affectedDependents) {
            rubyProject.resetCaches();
        }
    }

    private void addDependentProjects(IRubyProject project, HashMap projectDependencies, HashSet<IRubyProject> result) {
        IRubyProject[] dependents = (IRubyProject[])projectDependencies.get(project);
        if (dependents == null) {
            return;
        }
        int i = 0;
        int length = dependents.length;
        while (i < length) {
            IRubyProject dependent = dependents[i];
            if (!result.contains(dependent)) {
                result.add(dependent);
                this.addDependentProjects(dependent, projectDependencies, result);
            }
            ++i;
        }
    }

    private void nonRubyResourcesChanged(Openable element, IResourceDelta delta) throws RubyModelException {
        RubyElementDelta current;
        RubyElementDelta elementDelta;
        if (element.isOpen()) {
            RubyElementInfo info = (RubyElementInfo)element.getElementInfo();
            switch (element.getElementType()) {
                case 0: {
                    ((RubyModelInfo)info).nonRubyResources = null;
                    this.currentDelta().addResourceDelta(delta);
                    return;
                }
                case 1: {
                    ((RubyProjectElementInfo)info).setNonRubyResources(null);
                    RubyProject project = (RubyProject)element;
                    SourceFolderRoot projectRoot = (SourceFolderRoot)project.getSourceFolderRoot((IResource)project.getProject());
                    if (!projectRoot.isOpen()) break;
                    ((SourceFolderRootInfo)projectRoot.getElementInfo()).setNonRubyResources(null);
                    break;
                }
                case 3: {
                    ((SourceFolderInfo)info).setNonRubyResources(null);
                    break;
                }
                case 2: {
                    ((SourceFolderRootInfo)info).setNonRubyResources(null);
                }
            }
        }
        if ((elementDelta = (current = this.currentDelta()).find(element)) == null) {
            elementDelta = current.changed(element, 1);
        }
        elementDelta.addResourceDelta(delta);
    }

    private void stopDeltas() {
        this.isFiring = false;
    }

    private void startDeltas() {
        this.isFiring = true;
    }

    private void deleting(IProject project) {
        try {
            RubyProject rubyProject = (RubyProject)RubyCore.create(project);
            if (this.removedRoots == null) {
                this.removedRoots = new HashMap<IRubyProject, ISourceFolderRoot[]>();
            }
            if (rubyProject.isOpen()) {
                this.removedRoots.put(rubyProject, rubyProject.getSourceFolderRoots());
            } else {
                this.removedRoots.put(rubyProject, rubyProject.computeSourceFolderRoots(rubyProject.getResolvedLoadpath(true, false, false), false, null));
            }
            rubyProject.close();
            this.state.getOldRubyProjecNames();
            this.removeFromParentInfo(rubyProject);
            this.manager.resetProjectPreferences(rubyProject);
        }
        catch (RubyModelException rubyModelException) {}
    }

    private void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                RubyElementInfo info = (RubyElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    private boolean isAffectedBy(IResourceDelta rootDelta) {
        if (rootDelta != null) {
            class FoundRelevantDeltaException
            extends RuntimeException {
                private static final long serialVersionUID = 7137113252936111022L;

                FoundRelevantDeltaException() {
                }
            }
            try {
                rootDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        switch (delta.getKind()) {
                            case 1: 
                            case 2: {
                                throw new FoundRelevantDeltaException();
                            }
                            case 4: {
                                if (delta.getAffectedChildren().length != 0 || (delta.getFlags() & 0xFFFCFFFF) == 0) break;
                                throw new FoundRelevantDeltaException();
                            }
                        }
                        return true;
                    }
                });
            }
            catch (FoundRelevantDeltaException foundRelevantDeltaException) {
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private void checkProjectsBeingAddedOrRemoved(IResourceDelta delta) {
        IResource resource = delta.getResource();
        boolean processChildren = false;
        switch (resource.getType()) {
            case 8: {
                this.state.getOldRubyProjecNames();
                processChildren = true;
                break;
            }
            case 4: {
                IProject project = (IProject)resource;
                RubyProject rubyProject = (RubyProject)RubyCore.create(project);
                switch (delta.getKind()) {
                    case 1: {
                        this.manager.batchContainerInitializations = true;
                        this.addToRootsToRefreshWithDependents(rubyProject);
                        if (RubyProject.hasRubyNature(project)) {
                            this.addToParentInfo(rubyProject);
                            try {
                                this.state.updateProjectReferences(rubyProject, null, null, null, false);
                            }
                            catch (RubyModelException rubyModelException) {}
                        }
                        this.state.rootsAreStale = true;
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x4000) != 0) {
                            this.manager.batchContainerInitializations = true;
                            this.addToRootsToRefreshWithDependents(rubyProject);
                            if (project.isOpen()) {
                                if (RubyProject.hasRubyNature(project)) {
                                    this.addToParentInfo(rubyProject);
                                }
                            } else {
                                try {
                                    rubyProject.close();
                                }
                                catch (RubyModelException rubyModelException) {}
                                this.removeFromParentInfo(rubyProject);
                                this.manager.removePerProjectInfo(rubyProject);
                                this.manager.containerRemove(rubyProject);
                            }
                            this.state.rootsAreStale = true;
                            break;
                        }
                        if ((delta.getFlags() & 0x80000) != 0) {
                            boolean isJavaProject;
                            boolean wasJavaProject = this.state.findRubyProject(project.getName()) != null;
                            if (wasJavaProject != (isJavaProject = RubyProject.hasRubyNature(project))) {
                                this.manager.batchContainerInitializations = true;
                                this.addToRootsToRefreshWithDependents(rubyProject);
                                if (isJavaProject) {
                                    this.addToParentInfo(rubyProject);
                                } else {
                                    this.manager.removePerProjectInfo((RubyProject)RubyCore.create(project));
                                    this.manager.containerRemove(rubyProject);
                                    try {
                                        rubyProject.close();
                                    }
                                    catch (RubyModelException rubyModelException) {}
                                    this.removeFromParentInfo(rubyProject);
                                }
                                this.state.rootsAreStale = true;
                                break;
                            }
                            if (!isJavaProject) break;
                            this.addToParentInfo(rubyProject);
                            processChildren = true;
                            break;
                        }
                        if (!RubyProject.hasRubyNature(project)) break;
                        this.addToParentInfo(rubyProject);
                        processChildren = true;
                        break;
                    }
                    case 2: {
                        this.manager.batchContainerInitializations = true;
                        this.manager.removePerProjectInfo(rubyProject);
                        this.manager.containerRemove(rubyProject);
                        this.state.rootsAreStale = true;
                    }
                }
                this.addForRefresh(rubyProject);
                break;
            }
            case 1: {
                IFile file = (IFile)resource;
                if (!file.getName().equals(".loadpath")) break;
                this.manager.batchContainerInitializations = true;
                this.reconcileLoadpathFileUpdate(delta, (RubyProject)RubyCore.create(file.getProject()));
                this.state.rootsAreStale = true;
            }
        }
        if (processChildren) {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.checkProjectsBeingAddedOrRemoved(children[i]);
                ++i;
            }
        }
    }

    private void addToRootsToRefreshWithDependents(IRubyProject rubyProject) {
        this.rootsToRefresh.add(rubyProject);
        this.addDependentProjects(rubyProject, this.state.projectDependencies, this.rootsToRefresh);
    }

    public void addForRefresh(IRubyElement element) {
        if (this.refreshedElements == null) {
            this.refreshedElements = new HashSet();
        }
        this.refreshedElements.add(element);
    }

    private void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                RubyElementInfo info = (RubyElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    private void traverseDelta(IResourceDelta delta, int elementType, RootInfo rootInfo) {
        block15: {
            IProject rscProject;
            RubyProject adoptiveProject;
            IResource res = delta.getResource();
            if (this.currentElement == null && rootInfo != null) {
                this.currentElement = rootInfo.project;
            }
            boolean processChildren = true;
            processChildren = res instanceof IProject ? this.updateCurrentDeltaAndIndex(delta, elementType == 2 ? 1 : elementType, rootInfo) : (rootInfo != null ? this.updateCurrentDeltaAndIndex(delta, elementType, rootInfo) : true);
            if (!processChildren) break block15;
            IResourceDelta[] children = delta.getAffectedChildren();
            boolean oneChildOnLoadpath = false;
            int length = children.length;
            IResourceDelta[] orphanChildren = null;
            Openable parent = null;
            boolean isValidParent = true;
            int i = 0;
            while (i < length) {
                block19: {
                    ArrayList rootList;
                    boolean isNestedRoot;
                    RootInfo childRootInfo2;
                    int childKind;
                    IPath childPath;
                    IResourceDelta child;
                    block21: {
                        block16: {
                            block17: {
                                block18: {
                                    block20: {
                                        child = children[i];
                                        IResource childRes = child.getResource();
                                        childPath = childRes.getFullPath();
                                        childRootInfo2 = this.rootInfo(childPath, childKind = child.getKind());
                                        if (childRootInfo2 != null && !childRootInfo2.isRootOfProject(childPath)) {
                                            childRootInfo2 = null;
                                        }
                                        int childType = this.elementType(childRes, childKind, elementType, rootInfo == null ? childRootInfo2 : rootInfo);
                                        boolean isResFilteredFromOutput = false;
                                        boolean bl = isNestedRoot = rootInfo != null && childRootInfo2 != null;
                                        if (isResFilteredFromOutput || isNestedRoot) break block16;
                                        this.traverseDelta(child, childType, rootInfo == null ? childRootInfo2 : rootInfo);
                                        if (childType != -1) break block17;
                                        if (rootInfo == null) break block18;
                                        if (!isValidParent) break block19;
                                        if (parent != null) break block20;
                                        if (this.currentElement == null || !rootInfo.project.equals(this.currentElement.getRubyProject())) {
                                            this.currentElement = rootInfo.project;
                                        }
                                        if ((parent = elementType == 1 || elementType == 2 && res instanceof IProject ? rootInfo.project : this.createElement(res, elementType, rootInfo)) != null) break block20;
                                        isValidParent = false;
                                        break block19;
                                    }
                                    try {
                                        this.nonRubyResourcesChanged(parent, child);
                                    }
                                    catch (RubyModelException rubyModelException) {}
                                    break block21;
                                }
                                if (orphanChildren == null) {
                                    orphanChildren = new IResourceDelta[length];
                                }
                                orphanChildren[i] = child;
                                break block21;
                            }
                            oneChildOnLoadpath = true;
                            break block21;
                        }
                        oneChildOnLoadpath = true;
                    }
                    if (isNestedRoot || childRootInfo2 == null && (childRootInfo2 = this.rootInfo(childPath, childKind)) != null) {
                        this.traverseDelta(child, 2, childRootInfo2);
                    }
                    if ((rootList = this.otherRootsInfo(childPath, childKind)) != null) {
                        for (RootInfo childRootInfo2 : rootList) {
                            this.traverseDelta(child, 2, childRootInfo2);
                        }
                    }
                }
                ++i;
            }
            if (orphanChildren != null && (oneChildOnLoadpath || res instanceof IProject) && (adoptiveProject = (RubyProject)RubyCore.create(rscProject = res.getProject())) != null && RubyProject.hasRubyNature(rscProject)) {
                int i2 = 0;
                while (i2 < length) {
                    if (orphanChildren[i2] != null) {
                        try {
                            this.nonRubyResourcesChanged(adoptiveProject, orphanChildren[i2]);
                        }
                        catch (RubyModelException rubyModelException) {}
                    }
                    ++i2;
                }
            }
        }
    }

    private ArrayList otherRootsInfo(IPath path, int kind) {
        if (kind == 2) {
            return (ArrayList)this.state.oldOtherRoots.get(path);
        }
        return (ArrayList)this.state.otherRoots.get(path);
    }

    private void close(Openable element) {
        try {
            element.close();
        }
        catch (RubyModelException rubyModelException) {}
    }

    private Openable createElement(IResource resource, int elementType, RootInfo rootInfo) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getFullPath();
        IRubyElement element = null;
        switch (elementType) {
            case 1: {
                if (!(resource instanceof IProject)) break;
                this.popUntilPrefixOf(path);
                if (this.currentElement != null && this.currentElement.getElementType() == 1 && ((IRubyProject)((Object)this.currentElement)).getProject().equals((Object)resource)) {
                    return this.currentElement;
                }
                if (rootInfo != null && rootInfo.project.getProject().equals((Object)resource)) {
                    element = rootInfo.project;
                    break;
                }
                IProject proj = (IProject)resource;
                if (RubyProject.hasRubyNature(proj)) {
                    element = RubyCore.create(proj);
                    break;
                }
                element = this.manager.getRubyModel().findRubyProject(proj);
                break;
            }
            case 2: {
                element = rootInfo == null ? RubyCore.create(resource) : rootInfo.getSourceFolderRoot(resource);
                break;
            }
            case 3: {
                if (rootInfo != null) {
                    if (!rootInfo.project.contains(resource)) break;
                    SourceFolderRoot root = (SourceFolderRoot)rootInfo.getSourceFolderRoot(null);
                    IPath pkgPath = path.removeFirstSegments(rootInfo.rootPath.segmentCount());
                    String[] pkgName = pkgPath.segments();
                    element = root.getSourceFolder(pkgName);
                    break;
                }
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = RubyCore.create(resource);
                    break;
                }
                SourceFolderRoot root = this.currentElement.getSourceFolderRoot();
                if (root == null) {
                    element = RubyCore.create(resource);
                    break;
                }
                if (!((RubyProject)root.getRubyProject()).contains(resource)) break;
                IPath pkgPath = path.removeFirstSegments(root.getPath().segmentCount());
                String[] pkgName = pkgPath.segments();
                element = root.getSourceFolder(pkgName);
                break;
            }
            case 4: {
                this.popUntilPrefixOf(path);
                element = RubyCore.create(resource);
            }
        }
        if (element == null) {
            return null;
        }
        this.currentElement = (Openable)element;
        return this.currentElement;
    }

    private void popUntilPrefixOf(IPath path) {
        while (this.currentElement != null) {
            IPath currentElementPath = null;
            IResource currentElementResource = this.currentElement.getResource();
            if (currentElementResource != null) {
                currentElementPath = currentElementResource.getFullPath();
            }
            if (currentElementPath != null && currentElementPath.isPrefixOf(path)) {
                return;
            }
            this.currentElement = (Openable)this.currentElement.getParent();
        }
    }

    private void elementAdded(Openable element, IResourceDelta delta, RootInfo rootInfo) {
        int elementType = element.getElementType();
        if (elementType == 1) {
            if (delta != null && RubyProject.hasRubyNature((IProject)delta.getResource())) {
                this.addToParentInfo(element);
                if ((delta.getFlags() & 0x1000) != 0) {
                    Openable movedFromElement = (Openable)((Object)element.getRubyModel().getRubyProject(delta.getMovedFromPath().lastSegment()));
                    this.currentDelta().movedTo(element, movedFromElement);
                } else {
                    this.currentDelta().added(element);
                }
                this.state.updateRoots(element.getPath(), delta, this);
                this.rootsToRefresh.add((IRubyProject)((Object)element));
                this.projectCachesToReset.add((IRubyProject)((Object)element));
            }
        } else {
            if (delta == null || (delta.getFlags() & 0x1000) == 0) {
                if (this.isPrimaryWorkingCopy(element, elementType)) {
                    this.currentDelta().changed(element, 262144);
                } else {
                    this.addToParentInfo(element);
                    this.close(element);
                    this.currentDelta().added(element);
                }
            } else {
                Openable movedFromElement;
                this.addToParentInfo(element);
                this.close(element);
                IPath movedFromPath = delta.getMovedFromPath();
                IResource res = delta.getResource();
                Object movedFromRes = res instanceof IFile ? res.getWorkspace().getRoot().getFile(movedFromPath) : res.getWorkspace().getRoot().getFolder(movedFromPath);
                RootInfo movedFromInfo = this.enclosingRootInfo(movedFromPath, 2);
                int movedFromType = this.elementType((IResource)movedFromRes, 2, element.getParent().getElementType(), movedFromInfo);
                this.currentElement = null;
                Openable openable = movedFromElement = elementType != 1 && movedFromType == 1 ? null : this.createElement((IResource)movedFromRes, movedFromType, rootInfo);
                if (movedFromElement == null) {
                    this.currentDelta().added(element);
                } else {
                    this.currentDelta().movedTo(element, movedFromElement);
                }
            }
            switch (elementType) {
                case 2: {
                    RubyProject project = (RubyProject)element.getRubyProject();
                    this.rootsToRefresh.add(project);
                    this.projectCachesToReset.add(project);
                    break;
                }
                case 3: {
                    RubyProject project = (RubyProject)element.getRubyProject();
                    this.projectCachesToReset.add(project);
                }
            }
        }
    }

    private boolean isPrimaryWorkingCopy(IRubyElement element, int elementType) {
        if (elementType == 4) {
            RubyScript cu = (RubyScript)element;
            return cu.isPrimary() && cu.isWorkingCopy();
        }
        return false;
    }

    private void elementRemoved(Openable element, IResourceDelta delta, RootInfo rootInfo) {
        int elementType = element.getElementType();
        if (delta == null || (delta.getFlags() & 0x2000) == 0) {
            if (this.isPrimaryWorkingCopy(element, elementType)) {
                this.currentDelta().changed(element, 262144);
            } else {
                this.close(element);
                this.removeFromParentInfo(element);
                this.currentDelta().removed(element);
            }
        } else {
            Openable movedToElement;
            IFolder movedToRes;
            this.close(element);
            this.removeFromParentInfo(element);
            IPath movedToPath = delta.getMovedToPath();
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 4: {
                    movedToRes = res.getWorkspace().getRoot().getProject(movedToPath.lastSegment());
                    break;
                }
                case 2: {
                    movedToRes = res.getWorkspace().getRoot().getFolder(movedToPath);
                    break;
                }
                case 1: {
                    movedToRes = res.getWorkspace().getRoot().getFile(movedToPath);
                    break;
                }
                default: {
                    return;
                }
            }
            RootInfo movedToInfo = this.enclosingRootInfo(movedToPath, 1);
            int movedToType = this.elementType((IResource)movedToRes, 1, element.getParent().getElementType(), movedToInfo);
            this.currentElement = null;
            Openable openable = movedToElement = elementType != 1 && movedToType == 1 ? null : this.createElement((IResource)movedToRes, movedToType, rootInfo);
            if (movedToElement == null) {
                this.currentDelta().removed(element);
            } else {
                this.currentDelta().movedFrom(element, movedToElement);
            }
        }
        switch (elementType) {
            case 0: {
                break;
            }
            case 1: {
                this.state.updateRoots(element.getPath(), delta, this);
                this.rootsToRefresh.add((IRubyProject)((Object)element));
                this.projectCachesToReset.add((IRubyProject)((Object)element));
                break;
            }
            case 2: {
                RubyProject project = (RubyProject)element.getRubyProject();
                this.rootsToRefresh.add(project);
                this.projectCachesToReset.add(project);
                break;
            }
            case 3: {
                RubyProject project = (RubyProject)element.getRubyProject();
                this.projectCachesToReset.add(project);
            }
        }
    }

    private void contentChanged(Openable element) {
        boolean isPrimary = false;
        boolean isPrimaryWorkingCopy = false;
        if (element.getElementType() == 4) {
            RubyScript cu = (RubyScript)element;
            isPrimary = cu.isPrimary();
            boolean bl = isPrimaryWorkingCopy = isPrimary && cu.isWorkingCopy();
        }
        if (isPrimaryWorkingCopy) {
            this.currentDelta().changed(element, 262144);
        } else {
            this.close(element);
            int flags = 1;
            if (isPrimary) {
                flags |= 0x40000;
            }
            this.currentDelta().changed(element, flags);
        }
    }

    private int elementType(IResource res, int kind, int parentType, RootInfo rootInfo) {
        switch (parentType) {
            case 0: {
                return 1;
            }
            case -1: 
            case 1: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(res.getFullPath(), kind);
                }
                if (rootInfo != null && rootInfo.isRootOfProject(res.getFullPath())) {
                    return 2;
                }
            }
            case 2: 
            case 3: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(res.getFullPath(), kind);
                }
                if (rootInfo == null) {
                    return -1;
                }
                if (Util.isExcluded(res, rootInfo.inclusionPatterns, rootInfo.exclusionPatterns)) {
                    return -1;
                }
                if (res.getType() == 2) {
                    if (parentType == -1 && !Util.isExcluded((IResource)res.getParent(), rootInfo.inclusionPatterns, rootInfo.exclusionPatterns)) {
                        return -1;
                    }
                    return 3;
                }
                String fileName = res.getName();
                if (Util.isValidRubyOrERBScriptName(fileName)) {
                    return 4;
                }
                if (this.rootInfo(res.getFullPath(), kind) != null) {
                    return 2;
                }
                return -1;
            }
        }
        return -1;
    }

    public static long getTimeStamp(File file) {
        return file.lastModified() + file.length();
    }

    private void reconcileLoadpathFileUpdate(IResourceDelta delta, RubyProject project) {
        switch (delta.getKind()) {
            case 2: {
                try {
                    RubyModelManager.PerProjectInfo info = project.getPerProjectInfo();
                    if (info.rawLoadpath == null) break;
                    project.saveLoadpath(info.rawLoadpath, info.outputLocation);
                }
                catch (RubyModelException e) {
                    if (!project.getProject().isAccessible()) break;
                    Util.log((Throwable)((Object)e), "Could not save loadpath for " + project.getPath());
                }
                break;
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) == 0 && (flags & 0x100000) == 0 && (flags & 0x1000) == 0) break;
            }
            case 1: {
                try {
                    project.forceLoadpathReload(null);
                    break;
                }
                catch (RuntimeException e) {
                    if (!VERBOSE) break;
                    e.printStackTrace();
                    break;
                }
                catch (RubyModelException e) {
                    if (!VERBOSE) break;
                    e.printStackTrace();
                }
            }
        }
    }

    private void updateIndex(Openable element, IResourceDelta delta) {
        block33: {
            IndexManager indexManager = this.manager.getIndexManager();
            if (indexManager == null) {
                return;
            }
            block0 : switch (element.getElementType()) {
                case 1: {
                    switch (delta.getKind()) {
                        case 1: {
                            indexManager.indexAll(element.getRubyProject().getProject());
                            break;
                        }
                        case 2: {
                            indexManager.removeIndexFamily(element.getRubyProject().getProject().getFullPath());
                        }
                    }
                    break;
                }
                case 2: {
                    if (element instanceof ExternalSourceFolderRoot) {
                        ExternalSourceFolderRoot root = (ExternalSourceFolderRoot)element;
                        IPath jarPath = root.getPath();
                        switch (delta.getKind()) {
                            case 1: {
                                indexManager.indexLibrary(jarPath, root.getRubyProject().getProject());
                                break;
                            }
                            case 4: {
                                indexManager.removeIndex(jarPath);
                                indexManager.indexLibrary(jarPath, root.getRubyProject().getProject());
                                break;
                            }
                            case 2: {
                                indexManager.discardJobs(jarPath.toString());
                                indexManager.removeIndex(jarPath);
                            }
                        }
                        break;
                    }
                    int kind = delta.getKind();
                    if (kind == 1 || kind == 2) {
                        SourceFolderRoot root = (SourceFolderRoot)element;
                        this.updateRootIndex(root, CharOperation.NO_STRINGS, delta);
                        break;
                    }
                }
                case 3: {
                    switch (delta.getKind()) {
                        case 1: 
                        case 2: {
                            ISourceFolder pkg = null;
                            if (element instanceof ISourceFolderRoot) {
                                SourceFolderRoot root = (SourceFolderRoot)element;
                                pkg = root.getSourceFolder(CharOperation.NO_STRINGS);
                            } else {
                                pkg = (ISourceFolder)((Object)element);
                            }
                            RootInfo rootInfo = this.rootInfo(pkg.getParent().getPath(), delta.getKind());
                            boolean isSource = rootInfo == null || rootInfo.entryKind == 3;
                            IResourceDelta[] children = delta.getAffectedChildren();
                            int i = 0;
                            int length = children.length;
                            while (i < length) {
                                IResourceDelta child = children[i];
                                IResource resource = child.getResource();
                                if (resource instanceof IFile) {
                                    String name = resource.getName();
                                    if (isSource && Util.isRubyOrERBLikeFileName(name)) {
                                        Openable cu = (Openable)((Object)pkg.getRubyScript(name));
                                        this.updateIndex(cu, child);
                                    }
                                }
                                ++i;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 4: {
                    IFile file = (IFile)delta.getResource();
                    switch (delta.getKind()) {
                        case 4: {
                            int flags = delta.getFlags();
                            if ((flags & 0x100) == 0 && (flags & 0x100000) == 0) break block33;
                        }
                        case 1: {
                            indexManager.addSource(file, file.getProject().getFullPath(), this.getSourceElementParser(element));
                            this.manager.secondaryTypesRemoving(file, false);
                            break block0;
                        }
                        {
                        }
                        case 2: {
                            indexManager.remove(Util.relativePath(file.getFullPath(), 1), file.getProject().getFullPath());
                            this.manager.secondaryTypesRemoving(file, true);
                        }
                    }
                }
            }
        }
    }

    private SourceElementParser getSourceElementParser(Openable element) {
        if (this.sourceElementParserCache == null) {
            this.sourceElementParserCache = this.manager.getIndexManager().getSourceElementParser(element.getRubyProject(), null);
        }
        return this.sourceElementParserCache;
    }

    private void updateRootIndex(SourceFolderRoot root, String[] pkgName, IResourceDelta delta) {
        SourceFolder pkg = root.getSourceFolder(pkgName);
        this.updateIndex(pkg, delta);
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        int length = children.length;
        while (i < length) {
            IResourceDelta child = children[i];
            IResource resource = child.getResource();
            if (resource instanceof IFolder) {
                String[] subpkgName = Util.arrayConcat(pkgName, resource.getName());
                this.updateRootIndex(root, subpkgName, child);
            }
            ++i;
        }
    }

    public boolean updateCurrentDeltaAndIndex(IResourceDelta delta, int elementType, RootInfo rootInfo) {
        switch (delta.getKind()) {
            case 1: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    this.state.updateRoots(deltaRes.getFullPath(), delta, this);
                    return rootInfo != null && rootInfo.inclusionPatterns != null;
                }
                this.updateIndex(element, delta);
                this.elementAdded(element, delta, rootInfo);
                return elementType == 3;
            }
            case 2: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    this.state.updateRoots(deltaRes.getFullPath(), delta, this);
                    return rootInfo != null && rootInfo.inclusionPatterns != null;
                }
                this.updateIndex(element, delta);
                this.elementRemoved(element, delta, rootInfo);
                if (deltaRes.getType() == 4) {
                    if (RubyBuilder.DEBUG) {
                        System.out.println("Clearing last state for removed project : " + deltaRes);
                    }
                    this.manager.setLastBuiltState((IProject)deltaRes, null);
                    this.manager.previousSessionContainers.remove(element);
                }
                return elementType == 3;
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) != 0 || (flags & 0x100000) != 0) {
                    Openable element = this.createElement(delta.getResource(), elementType, rootInfo);
                    if (element == null) {
                        return false;
                    }
                    this.updateIndex(element, delta);
                    this.contentChanged(element);
                } else if (elementType == 1) {
                    boolean isJavaProject;
                    IProject res;
                    boolean wasJavaProject;
                    if ((flags & 0x4000) != 0) {
                        IProject res2 = (IProject)delta.getResource();
                        Openable element = this.createElement((IResource)res2, elementType, rootInfo);
                        if (element == null) {
                            this.state.updateRoots(res2.getFullPath(), delta, this);
                            return false;
                        }
                        if (res2.isOpen()) {
                            if (RubyProject.hasRubyNature(res2)) {
                                this.addToParentInfo(element);
                                this.currentDelta().opened(element);
                                this.state.updateRoots(element.getPath(), delta, this);
                                this.rootsToRefresh.add((IRubyProject)((Object)element));
                                this.projectCachesToReset.add((IRubyProject)((Object)element));
                                this.manager.getIndexManager().indexAll(res2);
                            }
                        } else {
                            boolean wasJavaProject2;
                            boolean bl = wasJavaProject2 = this.state.findRubyProject(res2.getName()) != null;
                            if (wasJavaProject2) {
                                this.close(element);
                                this.removeFromParentInfo(element);
                                this.currentDelta().closed(element);
                                this.manager.getIndexManager().discardJobs(element.getElementName());
                                this.manager.getIndexManager().removeIndexFamily(res2.getFullPath());
                            }
                        }
                        return false;
                    }
                    if ((flags & 0x80000) != 0 && (wasJavaProject = this.state.findRubyProject((res = (IProject)delta.getResource()).getName()) != null) != (isJavaProject = RubyProject.hasRubyNature(res))) {
                        Openable element = this.createElement((IResource)res, elementType, rootInfo);
                        if (element == null) {
                            return false;
                        }
                        if (isJavaProject) {
                            this.elementAdded(element, delta, rootInfo);
                            this.manager.getIndexManager().indexAll(res);
                        } else {
                            this.elementRemoved(element, delta, rootInfo);
                            this.manager.getIndexManager().discardJobs(element.getElementName());
                            this.manager.getIndexManager().removeIndexFamily(res.getFullPath());
                            if (RubyBuilder.DEBUG) {
                                System.out.println("Clearing last state for project loosing Java nature: " + res);
                            }
                            this.manager.setLastBuiltState(res, null);
                        }
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public void checkExternalArchiveChanges(IRubyElement[] elementsToRefresh, IProgressMonitor monitor) throws RubyModelException {
        try {
            int i = 0;
            int length = elementsToRefresh.length;
            while (i < length) {
                this.addForRefresh(elementsToRefresh[i]);
                ++i;
            }
            boolean hasDelta = this.createExternalArchiveDelta(monitor);
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (hasDelta) {
                RubyModel.flushExternalFileCache();
                IRubyElementDelta[] projectDeltas = this.currentDelta.getAffectedChildren();
                int length2 = projectDeltas.length;
                int i2 = 0;
                while (i2 < length2) {
                    IRubyElementDelta delta = projectDeltas[i2];
                    RubyProject rubyProject = (RubyProject)delta.getElement();
                    rubyProject.getResolvedLoadpath(true, true, false);
                    ++i2;
                }
                if (this.currentDelta != null) {
                    this.fire(this.currentDelta, 0);
                }
            }
        }
        finally {
            this.currentDelta = null;
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private boolean createExternalArchiveDelta(IProgressMonitor monitor) {
        if (this.refreshedElements == null) {
            return false;
        }
        HashMap<IPath, String> externalArchivesStatus = new HashMap<IPath, String>();
        boolean hasDelta = false;
        HashSet<IPath> archivePathsToRefresh = new HashSet<IPath>();
        Iterator<IRubyElement> iterator = this.refreshedElements.iterator();
        this.refreshedElements = null;
        block11: while (iterator.hasNext()) {
            IRubyElement element = iterator.next();
            switch (element.getElementType()) {
                case 2: {
                    archivePathsToRefresh.add(element.getPath());
                    break;
                }
                case 1: {
                    ILoadpathEntry[] classpath;
                    RubyProject javaProject = (RubyProject)element;
                    if (!RubyProject.hasRubyNature(javaProject.getProject())) continue block11;
                    try {
                        classpath = javaProject.getResolvedLoadpath(true, false, false);
                        int j = 0;
                        int cpLength = classpath.length;
                        while (j < cpLength) {
                            if (classpath[j].getEntryKind() == 1) {
                                archivePathsToRefresh.add(classpath[j].getPath());
                            }
                            ++j;
                        }
                    }
                    catch (RubyModelException rubyModelException) {}
                    continue block11;
                }
                case 0: {
                    ILoadpathEntry[] classpath;
                    RubyProject javaProject;
                    for (String projectName : this.state.getOldRubyProjecNames()) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (!RubyProject.hasRubyNature(project)) continue;
                        javaProject = (RubyProject)RubyCore.create(project);
                        try {
                            classpath = javaProject.getResolvedLoadpath(true, false, false);
                        }
                        catch (RubyModelException rubyModelException) {
                            continue;
                        }
                        int k = 0;
                        int cpLength = classpath.length;
                        while (k < cpLength) {
                            if (classpath[k].getEntryKind() == 1) {
                                archivePathsToRefresh.add(classpath[k].getPath());
                            }
                            ++k;
                        }
                    }
                    continue block11;
                }
            }
        }
        Iterator projectNames = this.state.getOldRubyProjecNames().iterator();
        IWorkspaceRoot wksRoot = ResourcesPlugin.getWorkspace().getRoot();
        while (projectNames.hasNext()) {
            ILoadpathEntry[] entries;
            if (monitor != null && monitor.isCanceled()) break;
            String projectName = (String)projectNames.next();
            IProject project = wksRoot.getProject(projectName);
            if (!RubyProject.hasRubyNature(project)) continue;
            RubyProject javaProject = (RubyProject)RubyCore.create(project);
            try {
                entries = javaProject.getResolvedLoadpath(true, false, false);
            }
            catch (RubyModelException rubyModelException) {
                continue;
            }
            int j = 0;
            while (j < entries.length) {
                IPath entryPath;
                if (entries[j].getEntryKind() == 1 && archivePathsToRefresh.contains(entryPath = entries[j].getPath())) {
                    String status = (String)externalArchivesStatus.get(entryPath);
                    if (status == null) {
                        Object targetLibrary = RubyModel.getTarget(entryPath, true);
                        if (targetLibrary == null) {
                            if (this.state.getExternalLibTimeStamps().remove(entryPath) != null) {
                                externalArchivesStatus.put(entryPath, EXTERNAL_JAR_REMOVED);
                                this.manager.indexManager.removeIndex(entryPath);
                            }
                        } else if (targetLibrary instanceof File) {
                            File externalFile = (File)targetLibrary;
                            Long oldTimestamp = this.state.getExternalLibTimeStamps().get(entryPath);
                            long newTimeStamp = DeltaProcessor.getTimeStamp(externalFile);
                            if (oldTimestamp != null) {
                                if (newTimeStamp == 0L) {
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_REMOVED);
                                    this.state.getExternalLibTimeStamps().remove(entryPath);
                                    this.manager.indexManager.removeIndex(entryPath);
                                } else if (oldTimestamp != newTimeStamp) {
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_CHANGED);
                                    this.state.getExternalLibTimeStamps().put(entryPath, new Long(newTimeStamp));
                                    this.manager.indexManager.removeIndex(entryPath);
                                    this.manager.indexManager.indexLibrary(entryPath, project.getProject());
                                } else {
                                    externalArchivesStatus.put(entryPath, EXTERNAL_JAR_UNCHANGED);
                                }
                            } else if (newTimeStamp == 0L) {
                                externalArchivesStatus.put(entryPath, EXTERNAL_JAR_UNCHANGED);
                            } else {
                                externalArchivesStatus.put(entryPath, EXTERNAL_JAR_ADDED);
                                this.state.getExternalLibTimeStamps().put(entryPath, new Long(newTimeStamp));
                                this.manager.indexManager.indexLibrary(entryPath, project.getProject());
                            }
                        } else {
                            externalArchivesStatus.put(entryPath, INTERNAL_JAR_IGNORE);
                        }
                    }
                    if ((status = (String)externalArchivesStatus.get(entryPath)) != null) {
                        SourceFolderRoot root;
                        if (status == EXTERNAL_JAR_ADDED) {
                            root = (SourceFolderRoot)javaProject.getSourceFolderRoot(entryPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR ADDED, affecting root: " + root.getElementName());
                            }
                            this.elementAdded(root, null, null);
                            hasDelta = true;
                        } else if (status == EXTERNAL_JAR_CHANGED) {
                            root = (SourceFolderRoot)javaProject.getSourceFolderRoot(entryPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR CHANGED, affecting root: " + root.getElementName());
                            }
                            this.contentChanged(root);
                            hasDelta = true;
                        } else if (status == EXTERNAL_JAR_REMOVED) {
                            root = (SourceFolderRoot)javaProject.getSourceFolderRoot(entryPath.toString());
                            if (VERBOSE) {
                                System.out.println("- External JAR REMOVED, affecting root: " + root.getElementName());
                            }
                            this.elementRemoved(root, null, null);
                            hasDelta = true;
                        }
                    }
                }
                ++j;
            }
        }
        return hasDelta;
    }

    static class RootInfo {
        char[][] inclusionPatterns;
        char[][] exclusionPatterns;
        RubyProject project;
        IPath rootPath;
        int entryKind;
        ISourceFolderRoot root;

        RootInfo(RubyProject project, IPath rootPath, char[][] inclusionPatterns, char[][] exclusionPatterns, int entryKind) {
            this.project = project;
            this.rootPath = rootPath;
            this.inclusionPatterns = inclusionPatterns;
            this.exclusionPatterns = exclusionPatterns;
            this.entryKind = entryKind;
        }

        ISourceFolderRoot getSourceFolderRoot(IResource resource) {
            if (this.root == null) {
                Object target;
                this.root = resource != null ? this.project.getSourceFolderRoot(resource) : ((target = RubyModel.getTarget(this.rootPath, false)) instanceof IResource ? this.project.getSourceFolderRoot((IResource)target) : this.project.getSourceFolderRoot(this.rootPath.toOSString()));
            }
            return this.root;
        }

        boolean isRootOfProject(IPath path) {
            return this.rootPath.equals((Object)path) && this.project.getProject().getFullPath().isPrefixOf(path);
        }

        public String toString() {
            int length;
            int i;
            StringBuffer buffer = new StringBuffer("project=");
            if (this.project == null) {
                buffer.append("null");
            } else {
                buffer.append(this.project.getElementName());
            }
            buffer.append("\npath=");
            if (this.rootPath == null) {
                buffer.append("null");
            } else {
                buffer.append(this.rootPath.toString());
            }
            buffer.append("\nincluding=");
            if (this.inclusionPatterns == null) {
                buffer.append("null");
            } else {
                i = 0;
                length = this.inclusionPatterns.length;
                while (i < length) {
                    buffer.append(new String(this.inclusionPatterns[i]));
                    if (i < length - 1) {
                        buffer.append("|");
                    }
                    ++i;
                }
            }
            buffer.append("\nexcluding=");
            if (this.exclusionPatterns == null) {
                buffer.append("null");
            } else {
                i = 0;
                length = this.exclusionPatterns.length;
                while (i < length) {
                    buffer.append(new String(this.exclusionPatterns[i]));
                    if (i < length - 1) {
                        buffer.append("|");
                    }
                    ++i;
                }
            }
            return buffer.toString();
        }
    }
}

