/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IRegion;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.rubypeople.rdt.internal.core.hierarchy.TypeHierarchy;

public class CreateTypeHierarchyOperation
extends RubyModelOperation {
    protected TypeHierarchy typeHierarchy;

    public CreateTypeHierarchyOperation(IRegion region, IRubyScript[] workingCopies, IType element, boolean computeSubtypes) {
        super(element);
        this.typeHierarchy = new RegionBasedTypeHierarchy(region, workingCopies, element, computeSubtypes);
    }

    public CreateTypeHierarchyOperation(IType element, IRubyScript[] workingCopies, IRubySearchScope scope, boolean computeSubtypes) {
        super(element);
        IRubyScript[] copies;
        if (workingCopies != null) {
            int length = workingCopies.length;
            copies = new IRubyScript[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        } else {
            copies = null;
        }
        this.typeHierarchy = new TypeHierarchy(element, copies, scope, computeSubtypes);
    }

    public CreateTypeHierarchyOperation(IType element, IRubyScript[] workingCopies, IRubyProject project, boolean computeSubtypes) {
        super(element);
        IRubyScript[] copies;
        if (workingCopies != null) {
            int length = workingCopies.length;
            copies = new IRubyScript[length];
            System.arraycopy(workingCopies, 0, copies, 0, length);
        } else {
            copies = null;
        }
        this.typeHierarchy = new TypeHierarchy(element, copies, project, computeSubtypes);
    }

    protected void executeOperation() throws RubyModelException {
        try {
            this.typeHierarchy.refresh(this);
        }
        catch (IllegalStateException illegalStateException) {
            this.typeHierarchy = null;
        }
    }

    public ITypeHierarchy getResult() {
        return this.typeHierarchy;
    }

    public boolean isReadOnly() {
        return true;
    }

    public IRubyModelStatus verify() {
        IRubyElement elementToProcess = this.getElementToProcess();
        if (elementToProcess == null && !(this.typeHierarchy instanceof RegionBasedTypeHierarchy)) {
            return new RubyModelStatus(968);
        }
        if (elementToProcess != null && !elementToProcess.exists()) {
            return new RubyModelStatus(969, elementToProcess);
        }
        IRubyProject project = this.typeHierarchy.rubyProject();
        if (project != null && !project.exists()) {
            return new RubyModelStatus(969, project);
        }
        return RubyModelStatus.VERIFIED_OK;
    }
}

