/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.codeassist.CodeResolver;
import org.rubypeople.rdt.core.codeassist.ResolveContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionEngine {
    private static final String PERFORMANCE_EVENT = "org.rubypeople.rdt.core/perf/selection_engine";
    private static final boolean MEASURE_PERFORMANCE = PerformanceStats.isEnabled((String)"org.rubypeople.rdt.core/perf/selection_engine");
    private static final String EXTENSION_POINT = "codeResolver";
    private ArrayList<CodeResolver> fResolvers;

    public IRubyElement[] select(IRubyScript script, int start, int end) throws RubyModelException {
        ResolveContext context = new ResolveContext(script, start, end);
        List<CodeResolver> resolvers = this.getResolvers();
        for (CodeResolver resolver : resolvers) {
            PerformanceStats stats = null;
            if (MEASURE_PERFORMANCE) {
                stats = PerformanceStats.getStats((String)PERFORMANCE_EVENT, (Object)resolver);
                stats.startRun(resolver.getClass().getName());
            }
            resolver.select(context);
            if (!MEASURE_PERFORMANCE) continue;
            stats.endRun();
        }
        if (MEASURE_PERFORMANCE) {
            PerformanceStats.printStats();
        }
        return context.getResolved();
    }

    private List<CodeResolver> getResolvers() {
        if (this.fResolvers == null) {
            this.fResolvers = new ArrayList();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>((Collection)Arrays.asList(registry.getConfigurationElementsFor("org.rubypeople.rdt.core", EXTENSION_POINT)));
            this.sortParticipants(elements);
            for (IConfigurationElement configurationElement : elements) {
                try {
                    CodeResolver resolver = (CodeResolver)configurationElement.createExecutableExtension("class");
                    this.fResolvers.add(resolver);
                }
                catch (CoreException e) {
                    RubyCore.log((Exception)((Object)e));
                }
            }
        }
        return this.fResolvers;
    }

    private void sortParticipants(List<IConfigurationElement> group) {
        Collections.sort(group, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement a, IConfigurationElement b) {
                if (a == b) {
                    return 0;
                }
                String id = a.getAttribute("id");
                if (id == null) {
                    return -1;
                }
                IConfigurationElement[] requiredElements = b.getChildren("requires");
                int i = 0;
                int length = requiredElements.length;
                while (i < length) {
                    IConfigurationElement required = requiredElements[i];
                    if (id.equals(required.getAttribute("id"))) {
                        return 1;
                    }
                    ++i;
                }
                return -1;
            }
        });
    }
}

