/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.codeassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.codeassist.CodeResolver;
import org.rubypeople.rdt.core.codeassist.ResolveContext;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.codeassist.RubyElementRequestor;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.search.BasicSearchEngine;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.core.util.Util;
import org.rubypeople.rdt.internal.ti.ITypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeInferrer;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.FirstPrecursorNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyCodeResolver
extends CodeResolver {
    private HashSet<IType> fVisitedTypes;

    @Override
    public void select(ResolveContext context) throws RubyModelException {
        List<IRubyElement> possible;
        Collection<Object> possible2;
        IRubyScript script = context.getScript();
        int start = context.getStartOffset();
        RootNode root = context.getAST();
        Node selected = OffsetNodeLocator.Instance().getNodeAtOffset((Node)root, start);
        if (selected instanceof StrNode) {
            StrNode string = (StrNode)selected;
            FCallNode fcall = (FCallNode)ClosestSpanningNodeLocator.Instance().findClosestSpanner((Node)root, string.getPosition().getStartOffset(), new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof FCallNode;
                }
            });
            if (fcall == null) {
                return;
            }
            if (fcall.getName().equals("require") || fcall.getName().equals("load")) {
                String value = string.getValue().toString();
                if (!value.endsWith(".rb")) {
                    value = String.valueOf(value) + ".rb";
                }
                ILoadpathEntry[] entries = script.getRubyProject().getResolvedLoadpath(true);
                int i = 0;
                while (i < entries.length) {
                    IPath path = entries[i].getPath().append(value);
                    if (path.toFile().exists()) {
                        String[] minusFileName;
                        IFile file = null;
                        file = path.isAbsolute() ? ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path) : ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                        if (file != null) {
                            context.putResolved(new IRubyElement[]{RubyCore.create(file)});
                            return;
                        }
                        ISourceFolderRoot sfRoot = script.getRubyProject().getSourceFolderRoot(entries[i].getPath().toPortableString());
                        String[] parts = value.split("[\\|/]");
                        if (parts.length == 1) {
                            minusFileName = new String[]{};
                        } else {
                            minusFileName = new String[parts.length - 1];
                            System.arraycopy(parts, 0, minusFileName, 0, minusFileName.length);
                        }
                        ISourceFolder folder = sfRoot.getSourceFolder(minusFileName);
                        context.putResolved(new IRubyElement[]{folder.getRubyScript(path.lastSegment())});
                        return;
                    }
                    ++i;
                }
            }
        }
        if (selected instanceof AliasNode) {
            AliasNode aliasNode = (AliasNode)selected;
            int startOffset = aliasNode.getPosition().getStartOffset();
            int diff = start - startOffset;
            if (diff < 6 + aliasNode.getNewName().length() + 1) {
                return;
            }
            String methodName = aliasNode.getOldName();
            ArrayList<IRubyElement> possible3 = new ArrayList<IRubyElement>();
            try {
                List<SearchMatch> results = this.search(6, methodName, 0, 0);
                for (SearchMatch match : results) {
                    IRubyElement element = (IRubyElement)match.getElement();
                    possible3.add(element);
                }
            }
            catch (CoreException e) {
                RubyCore.log((Exception)((Object)e));
            }
            context.putResolved(possible3.toArray(new IRubyElement[possible3.size()]));
            return;
        }
        if (selected instanceof Colon2Node) {
            String simpleName = ((Colon2Node)selected).getName();
            String fullyQualifiedName = ASTUtil.getFullyQualifiedName((Colon2Node)selected);
            IRubyElement element = this.findChild(simpleName, 5, script);
            if (element != null && Util.parentsMatch((IType)element, fullyQualifiedName)) {
                context.putResolved(new IRubyElement[]{element});
                return;
            }
            RubyElementRequestor completer = new RubyElementRequestor(script);
            context.putResolved(completer.findType(fullyQualifiedName));
            return;
        }
        if (selected instanceof DVarNode) {
            final String name = ((DVarNode)selected).getName();
            Node assignment = FirstPrecursorNodeLocator.Instance().findFirstPrecursor((Node)root, start, new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof DAsgnNode && ((DAsgnNode)node).getName().equals(name);
                }
            });
            context.putResolved(new IRubyElement[]{script.getElementAt(assignment.getPosition().getStartOffset())});
            return;
        }
        if (selected instanceof ConstNode) {
            IRubyElement[] types;
            IRubyElement element;
            List<SearchMatch> matches;
            IRubySearchScope scope;
            ConstNode constNode = (ConstNode)selected;
            String name = constNode.getName();
            try {
                scope = SearchEngine.createRubySearchScope(new IRubyElement[]{script});
                matches = this.search(scope, 9, name, 0, 0);
                for (SearchMatch match : matches) {
                    element = (IRubyElement)match.getElement();
                    if (element == null) continue;
                    context.putResolved(new IRubyElement[]{element});
                    return;
                }
            }
            catch (CoreException e) {
                RubyCore.log((Exception)((Object)e));
            }
            try {
                scope = SearchEngine.createRubySearchScope(new IRubyElement[]{script});
                matches = this.search(scope, 5, name, 0, 0);
                for (SearchMatch match : matches) {
                    element = (IRubyElement)match.getElement();
                    if (element == null) continue;
                    context.putResolved(new IRubyElement[]{element});
                    return;
                }
            }
            catch (CoreException e) {
                RubyCore.log((Exception)((Object)e));
            }
            RubyElementRequestor completer = new RubyElementRequestor(script);
            String fullyQualifiedName = this.getFullyQualifiedName((Node)root, constNode.getPosition().getStartOffset(), name);
            if (fullyQualifiedName != null && (types = completer.findType(fullyQualifiedName)) != null && types.length > 0) {
                context.putResolved(types);
                return;
            }
            context.putResolved(completer.findType(name));
            return;
        }
        if (this.isLocalVarRef(selected)) {
            IRubyElement spanner = script.getElementAt(selected.getPosition().getStartOffset());
            possible2 = new ArrayList();
            if (spanner instanceof IParent) {
                IParent parent = (IParent)((Object)spanner);
                possible2 = this.getChildrenWithName(parent.getChildren(), 12, this.getName(selected));
            }
            if (possible2.isEmpty()) {
                possible2 = this.getChildrenWithName(script.getChildren(), 12, this.getName(selected));
            }
            context.putResolved(possible2.toArray(new IRubyElement[possible2.size()]));
            return;
        }
        if (this.isInstanceVarRef(selected)) {
            possible = this.getChildrenWithName(script.getChildren(), 11, this.getName(selected));
            context.putResolved(possible.toArray(new IRubyElement[possible.size()]));
            return;
        }
        if (this.isClassVarRef(selected)) {
            possible = this.getChildrenWithName(script.getChildren(), 10, this.getName(selected));
            context.putResolved(possible.toArray(new IRubyElement[possible.size()]));
            return;
        }
        if (selected instanceof DefnNode || selected instanceof DefsNode || selected instanceof ConstDeclNode || selected instanceof ClassNode || selected instanceof ModuleNode || selected instanceof ClassVarDeclNode) {
            IRubyElement element = ((RubyScript)script).getElementAt(start);
            context.putResolved(new IRubyElement[]{element});
            return;
        }
        if (this.isMethodCall(selected)) {
            String methodName = this.getName(selected);
            possible2 = new HashSet();
            IType[] types = this.getReceiver(script, selected, (Node)root, start);
            int i = 0;
            while (i < types.length) {
                IType type = types[i];
                if (this.fVisitedTypes == null) {
                    this.fVisitedTypes = new HashSet();
                }
                Collection<IMethod> methods = this.suggestMethods(type);
                this.fVisitedTypes.clear();
                for (IMethod method : methods) {
                    if (!method.getElementName().equals(methodName)) continue;
                    possible2.add(method);
                }
                ++i;
            }
            if (possible2.isEmpty()) {
                try {
                    List<SearchMatch> results = this.search(6, methodName, 0, 0);
                    for (SearchMatch match : results) {
                        IRubyElement element = (IRubyElement)match.getElement();
                        possible2.add(element);
                    }
                }
                catch (CoreException e) {
                    RubyCore.log((Exception)((Object)e));
                }
            }
            context.putResolved(possible2.toArray((IRubyElement[])new IRubyElement[possible2.size()]));
            return;
        }
    }

    private String getFullyQualifiedName(Node root, int offset, String name) {
        String namespace = ASTUtil.getNamespace(root, offset);
        if (namespace == null || namespace.trim().length() == 0) {
            return name;
        }
        return String.valueOf(namespace) + "::" + name;
    }

    private List<SearchMatch> search(int type, String patternString, int limitTo, int matchRule) throws CoreException {
        return this.search(SearchEngine.createWorkspaceScope(), type, patternString, limitTo, matchRule);
    }

    private List<SearchMatch> search(IRubySearchScope scope, int type, String patternString, int limitTo, int matchRule) throws CoreException {
        SearchEngine engine = new SearchEngine();
        SearchPattern pattern = SearchPattern.createPattern(type, patternString, limitTo, matchRule);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        engine.search(pattern, participants, scope, requestor, null);
        return requestor.getResults();
    }

    private IType[] getReceiver(IRubyScript script, Node selected, Node root, int start) {
        ArrayList<IType> types = new ArrayList<IType>();
        if (selected instanceof FCallNode || selected instanceof VCallNode) {
            Node receiver = null;
            IRubySearchScope scope = null;
            receiver = ClosestSpanningNodeLocator.Instance().findClosestSpanner(root, start, new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof ClassNode || node instanceof ModuleNode;
                }
            });
            scope = SearchEngine.createRubySearchScope(new IRubyElement[]{script});
            String typeName = ASTUtil.getNameReflectively(receiver);
            if (typeName == null) {
                typeName = "Object";
            }
            CollectingSearchRequestor collectingSearchRequestor = new CollectingSearchRequestor();
            SearchPattern pattern = SearchPattern.createPattern(5, typeName, 0, 0);
            SearchParticipant[] participants = new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()};
            try {
                new BasicSearchEngine().search(pattern, participants, scope, collectingSearchRequestor, null);
            }
            catch (CoreException e) {
                RubyCore.log((Exception)((Object)e));
            }
            List<SearchMatch> matches = collectingSearchRequestor.getResults();
            if (matches == null || matches.isEmpty()) {
                return new IType[0];
            }
            for (SearchMatch match : matches) {
                types.add((IType)match.getElement());
            }
        } else {
            ITypeInferrer inferrer = RubyCore.getTypeInferrer();
            Collection<Object> guesses = new ArrayList();
            try {
                guesses = inferrer.infer(script.getSource(), start);
            }
            catch (RubyModelException e1) {
                RubyCore.log((Exception)((Object)e1));
            }
            if (guesses.isEmpty()) {
                String methodName = ASTUtil.getNameReflectively(selected);
                IRubySearchScope iRubySearchScope = SearchEngine.createRubySearchScope(new IRubyElement[]{script.getRubyProject()});
                CollectingSearchRequestor requestor = new CollectingSearchRequestor();
                SearchPattern pattern = SearchPattern.createPattern(6, methodName, 0, 0);
                SearchParticipant[] participants = new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()};
                try {
                    new BasicSearchEngine().search(pattern, participants, iRubySearchScope, requestor, null);
                }
                catch (CoreException e) {
                    RubyCore.log((Exception)((Object)e));
                }
                List<SearchMatch> matches = requestor.getResults();
                if (matches == null || matches.isEmpty()) {
                    return new IType[0];
                }
                for (SearchMatch match : matches) {
                    IMethod method = (IMethod)match.getElement();
                    types.add(method.getDeclaringType());
                }
            } else {
                RubyElementRequestor requestor = new RubyElementRequestor(script);
                for (ITypeGuess iTypeGuess : guesses) {
                    String name = iTypeGuess.getType();
                    IType[] tmpTypes = requestor.findType(name);
                    int i = 0;
                    while (i < tmpTypes.length) {
                        types.add(tmpTypes[i]);
                        ++i;
                    }
                }
            }
        }
        return types.toArray(new IType[types.size()]);
    }

    private Collection<IMethod> suggestMethods(IType type) throws RubyModelException {
        if (type == null) {
            return Collections.emptyList();
        }
        if (this.fVisitedTypes == null) {
            this.fVisitedTypes = new HashSet();
        }
        ArrayList<IMethod> proposals = new ArrayList<IMethod>();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] all = new IType[]{type};
        if (hierarchy != null) {
            all = hierarchy.getAllSupertypes(type);
        }
        int j = 0;
        while (j < all.length) {
            IType currentType = all[j];
            if (!this.fVisitedTypes.contains(currentType)) {
                this.fVisitedTypes.add(currentType);
                IMethod[] methods = currentType.getMethods();
                if (methods != null) {
                    int k = 0;
                    while (k < methods.length) {
                        if (methods[k] != null) {
                            proposals.add(methods[k]);
                        }
                        ++k;
                    }
                }
            }
            ++j;
        }
        this.fVisitedTypes.clear();
        return proposals;
    }

    private IRubyElement findChild(String name, int type, IParent parent) {
        try {
            IRubyElement[] children = parent.getChildren();
            int j = 0;
            while (j < children.length) {
                IRubyElement found;
                IRubyElement child = children[j];
                if (child.getElementName().equals(name) && child.isType(type)) {
                    return child;
                }
                if (child instanceof IParent && (found = this.findChild(name, type, (IParent)((Object)child))) != null) {
                    return found;
                }
                ++j;
            }
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
        return null;
    }

    private boolean isMethodCall(Node selected) {
        return selected instanceof VCallNode || selected instanceof FCallNode || selected instanceof CallNode;
    }

    private List<IRubyElement> getChildrenWithName(IRubyElement[] children, int type, String name) throws RubyModelException {
        ArrayList<IRubyElement> possible = new ArrayList<IRubyElement>();
        int i = 0;
        while (i < children.length) {
            IRubyElement child = children[i];
            if (child.getElementType() == type && child.getElementName().equals(name)) {
                possible.add(child);
            }
            if (child instanceof IParent) {
                possible.addAll(this.getChildrenWithName(((IParent)((Object)child)).getChildren(), type, name));
            }
            ++i;
        }
        return possible;
    }

    private String getName(Node node) {
        if (node instanceof INameNode) {
            return ((INameNode)node).getName();
        }
        if (node instanceof ClassVarNode) {
            return ((ClassVarNode)node).getName();
        }
        return "";
    }

    private boolean isInstanceVarRef(Node node) {
        return node instanceof InstAsgnNode || node instanceof InstVarNode;
    }

    private boolean isClassVarRef(Node node) {
        return node instanceof ClassVarAsgnNode || node instanceof ClassVarNode;
    }

    private boolean isLocalVarRef(Node node) {
        return node instanceof LocalAsgnNode || node instanceof ArgumentNode || node instanceof LocalVarNode;
    }
}

