/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.codeassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.internal.compiler.ISourceElementRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTSourceRequestor
implements ISourceElementRequestor {
    private Map<ISourceElementRequestor.TypeInfo, List<ISourceElementRequestor.MethodInfo>> types = new HashMap<ISourceElementRequestor.TypeInfo, List<ISourceElementRequestor.MethodInfo>>();
    private Map<ISourceElementRequestor.TypeInfo, List<String>> mixins = new HashMap<ISourceElementRequestor.TypeInfo, List<String>>();
    private List<ISourceElementRequestor.TypeInfo> typeStack = new ArrayList<ISourceElementRequestor.TypeInfo>();
    private Map<String, ISourceElementRequestor.TypeInfo> fullTypeNames = new HashMap<String, ISourceElementRequestor.TypeInfo>();
    private ISourceElementRequestor.TypeInfo topLevel = new ISourceElementRequestor.TypeInfo();
    private ISourceElementRequestor.MethodInfo latestMethod;

    public ASTSourceRequestor() {
        this.topLevel.declarationStart = 0;
        this.topLevel.isModule = false;
        this.topLevel.name = "Object";
        this.topLevel.nameSourceStart = 0;
        this.topLevel.nameSourceEnd = 0;
        this.topLevel.secondary = false;
        this.topLevel.superclass = null;
    }

    @Override
    public void acceptConstructorReference(String name, int argCount, int offset) {
    }

    @Override
    public void acceptFieldReference(String name, int offset) {
    }

    @Override
    public void acceptImport(String value, int startOffset, int endOffset) {
    }

    @Override
    public void acceptMethodReference(String name, int argCount, int offset) {
    }

    @Override
    public void acceptMethodVisibilityChange(String methodName, int visibility) {
    }

    @Override
    public void acceptMixin(String string) {
        ISourceElementRequestor.TypeInfo info = this.getCurrentType();
        List<String> duh = this.mixins.get(info);
        if (duh == null) {
            duh = new ArrayList<String>();
        }
        duh.add(string);
        this.mixins.put(info, duh);
    }

    @Override
    public void acceptModuleFunction(String function) {
    }

    @Override
    public void acceptProblem(CategorizedProblem problem) {
    }

    @Override
    public void acceptTypeReference(String name, int startOffset, int endOffset) {
    }

    @Override
    public void acceptUnknownReference(String name, int startOffset, int endOffset) {
    }

    @Override
    public void enterConstructor(ISourceElementRequestor.MethodInfo constructor) {
    }

    @Override
    public void enterField(ISourceElementRequestor.FieldInfo field) {
    }

    @Override
    public void enterMethod(ISourceElementRequestor.MethodInfo method) {
        ISourceElementRequestor.TypeInfo info = this.getCurrentType();
        List<ISourceElementRequestor.MethodInfo> methods = this.types.get(info);
        if (methods == null) {
            methods = new ArrayList<ISourceElementRequestor.MethodInfo>();
        }
        methods.add(method);
        this.types.put(info, methods);
        this.latestMethod = method;
    }

    @Override
    public void acceptYield(String name) {
        this.latestMethod.blockVars = new String[]{name};
    }

    private ISourceElementRequestor.TypeInfo getCurrentType() {
        if (this.typeStack.isEmpty()) {
            return this.topLevel;
        }
        ISourceElementRequestor.TypeInfo info = this.typeStack.get(this.typeStack.size() - 1);
        return info;
    }

    @Override
    public void enterScript() {
    }

    @Override
    public void enterType(ISourceElementRequestor.TypeInfo type) {
        this.types.put(type, new ArrayList());
        this.typeStack.add(type);
        this.mixins.put(type, new ArrayList());
        String fullName = String.valueOf(this.getNamespace()) + type.name;
        this.fullTypeNames.put(fullName, type);
    }

    private String getNamespace() {
        StringBuffer buffer = new StringBuffer();
        ArrayList<ISourceElementRequestor.TypeInfo> newTypeStack = new ArrayList<ISourceElementRequestor.TypeInfo>(this.typeStack);
        newTypeStack.remove(newTypeStack.size() - 1);
        for (ISourceElementRequestor.TypeInfo type : newTypeStack) {
            buffer.append(type.name);
            buffer.append("::");
        }
        return buffer.toString();
    }

    @Override
    public void exitConstructor(int endOffset) {
    }

    @Override
    public void exitField(int endOffset) {
    }

    @Override
    public void exitMethod(int endOffset) {
    }

    @Override
    public void exitScript(int endOffset) {
    }

    @Override
    public void exitType(int endOffset) {
        this.typeStack.remove(this.typeStack.size() - 1);
    }

    public List<String> getMixins(String name) {
        for (String fullName : this.fullTypeNames.keySet()) {
            if (!fullName.equals(name)) continue;
            ISourceElementRequestor.TypeInfo info = this.fullTypeNames.get(fullName);
            return this.mixins.get(info);
        }
        return Collections.emptyList();
    }

    public Map<IMethod, String> getMethods(String mixin) {
        HashMap<IMethod, String> duh = new HashMap<IMethod, String>();
        for (String fullName : this.fullTypeNames.keySet()) {
            if (!fullName.equals(mixin)) continue;
            ISourceElementRequestor.TypeInfo info = this.fullTypeNames.get(fullName);
            List<ISourceElementRequestor.MethodInfo> methods = this.types.get(info);
            for (ISourceElementRequestor.MethodInfo methodInfo : methods) {
                duh.put(new MethodInfoMethod(methodInfo), mixin);
            }
            return duh;
        }
        return duh;
    }

    @Override
    public void acceptBlock(int startOffset, int endOffset) {
    }

    private static class MethodInfoMethod
    implements IMethod {
        private ISourceElementRequestor.MethodInfo info;

        public MethodInfoMethod(ISourceElementRequestor.MethodInfo info) {
            this.info = info;
        }

        public int getNumberOfParameters() throws RubyModelException {
            return this.info.parameterNames.length;
        }

        public String[] getParameterNames() throws RubyModelException {
            return this.info.parameterNames;
        }

        public int getVisibility() throws RubyModelException {
            return this.info.visibility;
        }

        public boolean isConstructor() {
            return this.info.isConstructor;
        }

        public boolean isPrivate() throws RubyModelException {
            return this.info.visibility == 2;
        }

        public boolean isProtected() throws RubyModelException {
            return this.info.visibility == 4;
        }

        public boolean isPublic() throws RubyModelException {
            return this.info.visibility == 1;
        }

        public boolean isSingleton() {
            return this.info.isClassLevel;
        }

        public boolean exists() {
            return false;
        }

        public IRubyElement getAncestor(int ancestorType) {
            return null;
        }

        public IResource getCorrespondingResource() throws RubyModelException {
            return null;
        }

        public String getElementName() {
            return this.info.name;
        }

        public int getElementType() {
            return 6;
        }

        public String getHandleIdentifier() {
            return null;
        }

        public IOpenable getOpenable() {
            return null;
        }

        public IRubyElement getParent() {
            return null;
        }

        public IPath getPath() {
            return null;
        }

        public IRubyElement getPrimaryElement() {
            return null;
        }

        public IResource getResource() {
            return null;
        }

        public IRubyModel getRubyModel() {
            return null;
        }

        public IRubyProject getRubyProject() {
            return null;
        }

        public IResource getUnderlyingResource() throws RubyModelException {
            return null;
        }

        public boolean isReadOnly() {
            return false;
        }

        public boolean isStructureKnown() throws RubyModelException {
            return false;
        }

        public boolean isType(int type) {
            return type == 6;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IType getDeclaringType() {
            return null;
        }

        public ISourceRange getNameRange() throws RubyModelException {
            return null;
        }

        public IRubyScript getRubyScript() {
            return null;
        }

        public IType getType(String name, int occurrenceCount) {
            return null;
        }

        public String getSource() throws RubyModelException {
            return null;
        }

        public ISourceRange getSourceRange() throws RubyModelException {
            return null;
        }

        public IRubyElement[] getChildren() throws RubyModelException {
            return null;
        }

        public boolean hasChildren() throws RubyModelException {
            return false;
        }

        public String[] getBlockParameters() throws RubyModelException {
            return this.info.blockVars;
        }
    }
}

