/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.compiler;

import java.util.HashMap;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.internal.core.ReconcileWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.RubyScript;

public class ReconcileContext {
    private ReconcileWorkingCopyOperation operation;
    private RubyScript workingCopy;

    public ReconcileContext(ReconcileWorkingCopyOperation operation, RubyScript workingCopy) {
        this.operation = operation;
        this.workingCopy = workingCopy;
    }

    public RootNode getAST() throws RubyModelException {
        return this.operation.makeConsistent(this.workingCopy, null);
    }

    public IRubyElementDelta getDelta() {
        return this.operation.deltaBuilder.delta;
    }

    public CategorizedProblem[] getProblems(String markerType) {
        if (this.operation.problems == null) {
            return null;
        }
        return (CategorizedProblem[])this.operation.problems.get(markerType);
    }

    public IRubyScript getWorkingCopy() {
        return this.workingCopy;
    }

    public void resetAST() {
        this.operation.ast = null;
        this.putProblems("org.rubypeople.rdt.core.problem", null);
        this.putProblems("org.rubypeople.rdt.core.task", null);
    }

    public void putProblems(String markerType, CategorizedProblem[] problems) {
        if (this.operation.problems == null) {
            this.operation.problems = new HashMap();
        }
        this.operation.problems.put(markerType, problems);
    }
}

