/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.compiler;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.CompilationParticipantResult;
import org.rubypeople.rdt.internal.core.util.Util;

public class BuildContext
extends CompilationParticipantResult {
    public BuildContext(IFile resource) {
        super(resource);
    }

    public char[] getContents() {
        try {
            return Util.getResourceContentsAsCharArray(this.resource);
        }
        catch (CoreException coreException) {
            throw new RuntimeException("Missing source file: " + this.resource);
        }
    }

    public IFile getFile() {
        return this.resource;
    }

    public boolean hasAnnotations() {
        return this.hasAnnotations;
    }

    public void recordNewProblems(CategorizedProblem[] newProblems) {
        int length2 = newProblems.length;
        if (length2 == 0) {
            return;
        }
        int length1 = this.problems == null ? 0 : this.problems.length;
        CategorizedProblem[] merged = new CategorizedProblem[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(this.problems, 0, merged, 0, length1);
        }
        System.arraycopy(newProblems, 0, merged, length1, length2);
        this.problems = merged;
    }
}

