/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.codeassist;

import org.eclipse.core.resources.IFile;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.ti.util.OffsetNodeLocator;

public class ResolveContext {
    private IRubyScript script;
    private int start;
    private int end;
    private RootNode root;
    private Node selected;
    private IRubyElement[] resolved = new IRubyElement[0];

    public ResolveContext(IRubyScript script, int start, int end) {
        this.script = script;
        this.start = start;
        this.end = end;
    }

    public RootNode getAST() throws RubyModelException {
        if (this.root == null) {
            try {
                RubyParser parser = new RubyParser();
                this.root = (RootNode)parser.parse((IFile)this.script.getResource(), this.script.getSource()).getAST();
            }
            catch (SyntaxException syntaxException) {
                this.root = (RootNode)((RubyScript)this.script).lastGoodAST;
            }
        }
        return this.root;
    }

    public Node getSelectedNode() throws RubyModelException {
        if (this.selected == null) {
            this.selected = OffsetNodeLocator.Instance().getNodeAtOffset((Node)this.getAST(), this.start);
        }
        return this.selected;
    }

    public IRubyScript getScript() {
        return this.script;
    }

    public int getStartOffset() {
        return this.start;
    }

    public int getEndOffset() {
        return this.end;
    }

    public IRubyElement[] getResolved() {
        return this.resolved;
    }

    public void putResolved(IRubyElement[] resolved) {
        this.resolved = resolved;
    }
}

