/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyConventions {
    public static IStatus validateRubyScriptName(String name) {
        if (name == null) {
            return new Status(4, "org.rubypeople.rdt.core", -1, Messages.bind(Messages.convention_unit_nullName), null);
        }
        if (!Util.isRubyLikeFileName(name)) {
            return new Status(4, "org.rubypeople.rdt.core", -1, Messages.bind(Messages.convention_unit_notRubyName), null);
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (!status.isOK()) {
            return status;
        }
        return RubyModelStatus.VERIFIED_OK;
    }

    public static IStatus validateIdentifier(String id) {
        return RubyModelStatus.VERIFIED_OK;
    }

    public static IStatus validateRubyTypeName(String typeName) {
        if (typeName == null) {
            return new Status(4, "org.rubypeople.rdt.core", -1, Messages.convention_type_nullName, null);
        }
        if (typeName.length() == 0) {
            return new Status(4, "org.rubypeople.rdt.core", -1, Messages.bind(Messages.convention_type_invalidName, typeName), null);
        }
        if (!RubyConventions.isConstant(typeName)) {
            return new Status(4, "org.rubypeople.rdt.core", -1, "Class name must be a constant. It must begin with a capital letter, and contain only letters, digits, or underscores.", null);
        }
        return RubyModelStatus.VERIFIED_OK;
    }

    public static IStatus validateConstant(String constantName) {
        if (constantName == null) {
            return new Status(4, "org.rubypeople.rdt.core", -1, Messages.convention_type_nullName, null);
        }
        if (constantName.length() == 0) {
            return new Status(4, "org.rubypeople.rdt.core", -1, Messages.bind(Messages.convention_type_invalidName, constantName), null);
        }
        if (!RubyConventions.isConstant(constantName)) {
            return new Status(4, "org.rubypeople.rdt.core", -1, "Name must be a constant. It must begin with a capital letter, and contain only letters, digits, or underscores.", null);
        }
        return RubyModelStatus.VERIFIED_OK;
    }

    private static boolean isConstant(String className) {
        if (className == null || className.length() == 0) {
            return false;
        }
        if (!Character.isLowerCase(className.charAt(0)) && !Character.isLetter(className.charAt(0))) {
            return false;
        }
        int namespaceDelimeterIndex = className.indexOf("::");
        if (namespaceDelimeterIndex != -1) {
            return RubyConventions.isConstant(className.substring(0, namespaceDelimeterIndex)) && RubyConventions.isConstant(className.substring(namespaceDelimeterIndex + 2));
        }
        int i = 0;
        while (i < className.length()) {
            char c = className.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IStatus validateSourceFolderName(String packName) {
        return RubyModelStatus.VERIFIED_OK;
    }

    public static IRubyModelStatus validateLoadpath(IRubyProject rubyProject, ILoadpathEntry[] rawCLoadpath, IPath projectOutputLocation) {
        return LoadpathEntry.validateLoadpath(rubyProject, rawCLoadpath, projectOutputLocation);
    }

    public static IStatus validateMethodName(String methodName) {
        return RubyConventions.validateIdentifier(methodName);
    }

    public static boolean isRubyIdentifierPart(char c) {
        return RubyConventions.isStrictRubyIdentifierPart(c) || c == ':' || c == '$' || c == '@' || c == '!' || c == '?';
    }

    private static boolean isStrictRubyIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }
}

