/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.ui.dialogs;

import com.aptana.rdt.core.gems.Gem;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.radrails.db.core.DatabaseManager;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.ui.RailsUIPlugin;
import org.radrails.server.core.ServerManager;
import org.rubypeople.rdt.internal.ui.dialogs.StatusDialog;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringDialogField;

public class EditServerDialog
extends StatusDialog
implements IDialogFieldListener {
    private String name;
    private String type;
    private String port;
    private String environment;
    private String host;
    private String currName;
    private String currType;
    private String currPort;
    private String currHost;
    private String currEnvironment;
    private boolean fAskForProject;
    private IProject project;
    private StringDialogField nameField;
    private StringDialogField hostField;
    private StringDialogField portField;
    private ComboDialogField environmentField;
    private ComboDialogField typeField;
    private Combo projectCombo;

    public EditServerDialog(Shell parentShell, String currName, String currType, String currHost, String currPort, String currEnvironment) {
        super(parentShell);
        this.currName = currName;
        this.currType = currType;
        this.currHost = currHost;
        if (this.currHost == null) {
            this.currHost = "127.0.0.1";
        }
        this.currPort = String.valueOf(currPort);
        this.currEnvironment = currEnvironment;
        this.dontAskForProject();
        this.createFields();
    }

    private void createFields() {
        this.nameField = new StringDialogField();
        this.nameField.setLabelText("Name:");
        this.nameField.setText(this.currName);
        this.typeField = new ComboDialogField(12);
        this.typeField.setLabelText("Type:");
        String[] types = new String[]{"WEBrick", "Mongrel", "LightTPD"};
        this.typeField.setItems(types);
        this.typeField.setText(this.currType);
        this.typeField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ComboDialogField duh = (ComboDialogField)field;
                String text = duh.getText();
                if (text != null && text.equals("Mongrel") && !RailsPlugin.getInstance().getGemManager().gemInstalled("mongrel") && RailsPlugin.getInstance().getMongrelPath() == null && MessageDialog.openQuestion((Shell)EditServerDialog.this.getShell(), (String)"Mongrel not installed", (String)"Mongrel does not appear to be installed. Would you like to begin installing it?")) {
                    EditServerDialog.this.getShell().close();
                    Job job = new Job("Installing mongrel..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            return RailsPlugin.getInstance().getGemManager().installGem(new Gem("mongrel", "", null), monitor);
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
            }
        });
        this.hostField = new StringDialogField();
        this.hostField.setLabelText("Host:");
        this.hostField.setText(this.currHost);
        this.hostField.setDialogFieldListener((IDialogFieldListener)this);
        this.portField = new StringDialogField();
        this.portField.setLabelText("Port:");
        this.portField.setText(this.currPort);
        this.portField.setDialogFieldListener((IDialogFieldListener)this);
        this.environmentField = new ComboDialogField(12);
        this.environmentField.setLabelText("Environment:");
        Set environments = DatabaseManager.getEnvironments();
        environments.add(this.currEnvironment);
        this.environmentField.setItems(environments.toArray(new String[environments.size()]));
        this.environmentField.setText(this.currEnvironment);
    }

    public EditServerDialog(Shell shell) {
        this(shell, "webrick development server", "WEBrick", "127.0.0.1", ServerManager.getInstance().getNextAvailablePort(), "development");
        this.fAskForProject = true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Server properties");
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        control.setLayout((Layout)layout);
        if (this.fAskForProject) {
            IProject project2;
            Label projectLabel = new Label(control, 16384);
            projectLabel.setText("Project:");
            this.projectCombo = new Combo(control, 12);
            RailsPlugin.getInstance();
            Set projects = RailsPlugin.getRailsProjects();
            for (IProject project2 : projects) {
                this.projectCombo.add(project2.getName());
            }
            project2 = RailsUIPlugin.getInstance().getSelectedRailsProject();
            if (project2 != null) {
                this.projectCombo.setText(project2.getName());
            } else if (projects != null && projects.size() > 0) {
                this.projectCombo.setText(this.projectCombo.getItem(0));
            }
            this.projectCombo.setLayoutData((Object)new GridData(768));
        }
        this.nameField.doFillIntoGrid(control, 2);
        this.typeField.doFillIntoGrid(control, 2);
        this.hostField.doFillIntoGrid(control, 2);
        this.portField.doFillIntoGrid(control, 2);
        this.environmentField.doFillIntoGrid(control, 2);
        return control;
    }

    public void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = this.nameField.getText();
            this.port = this.portField.getText();
            this.environment = this.environmentField.getText();
            this.type = this.typeField.getText();
            this.host = this.hostField.getText().trim();
            if (this.projectCombo != null) {
                String projectName = this.projectCombo.getText();
                this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getType() {
        return this.type;
    }

    public IProject getProject() {
        return this.project;
    }

    public void dontAskForProject() {
        this.fAskForProject = false;
    }

    protected void validate() {
        String host = this.hostField.getText();
        if (host.trim().length() == 0) {
            this.updateStatus((IStatus)new Status(4, "org.radrails.server.core", -1, "Empty host", null));
            return;
        }
        String port = this.portField.getText();
        if (port.trim().length() == 0) {
            this.updateStatus((IStatus)new Status(4, "org.radrails.server.core", -1, "Empty port", null));
            return;
        }
        try {
            int portInt = Integer.parseInt(port);
            if (portInt < 1) {
                this.updateStatus((IStatus)new Status(4, "org.radrails.server.core", -1, "Negative integer port", null));
                return;
            }
        }
        catch (NumberFormatException e) {
            this.updateStatus((IStatus)new Status(4, "org.radrails.server.core", -1, "Non-integer port", (Throwable)e));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    public void dialogFieldChanged(DialogField field) {
        this.validate();
    }
}

