/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui.wizards.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.radrails.rails.ui.wizards.NewProjectBasedResourceWizard;
import org.radrails.server.core.ServerManager;
import org.radrails.server.internal.ui.wizards.NewServerWizard;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.DecoratingRubyLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;

public class WizardNewServerPage
extends WizardPage {
    private Text projectNameText;
    private Text serverNameText;
    private Text portText;
    private Combo serverTypeCombo;
    private ModifyListener nameModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            boolean valid = WizardNewServerPage.this.validatePage();
            WizardNewServerPage.this.setPageComplete(valid);
        }
    };

    public WizardNewServerPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        this.createInputControls(control);
        this.setControl((Control)control);
        this.setPageComplete(this.validatePage());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.projectNameText.getText().equals("")) {
                this.projectNameText.setFocus();
            } else if (this.serverNameText.getText().equals("")) {
                this.serverNameText.setFocus();
            } else {
                this.portText.setFocus();
            }
        }
    }

    private void createInputControls(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(1808));
        Label projectLabel = new Label(control, 16384);
        projectLabel.setText("Project:");
        this.projectNameText = new Text(control, 2048);
        this.projectNameText.setLayoutData((Object)new GridData(768));
        NewServerWizard wizard = (NewServerWizard)this.getWizard();
        this.projectNameText.setText(wizard.getSelectedProjectName());
        this.projectNameText.addModifyListener(this.nameModifyListener);
        Button projectSelectButton = new Button(control, 8);
        projectSelectButton.setText("Browse...");
        projectSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardNewServerPage.this.handleProjectSelectButtonPressed();
            }
        });
        Label serverTypeLabel = new Label(control, 16384);
        serverTypeLabel.setText("Type:");
        this.serverTypeCombo = new Combo(control, 4);
        this.serverTypeCombo.add("WEBrick");
        this.serverTypeCombo.add("Mongrel");
        this.serverTypeCombo.add("LightTPD");
        this.serverTypeCombo.setLayoutData((Object)new GridData(768));
        this.serverTypeCombo.setText("WEBrick");
        this.serverTypeCombo.addModifyListener(this.nameModifyListener);
        new Label(control, 0);
        Label serverNameLabel = new Label(control, 16384);
        serverNameLabel.setText("Name:");
        this.serverNameText = new Text(control, 2048);
        this.serverNameText.setLayoutData((Object)new GridData(768));
        this.serverNameText.setText(String.valueOf(wizard.getSelectedProjectName()) + "Server");
        this.serverNameText.addModifyListener(this.nameModifyListener);
        new Label(control, 0);
        Label portNumberLabel = new Label(control, 16384);
        portNumberLabel.setText("Port:");
        this.portText = new Text(control, 2048);
        this.portText.setLayoutData((Object)new GridData(768));
        this.portText.setText(String.valueOf(ServerManager.getInstance().getNextAvailablePort()));
        this.portText.addModifyListener(this.nameModifyListener);
    }

    protected void handleProjectSelectButtonPressed() {
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((IWorkspaceRoot)inputElement).getProjects();
            }
        });
        dialog.setLabelProvider((ILabelProvider)new DecoratingRubyLabelProvider((RubyUILabelProvider)new AppearanceAwareLabelProvider()));
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        NewProjectBasedResourceWizard wizard = (NewProjectBasedResourceWizard)this.getWizard();
        dialog.setInitialSelections((Object[])new IProject[]{wizard.getProjectForName(this.getProjectName())});
        dialog.setInput((Object)wsroot);
        dialog.setMessage("Choose a project:");
        dialog.setTitle("Project Selection");
        dialog.create();
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null) {
            IProject project = (IProject)result[0];
            this.projectNameText.setText(project.getName());
        }
    }

    public String getProjectName() {
        return this.projectNameText.getText();
    }

    public String getServerName() {
        return this.serverNameText.getText();
    }

    public String getPort() {
        return this.portText.getText();
    }

    public String getServerType() {
        return this.serverTypeCombo.getText();
    }

    private boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.getProjectName().equals("")) {
            this.setErrorMessage("Project name empty");
            return false;
        }
        if (!workspace.validateName(this.getProjectName(), 4).isOK()) {
            this.setErrorMessage("Invalid project name");
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName()).exists()) {
            this.setErrorMessage("Project does not exist");
            return false;
        }
        if (this.getServerName().equals("")) {
            this.setErrorMessage("Server name empty");
            return false;
        }
        if (this.portText.getText().equals("")) {
            this.setErrorMessage("Port number empty");
            return false;
        }
        if (ServerManager.getInstance().portInUse(this.getPort())) {
            this.setMessage("Port number already in use", 2);
        }
        if (ServerManager.getInstance().projectHasServer(this.getProjectName(), this.getServerType())) {
            this.setMessage("Project already has a " + this.getServerType() + " server", 2);
        }
        return true;
    }
}

