/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui.console;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.radrails.server.internal.ui.ActionUtil;

public class ServerStopAction
extends Action
implements Observer {
    private IProcess process;
    private Server server;

    public ServerStopAction(IProcess process) {
        this.process = process;
        ActionUtil.initAction((IAction)this, "stop.gif", "Stop server");
        ServerManager.getInstance().addServerObserver((Observer)this);
        this.setEnablement(this.getServer());
    }

    public void run() {
        this.getServer().stop();
    }

    private Server getServer() {
        if (this.server != null) {
            return this.server;
        }
        Server server = ServerManager.getInstance().findByProcess(this.process);
        if (server != null) {
            this.server = server;
        }
        return server;
    }

    public void update(Observable o, Object arg) {
        if (this.getServer() == null) {
            this.setEnabled(false);
            return;
        }
        String action = (String)arg;
        if (action.equals("update")) {
            Server s = (Server)o;
            if (!s.equals((Object)this.getServer())) {
                return;
            }
            this.setEnablement(s);
        }
    }

    private void setEnablement(Server s) {
        if (s == null) {
            this.setEnabled(false);
            return;
        }
        if (s.isStopped() || s.isStopping()) {
            this.setEnabled(false);
            final ServerStopAction self = this;
            Job job = new Job("Remove server observer"){

                protected IStatus run(IProgressMonitor monitor) {
                    ServerManager.getInstance().deleteServerObserver(self);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            this.setEnabled(true);
        }
    }
}

