/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.radrails.server.core.Server;
import org.radrails.server.internal.ui.ServerUIPlugin;

public class ServerLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int SERVER_TYPE_COLUMN = 0;
    private static final int SERVER_NAME_COLUMN = 1;
    private static final int PROJECT_NAME_COLUMN = 2;
    private static final int STATUS_COLUMN = 3;
    private static final int PORT_COLUMN = 4;
    private static final int ENVIRONMENT_COLUMN = 5;

    public Image getColumnImage(Object element, int columnIndex) {
        Server server = (Server)element;
        Image image = null;
        ImageDescriptor imageDesc = null;
        if (columnIndex == 0) {
            if (server.getType().equals("WEBrick")) {
                imageDesc = this.getDescriptor("icons/webrick.gif");
            } else if (server.getType().equals("LightTPD")) {
                imageDesc = this.getDescriptor("icons/lighttpd.gif");
            } else if (server.getType().equals("Mongrel")) {
                imageDesc = this.getDescriptor("icons/mongrel.gif");
            }
        }
        if (imageDesc != null) {
            image = imageDesc.createImage();
        }
        return image;
    }

    private ImageDescriptor getDescriptor(String name) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ServerUIPlugin.getInstance().getBundle().getSymbolicName(), (String)name);
    }

    public String getColumnText(Object element, int columnIndex) {
        Server server = (Server)element;
        switch (columnIndex) {
            case 1: {
                return server.getName();
            }
            case 2: {
                return server.getProject().getName();
            }
            case 3: {
                return server.getStatus();
            }
            case 4: {
                return server.getPort();
            }
            case 5: {
                return server.getEnvironment();
            }
        }
        return "";
    }
}

