/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.radrails.server.bridge;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.Configuration;
import com.aptana.ide.server.core.impl.servers.AbstractServer;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.ui.views.actions.ICanEdit;
import com.aptana.radrails.server.bridge.Messages;
import com.aptana.radrails.server.bridge.RailsServerLog;
import com.aptana.radrails.server.bridge.RailsServerType;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;
import org.radrails.server.core.Server;
import org.radrails.server.internal.ui.ServerUIPlugin;
import org.radrails.server.ui.dialogs.EditServerDialog;

public class RailsServer
extends AbstractServer {
    private static final IProcess[] NO_PROCESS = new IProcess[0];
    private Server srv;
    private ILog log;

    public int getServerState() {
        String status = this.srv.getStatus();
        if (status.equals("Starting...")) {
            return 1;
        }
        if (status.equals("Started")) {
            return 2;
        }
        if (status.equals("Stopping...")) {
            return 3;
        }
        if (status.equals("Stopped")) {
            return 4;
        }
        return super.getServerState();
    }

    public String getName() {
        return this.srv.getName();
    }

    public RailsServer(Server s) {
        super((IServerType)new RailsServerType(s), (IAbstractConfiguration)new RailsServerConfiguration(s));
        this.srv = s;
        this.log = new RailsServerLog(s);
    }

    protected IStatus restart(String mode, IProgressMonitor monitor) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                RailsServer.this.srv.restart();
            }
        });
        return Status.OK_STATUS;
    }

    protected IStatus start(final String mode, IProgressMonitor monitor) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                RailsServer.this.srv.updateRunMode(mode);
                RailsServer.this.srv.start();
            }
        });
        return Status.OK_STATUS;
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        this.srv.stop();
        return Status.OK_STATUS;
    }

    public IStatus canHaveModule(IModule module) {
        return new Status(4, "com.aptana.ide.server", 4, Messages.RailsServer_ERROR, null);
    }

    public String getConfigurationDescription() {
        return StringUtils.format((String)Messages.RailsServer_DESCRIPTION, (Object[])new Object[]{this.srv.getProject().getName(), this.srv.getEnvironment()});
    }

    public ILog getLog() {
        return this.log;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ICanEdit.class) {
            return new ICanEdit(){

                public void doEdit() {
                    EditServerDialog dialog;
                    int returnCode;
                    if (RailsServer.this.srv.isStopped() && (returnCode = (dialog = new EditServerDialog(Display.getCurrent().getActiveShell(), RailsServer.this.srv.getName(), RailsServer.this.srv.getType(), RailsServer.this.srv.getHost(), RailsServer.this.srv.getPort(), RailsServer.this.srv.getEnvironment())).open()) == 0) {
                        if (!RailsServer.this.srv.getType().equals(dialog.getType())) {
                            RailsServer.this.srv.updateType(dialog.getType());
                        }
                        if (!RailsServer.this.srv.getHost().equals(dialog.getHost())) {
                            RailsServer.this.srv.updateHost(dialog.getHost());
                        }
                        if (!RailsServer.this.srv.getName().equals(dialog.getName())) {
                            RailsServer.this.srv.updateName(dialog.getName());
                        }
                        if (!RailsServer.this.srv.getPort().equals(dialog.getPort())) {
                            RailsServer.this.srv.updatePort(dialog.getPort());
                        }
                        if (!RailsServer.this.srv.getEnvironment().equals(dialog.getEnvironment())) {
                            RailsServer.this.srv.updateEnvironment(dialog.getEnvironment());
                        }
                        org.radrails.server.core.ServerManager.getInstance().saveServers();
                    }
                }
            };
        }
        return Platform.getAdapterManager().getAdapter((Object)this.srv, adapter);
    }

    public Server getServer() {
        return this.srv;
    }

    public boolean isExternal() {
        return true;
    }

    public IProcess[] getProcesses() {
        IProcess process = this.srv.getProcess();
        if (process != null) {
            return new IProcess[]{process};
        }
        return NO_PROCESS;
    }

    public String getHost() {
        return StringUtils.format((String)"{0}:{1}", (Object[])new String[]{this.srv.getHost(), this.srv.getPort()});
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.srv.getPort());
        }
        catch (NumberFormatException e) {
            IdeLog.logInfo((Plugin)ServerUIPlugin.getInstance(), (String)e.getMessage(), (Throwable)e);
            return 3000;
        }
    }

    public IPath getDocumentRoot() {
        return null;
    }

    public String getHostname() {
        return this.getHost();
    }

    public String fetchStatistics() {
        return null;
    }

    private static class RailsServerConfiguration
    extends Configuration {
        public RailsServerConfiguration(Server s) {
            this.setStringAttribute("name", s.getName());
            this.setStringAttribute("id", ServerManager.getFreeId());
            this.setIntAttribute("port", s.getPortInt());
            this.setStringAttribute("association_id", "");
        }
    }
}

