/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.radrails.server.bridge;

import com.aptana.ide.server.core.IServer;
import com.aptana.radrails.server.bridge.RailsServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.radrails.rails.ui.browser.BrowserUtil;
import org.radrails.server.core.Server;

public class LaunchBrowser
implements IObjectActionDelegate {
    private IStructuredSelection sel;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.sel == null || this.sel.getFirstElement() == null) {
            return;
        }
        final Server server = ((RailsServer)((Object)this.sel.getFirstElement())).getServer();
        UIJob job = new UIJob("Opening browser"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (server == null) {
                        return Status.CANCEL_STATUS;
                    }
                    String port = String.valueOf(server.getPort());
                    BrowserUtil.openBrowser((String)("http://" + server.getBrowserHost() + ":" + port));
                }
                catch (Exception e) {
                    return new Status(4, "com.aptana.radrails.server.bridge", -1, e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.sel = (IStructuredSelection)selection;
            IServer server = (IServer)((IStructuredSelection)selection).getFirstElement();
            if (server != null) {
                action.setEnabled(server.getServerState() == 2);
            } else {
                action.setEnabled(false);
            }
        }
    }
}

