/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.ui;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.ContributedGemRegistry;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.core.gems.Version;
import com.aptana.rdt.internal.ui.GemAutoInstallDialog;
import com.aptana.rdt.ui.AptanaRDTUIPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.rubypeople.rdt.debug.ui.InstallDeveloperToolsDialog;
import org.rubypeople.rdt.internal.debug.ui.launcher.InstallGemsJob;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.internal.ui.RubyInstalledDetector;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemAutoInstallDialogJob
extends UIJob {
    public GemAutoInstallDialogJob() {
        super("Installing gems");
        this.setRule(new SerialRule());
    }

    public boolean shouldRun() {
        return !PlatformUI.getWorkbench().isClosing();
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (!this.usingIncludedJRuby() && this.rubyNotInstalled()) {
            if (RubyInstalledDetector.isFinished()) {
                return Status.CANCEL_STATUS;
            }
            this.schedule(30000L);
            return Status.OK_STATUS;
        }
        if (!this.getGemManager().isRubyGemsInstalled()) {
            String key = "dont_bug_about_gems_not_installed";
            String dontBug = AptanaRDTUIPlugin.getDefault().getPreferenceStore().getString(key);
            if (dontBug != null && dontBug.equals("always")) {
                return Status.OK_STATUS;
            }
            MessageDialogWithToggle.openWarning((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)"RubyGems Not Installed", (String)"You do not appear to have RubyGems installed. It is highly recommended that you install this, as it is the standard way of installing and managing ruby libraries. Please see http://rubygems.org/read/chapter/3.", (String)"Don't bug me anymore.", (boolean)false, (IPreferenceStore)AptanaRDTUIPlugin.getDefault().getPreferenceStore(), (String)key);
            return Status.OK_STATUS;
        }
        monitor.beginTask("Getting auto-install gems...", 35);
        monitor.subTask("Getting contributed gems");
        Collection<Gem> gems = this.getContributedGems();
        monitor.worked(10);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.subTask("Filtering by platform");
        gems = this.filterByPlatform(gems);
        monitor.worked(5);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.subTask("Filtering out already installed gems");
        gems = this.filterOutInstalled(gems);
        monitor.worked(10);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.subTask("Filtering out user ignored gems");
        gems = GemAutoInstallDialogJob.filterOutIgnored(gems);
        monitor.worked(10);
        gems = this.filterActiveResource(gems);
        if (gems.isEmpty()) {
            monitor.done();
            return Status.OK_STATUS;
        }
        if (this.hasGemsWhichCompile(gems) && InstallDeveloperToolsDialog.shouldShow()) {
            InstallDeveloperToolsDialog installToolsDialog = new InstallDeveloperToolsDialog(RubyPlugin.getActiveWorkbenchShell());
            installToolsDialog.open();
            return Status.CANCEL_STATUS;
        }
        GemAutoInstallDialog dialog = new GemAutoInstallDialog(RubyPlugin.getActiveWorkbenchShell(), gems);
        if (PlatformUI.getWorkbench().isClosing()) {
            return Status.CANCEL_STATUS;
        }
        int code = dialog.open();
        if (code == 1) {
            monitor.setCanceled(true);
            return Status.CANCEL_STATUS;
        }
        Collection<Gem> finalGems = dialog.getSelectedGems();
        if (finalGems.isEmpty()) {
            monitor.done();
            return Status.OK_STATUS;
        }
        InstallGemsJob job = new InstallGemsJob(finalGems);
        job.setSystem(true);
        job.schedule();
        monitor.done();
        return Status.OK_STATUS;
    }

    private boolean usingIncludedJRuby() {
        Preferences store = LaunchingPlugin.getDefault().getPluginPreferences();
        if (store == null) {
            return false;
        }
        return store.getBoolean("org.rubypeople.rdt.launching.us.included.jruby");
    }

    private boolean rubyNotInstalled() {
        IVMInstall[] cRubyInstalls = RubyRuntime.getVMInstallType((String)"org.rubypeople.rdt.launching.StandardVMType").getVMInstalls();
        return cRubyInstalls == null || cRubyInstalls.length == 0;
    }

    private Collection<Gem> filterByPlatform(Collection<Gem> gems) {
        return ContributedGemRegistry.filterByPlatform(gems);
    }

    private Collection<Gem> filterActiveResource(Collection<Gem> gems) {
        if (!this.contains(gems, "activeresource")) {
            return gems;
        }
        if (!this.getGemManager().gemInstalled("rails")) {
            return gems;
        }
        boolean containsRails2 = false;
        List versions = this.getGemManager().getVersions("rails");
        for (Version version : versions) {
            if (!version.isGreaterThanOrEqualTo("2.0.0")) continue;
            containsRails2 = true;
            break;
        }
        if (!containsRails2) {
            return this.remove(gems, "activeresource");
        }
        return gems;
    }

    private Collection<Gem> remove(Collection<Gem> gems, String name) {
        Gem toRemove = this.get(gems, name);
        if (toRemove == null) {
            return gems;
        }
        ArrayList<Gem> copy = new ArrayList<Gem>(gems);
        copy.remove(toRemove);
        return copy;
    }

    private boolean contains(Collection<Gem> gems, String name) {
        return this.get(gems, name) != null;
    }

    private Gem get(Collection<Gem> gems, String name) {
        for (Gem gem : gems) {
            if (!gem.getName().equals(name)) continue;
            return gem;
        }
        return null;
    }

    private boolean hasGemsWhichCompile(Collection<Gem> finalGems) {
        for (Gem gem : finalGems) {
            if (!gem.compiles()) continue;
            return true;
        }
        return false;
    }

    private static Collection<Gem> filterOutIgnored(Collection<Gem> gems) {
        ArrayList<Gem> filtered = new ArrayList<Gem>();
        IPreferenceStore prefs = AptanaRDTUIPlugin.getDefault().getPreferenceStore();
        for (Gem gem : gems) {
            if (prefs.getBoolean(GemAutoInstallDialog.getIgnorePrefKey(gem))) continue;
            filtered.add(gem);
        }
        return filtered;
    }

    private Collection<Gem> filterOutInstalled(Collection<Gem> gems) {
        ArrayList<Gem> filtered = new ArrayList<Gem>();
        for (Gem gem : gems) {
            if (this.getGemManager().gemInstalled(gem.getName()) && (!gem.forceUpdates() || this.newerVersionInstalled(gem))) continue;
            filtered.add(gem);
        }
        return filtered;
    }

    private boolean newerVersionInstalled(Gem gem) {
        List versions = this.getGemManager().getVersions(gem.getName());
        for (Version version : versions) {
            if (!version.isGreaterThanOrEqualTo(gem.getVersionObject())) continue;
            return true;
        }
        return false;
    }

    private IGemManager getGemManager() {
        return AptanaRDTPlugin.getDefault().getGemManager();
    }

    private Collection<Gem> getContributedGems() {
        return ContributedGemRegistry.getContributedGems();
    }

    private static class SerialRule
    implements ISchedulingRule {
        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof SerialRule;
        }
    }
}

