/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.ui;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.core.gems.LocalFileGem;
import com.aptana.rdt.ui.AptanaRDTUIPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.util.CollectionContentProvider;
import org.rubypeople.rdt.ui.TableViewerSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemAutoInstallDialog
extends StatusDialog {
    private CheckboxTableViewer gemViewer;
    private IStructuredContentProvider contentProvider = new CollectionContentProvider();
    private Collection<Gem> input;
    protected List<Gem> selected = new ArrayList<Gem>();

    protected GemAutoInstallDialog(Shell shell, Collection<Gem> gems) {
        super(shell);
        this.input = gems;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Auto-install gems");
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        control.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        control.setLayoutData((Object)data);
        Label sourceLabel = new Label(control, 16448);
        sourceLabel.setText("Plugins have contributed local copies of the following gems for automatic installation. Please select which gems you'd like installed for you. To not be prompted about installing particular gems, please select the gems to ignore and click the 'Ignore Selected' button at bottom.");
        sourceLabel.setLayoutData((Object)data);
        Table gemsTable = new Table(parent, 65572);
        this.gemViewer = new CheckboxTableViewer(gemsTable);
        gemsTable.setHeaderVisible(true);
        gemsTable.setLinesVisible(false);
        data = new GridData(768);
        data.heightHint = 400;
        gemsTable.setLayoutData((Object)data);
        TableColumn nameColumn = new TableColumn(gemsTable, 16384);
        nameColumn.setText("Name");
        nameColumn.setWidth(200);
        TableColumn versionColumn = new TableColumn(gemsTable, 16384);
        versionColumn.setText("Version");
        versionColumn.setWidth(100);
        TableColumn descriptionColumn = new TableColumn(gemsTable, 16384);
        descriptionColumn.setText("Platform");
        descriptionColumn.setWidth(100);
        this.gemViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                Gem gem = (Gem)element;
                switch (columnIndex) {
                    case 0: {
                        return gem.getName();
                    }
                    case 1: {
                        return gem.getVersion();
                    }
                    case 2: {
                        return gem.getPlatform();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.gemViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.gemViewer.setInput(this.input);
        TableViewerSorter.bind((TableViewer)this.gemViewer, (int)1);
        this.gemViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] checked = GemAutoInstallDialog.this.gemViewer.getCheckedElements();
                GemAutoInstallDialog.this.selected.clear();
                int i = 0;
                while (i < checked.length) {
                    GemAutoInstallDialog.this.selected.add((Gem)checked[i]);
                    ++i;
                }
                GemAutoInstallDialog.this.checkDependencies();
            }
        });
        this.gemViewer.setAllChecked(true);
        this.selected = new ArrayList<Gem>(this.input);
        this.setImage(RubyPluginImages.get((String)"org.rubypeople.rdt.ui.ruby.gif"));
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            Button button;
            Object data;
            if (children[i] instanceof Button && (data = (button = (Button)children[i]).getData()) instanceof Integer) {
                Integer value = (Integer)data;
                if (value == 0) {
                    button.setText("Install");
                } else if (value == 1) {
                    button.setText("Close");
                }
            }
            ++i;
        }
        Button dontAsk = this.createButton(parent, 3, "Ignore Selected", false);
        dontAsk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore prefs = AptanaRDTUIPlugin.getDefault().getPreferenceStore();
                Collection<Gem> selectedGems = GemAutoInstallDialog.this.getSelectedGems();
                for (Gem gem : selectedGems) {
                    prefs.setValue(GemAutoInstallDialog.getIgnorePrefKey(gem), true);
                }
                ArrayList<Gem> toRemove = new ArrayList<Gem>();
                TableItem[] items = GemAutoInstallDialog.this.gemViewer.getTable().getItems();
                int x = 0;
                while (x < items.length) {
                    if (items[x].getChecked()) {
                        items[x].setChecked(false);
                        items[x].setGrayed(true);
                        toRemove.add((Gem)items[x].getData());
                    }
                    ++x;
                }
                GemAutoInstallDialog.this.gemViewer.remove((Object[])toRemove.toArray(new Gem[toRemove.size()]));
                GemAutoInstallDialog.this.selected.clear();
                super.widgetSelected(e);
            }
        });
    }

    static String getIgnorePrefKey(Gem gem) {
        return "ignore-auto-install-" + gem.getName() + "-" + gem.getVersion();
    }

    protected void checkDependencies() {
        StringBuffer buffer = new StringBuffer();
        for (Gem gem : this.selected) {
            LocalFileGem local = (LocalFileGem)gem;
            Set dependencies = local.getDependencies();
            for (String dependency : dependencies) {
                if (this.getGemManager().gemInstalled(dependency) || this.contains(this.selected, dependency)) continue;
                if (buffer.length() > 0) {
                    buffer.append("\n");
                }
                buffer.append(String.valueOf(local.getName()) + " requires " + dependency);
            }
        }
        if (buffer.length() > 0) {
            this.updateStatus((IStatus)new Status(2, "com.aptana.rdt.ui", -1, buffer.toString(), null));
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
    }

    private IGemManager getGemManager() {
        return AptanaRDTPlugin.getDefault().getGemManager();
    }

    private boolean contains(Collection<Gem> gems, String name) {
        for (Gem gem : gems) {
            if (!gem.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Collection<Gem> getSelectedGems() {
        return this.selected;
    }
}

