/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.sasseditor.editor.rules;

import net.lucky_dip.hamleditor.HTMLCSSKeywords;
import net.lucky_dip.sasseditor.editor.SassWordDetector;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SassTagRule
implements IPredicateRule {
    private IToken token;
    private SassWordDetector wordDetector;

    public SassTagRule(IToken token) {
        this.token = token;
        this.wordDetector = new SassWordDetector();
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c;
        int read = 0;
        String str = "";
        IToken res = Token.UNDEFINED;
        boolean startOfRow = scanner.getColumn() == 0;
        char last = '\u0000';
        if (!startOfRow) {
            scanner.unread();
            last = (char)scanner.read();
        }
        while ((c = scanner.read()) != -1) {
            ++read;
            if (c == 10 || c == 13) break;
            str = String.valueOf(str) + (char)c;
        }
        if ((startOfRow || !this.wordDetector.isWordPart(last)) && HTMLCSSKeywords.isHtmlTag(str.trim())) {
            res = this.token;
        } else {
            int i = 0;
            while (i < read) {
                scanner.unread();
                ++i;
            }
        }
        return res;
    }
}

