/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.sasseditor.editor.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import net.lucky_dip.hamleditor.HTMLCSSKeywords;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class SassContentAssistantProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        IDocumentExtension3 doc3 = (IDocumentExtension3)viewer.getDocument();
        ArrayList<CompletionProposal> res = new ArrayList<CompletionProposal>();
        try {
            ITypedRegion region = doc3.getPartition("__sass_partitioning", offset > 0 ? offset - 1 : 0, false);
            int regionOffset = region.getOffset() + 1;
            String start = viewer.getDocument().get(regionOffset, offset - regionOffset);
            start = start.toLowerCase();
            if (region.getType().equals("__sass_attribute")) {
                res.addAll(HTMLCSSKeywords.getCssAttributeMatches(start, regionOffset, region));
            } else if (region.getType().equals("__sass_constant")) {
                ITypedRegion[] regions = doc3.computePartitioning("__sass_partitioning", 0, doc.getLength(), false);
                String[] classNames = this.getConstants(doc, regions);
                int i = 0;
                while (i < classNames.length) {
                    String cname = classNames[i];
                    CompletionProposal cp = new CompletionProposal(cname, regionOffset, region.getLength() - 1, cname.length());
                    res.add(cp);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res.toArray(new ICompletionProposal[res.size()]);
    }

    private String[] getConstants(IDocument document, ITypedRegion[] regions) {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < regions.length) {
            if (regions[i].getType().equals("__sass_constant")) {
                try {
                    String constant;
                    int offset = regions[i].getOffset() + 1;
                    int length = regions[i].getLength() - 1;
                    if (length > 0 && !res.contains(constant = document.get(offset, length))) {
                        res.add(constant);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        Collections.sort(res);
        return res.toArray(new String[res.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

