/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.hamleditor.editor.scanners;

import java.util.ArrayList;
import net.lucky_dip.hamleditor.editor.HamlWordDetector;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordPatternRule;

public class HamlPartitionScanner
extends RuleBasedPartitionScanner {
    private static HamlPartitionScanner instance;
    public static final String HAML_DOCTYPE = "__haml_doctype";
    public static final String HAML_COMMENT = "__haml_comment";
    public static final String HAML_RUBY = "__haml_ruby";
    public static final String HAML_CLASS = "__haml_class";
    public static final String HAML_ID = "__haml_id";
    public static final String HAML_ELEMENT = "__haml_element";
    public static final String[] HAML_PARTITION_TYPES;

    static {
        HAML_PARTITION_TYPES = new String[]{HAML_DOCTYPE, HAML_RUBY, HAML_CLASS, HAML_ID, HAML_COMMENT, HAML_ELEMENT};
    }

    public static boolean IsHAMLPartitionType(String contentType) {
        boolean res = false;
        int i = 0;
        while (!res && i < HAML_PARTITION_TYPES.length) {
            res = contentType.equals(HAML_PARTITION_TYPES[i]);
            ++i;
        }
        return res;
    }

    public static HamlPartitionScanner getInstance() {
        if (instance == null) {
            instance = new HamlPartitionScanner();
        }
        return instance;
    }

    private HamlPartitionScanner() {
        Token doctype = new Token((Object)HAML_DOCTYPE);
        Token comment = new Token((Object)HAML_COMMENT);
        Token element = new Token((Object)HAML_ELEMENT);
        Token classToken = new Token((Object)HAML_CLASS);
        Token idToken = new Token((Object)HAML_ID);
        Token rubyToken = new Token((Object)HAML_RUBY);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WordPatternRule((IWordDetector)new HamlWordDetector(), "%", "", (IToken)element));
        rules.add(new SingleLineRule("!!!", "", (IToken)doctype, '\u0000', false));
        rules.add(new MultiLineRule("<!--", "-->", (IToken)comment, '\u0000', true));
        rules.add(new SingleLineRule("/", null, (IToken)comment));
        rules.add(new WordPatternRule((IWordDetector)new HamlWordDetector(), ".", "", (IToken)classToken));
        rules.add(new WordPatternRule((IWordDetector)new HamlWordDetector(), "#", "", (IToken)idToken));
        rules.add(new SingleLineRule("=", "", (IToken)rubyToken, '\u0000', true, false));
        rules.add(new SingleLineRule("~", "", (IToken)rubyToken, '\u0000', true, false));
        rules.add(new SingleLineRule("[", "]", (IToken)rubyToken, '\u0000', true, false));
        rules.add(new SingleLineRule("-", "", (IToken)rubyToken, '\u0000', true, false));
        rules.add(new SingleLineRule("{", "}", (IToken)rubyToken, '\u0000', true));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }
}

