/*
 * Decompiled with CFR 0.152.
 */
package net.lucky_dip.hamleditor.editor.scanners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.lucky_dip.hamleditor.editor.scanners.IAbstractManagedScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class CompositeTokenScanner
implements ITokenScanner,
IAbstractManagedScanner {
    protected IPartitionTokenScanner fPartitionScanner;
    protected Map fTokenScanners;
    protected LinkedList fTokensInfo;
    protected Object[] fCurTokenInfo;

    public CompositeTokenScanner(IPartitionTokenScanner partitionScanner) {
        this.fPartitionScanner = partitionScanner;
        this.fTokenScanners = this.createTokenScanners();
        this.fTokensInfo = new LinkedList();
    }

    protected Map createTokenScanners() {
        return new HashMap();
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        for (IAbstractManagedScanner scanner : this.fTokenScanners.values()) {
            if (!scanner.affectsBehavior(event)) continue;
            scanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        boolean affects = false;
        for (IAbstractManagedScanner scanner : this.fTokenScanners.values()) {
            boolean bl = affects = affects || scanner.affectsBehavior(event);
        }
        return affects;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fPartitionScanner.setRange(document, offset, length);
        Collection parts = this.partitionRange(document, offset, length);
        this.tokenizePartitions(document, offset, length, parts);
    }

    protected Collection partitionRange(IDocument document, int offset, int length) {
        ArrayList<Object[]> parts = new ArrayList<Object[]>();
        IToken pTok = this.fPartitionScanner.nextToken();
        while (!pTok.isEOF()) {
            String pType = (String)pTok.getData();
            int tokLength = this.fPartitionScanner.getTokenLength();
            int tokOffset = this.fPartitionScanner.getTokenOffset();
            if (pType == null) {
                while (pType == null && !pTok.isEOF()) {
                    pTok = this.fPartitionScanner.nextToken();
                    pType = (String)pTok.getData();
                    tokLength += this.fPartitionScanner.getTokenLength();
                }
                parts.add(new Object[]{"__dftl_partition_content_type", new Integer(tokOffset), new Integer(tokLength -= this.fPartitionScanner.getTokenLength())});
                tokLength = this.fPartitionScanner.getTokenLength();
                tokOffset = this.fPartitionScanner.getTokenOffset();
            }
            if (!pTok.isEOF()) {
                parts.add(new Object[]{pType, new Integer(tokOffset), new Integer(tokLength)});
            }
            pTok = this.fPartitionScanner.nextToken();
        }
        return parts;
    }

    protected void tokenizePartitions(IDocument document, int offset, int length, Collection parts) {
        for (Object[] pInfo : parts) {
            String pType = (String)pInfo[0];
            Integer tokOffset = (Integer)pInfo[1];
            Integer tokLength = (Integer)pInfo[2];
            ITokenScanner tScan = (ITokenScanner)this.fTokenScanners.get(pType);
            tScan.setRange(document, tokOffset.intValue(), tokLength.intValue());
            IToken tk = tScan.nextToken();
            Integer tkLength = new Integer(tScan.getTokenLength());
            Integer tkOffset = new Integer(tScan.getTokenOffset());
            while (!tk.isEOF()) {
                Object[] tkInfo = new Object[]{tk, tkOffset, tkLength};
                this.fTokensInfo.add(tkInfo);
                tk = tScan.nextToken();
                tkLength = new Integer(tScan.getTokenLength());
                tkOffset = new Integer(tScan.getTokenOffset());
            }
        }
        Object[] eofInfo = new Object[]{Token.EOF, new Integer(offset + length), new Integer(0)};
        this.fTokensInfo.add(eofInfo);
    }

    public IToken nextToken() {
        this.fCurTokenInfo = (Object[])this.fTokensInfo.removeFirst();
        IToken ctok = (IToken)this.fCurTokenInfo[0];
        return ctok;
    }

    public int getTokenOffset() {
        Integer to = (Integer)this.fCurTokenInfo[1];
        return to;
    }

    public int getTokenLength() {
        Integer tl = (Integer)this.fCurTokenInfo[2];
        return tl;
    }
}

